<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/

$route['en/api'] = 'Web_api/index';
$route['en/api/load_yt_video_comments'] = 'Web_api/load_yt_video_comments';

# Image resizer
$route['images/(:any)/(:any)'] = 'Image_resizer/index/$1/$2';
$route['slide/(:any)/(:any)'] = 'Image_resizer/slide/$1/$2';

$route['store/images/(:any)/(:any)'] = 'Image_resizer/index/$1/$2';
$route['store/slide/(:any)/(:any)'] = 'Image_resizer/slide/$1/$2';

# Websitete
$route['default_controller'] = 'Web_welcome';
$route['(:any)/protocol'] = 'Web_welcome/protocol';

$route['(:any)/member/(:any)'] = 'Web_membership/index/$1/$2';
$route['(:any)/download/(:any)'] = 'Web_download/index/$1/$2';

//default home
$route['(:any)/home'] = 'Web_home/index/$1';

$route['(:any)/category/(:any)'] = 'Web_category/index/$1/$2';
$route['(:any)/category'] = 'Web_category/index/$1/';


$route['store/(:any)/products/(:num)'] = 'Web_product/index/$1/$2';
$route['(:any)/products/(:num)'] = 'Web_product/index/$1/$2';

$route['(:any)/cart'] = 'Web_cart/index/$1';
$route['(:any)/cart/delete'] = 'Web_cart/delete/$1';
$route['(:any)/cart/update'] = 'Web_cart/update/$1';
$route['(:any)/cart/ajaxcart'] = 'Web_cart/ajaxcart/$1';
$route['(:any)/cart/shipping_cost'] = 'Web_cart/ajax_get_shipping_cost/$1';
$route['(:any)/cart/test'] = 'Web_cart/test/$1';
$route['(:any)/cart/ajax_toolbar'] = 'Web_cart/ajax_toolbar/$1';
$route['(:any)/cart/ajax_toolbar_button/(:any)'] = 'Web_cart/ajax_toolbar_button/$1/$2';

$route['shop/category/(:any)'] = 'Web_category/index/en/$1';
$route['shop/products/(:num)'] = 'Web_product/index/en/$2';


$route['(:any)/blog'] = 'Web_blog/index/$1';
$route['(:any)/blog/(:any)'] = 'Web_blog/info/$1/$2';
$route['(:any)/blog/category/(:any)'] = 'Web_blog/category/$1/$2';
$route['(:any)/blog/user/(:any)'] = 'Web_blog/user/$1/$2';

$route['(:any)/register'] = 'Web_register/index/$1';
$route['(:any)/login'] = 'Web_login/index/$1';
$route['(:any)/forgot'] = 'Web_forgot/index/$1';
$route['(:any)/reset/(:any)'] = 'Web_forgot/reset_password/$1/$2';

$route['(:any)/checkout'] = 'Web_checkout/index/$1';
$route['(:any)/checkout/paypal'] = 'Web_checkout/paypal/$1';
$route['(:any)/checkout/paypal-subscription'] = 'Web_checkout/paypal_subscription/$1';


$route['stripe'] = 'Web_stripe/index'; // webhook stripe!!!
$route['(:any)/stripe/thankyou'] = 'Web_thankyou/stripe/$1';
$route['(:any)/stripe/thankyou-subscription'] = 'Web_thankyou/stripe_subscription/$1';


$route['(:any)/account'] = 'Web_account/index/$1';
$route['(:any)/account/history'] = 'Web_account/history/$1';
$route['(:any)/account/payment'] = 'Web_account/payment/$1';
# Account Subscription
$route['(:any)/account/subscription'] = 'Web_account_subscription/index/$1';
$route['(:any)/account/subscription/info'] = 'Web_account_subscription/info/$1';
$route['(:any)/account/subscription/unsubscribe'] = 'Web_account_subscription/unsubscribe/$1';
# Account Recurring Payment
$route['(:any)/account/recurring-payment'] = 'Web_account_recurring_payment/index/$1';
$route['(:any)/account/recurring-payment/transaction'] = 'Web_account_recurring_payment/transaction/$1';
$route['(:any)/account/recurring-payment/transactions'] = 'Web_account_recurring_payment/transactions/$1';

$route['(:any)/logout'] = 'Web_logout/index/$1';

$route['(:any)/wishlist'] = 'Web_wishlist/index/$1';
$route['(:any)/wishlist/mywishlist'] = 'Web_wishlist/mywishlist/$1';
$route['(:any)/wishlist/delete'] = 'Web_wishlist/delete/$1';

// webhook paypal!!!
// depends files of this webhook
$route['(:any)/paypal/ipn'] = 'Web_paypal/ipn/$1';// webhook paypal!!!
$route['(:any)/paypal/cancel'] = 'Web_paypal/cancel/$1';
$route['(:any)/paypal/thankyou'] = 'Web_thankyou/paypal/$1';
$route['(:any)/paypal/thankyou-subscription/(:any)'] = 'Web_thankyou/paypal_subscription/$1/$2';

//rss
$route['(:any)/rss/blog'] = 'Web_rss/blog/$1';// blog rss

$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
