<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Web_account extends CI_Controller
{
	public $title_personal_information = 'Personal Information';
	public $title_billing_history = 'Billing History';
	public $title_payment = 'Payment';

	function index($lang)
	{
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		
		if($sess[0]->login == false){
			echo 'Access Denied';
			exit;
		}
		
		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$country = $this->input->get('country');		
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		
		if($this->input->post('save')){
			
			$member_id = $sess[0]->member_id;
			
			$arr['firstname'] = $this->input->post('firstname');
			$arr['lastname'] = $this->input->post('lastname');
			$arr['password'] = $this->input->post('password');
			$arr['address'] = $this->input->post('address');
			$arr['city'] = $this->input->post('city');
			$arr['state'] = $this->input->post('state');
			$arr['zipcode'] = $this->input->post('zipcode');
			$arr['country'] = $this->input->post('country');
			$arr['phone'] = $this->input->post('phone');
			$arr['fax'] = $this->input->post('fax');
			
			$delivery = json_encode($this->input->post('delivery'));
			
			$arr['delivery'] = $delivery;
			
			$this->Member->update($member_id, $arr);
			
			header('location:'.base_url().$sess[0]->lang.'/account?save=1');
			exit;
		}
		
		$member = $this->Member->get_id($sess[0]->member_id);
		$cart = $this->Cart->get($sess[0]->session_id);
		$languages = $this->Language->get_active();

		$this->lang->load('var_lang.php', $lang);

		$data['web_module'] = $this->title_personal_information;
		$data['sess']		 = $sess;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['category'] = $category;
		$data['save'] = $this->input->get('save');
		$data['delete'] = $this->input->get('delete');
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['country'] = $this->Country->get();
		$data['member'] = $member;
		$data['cart'] = $cart;
		$data['languages'] = $languages;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();		
		
		$this->load->view('website/page.account.php', $data);
	}
	
	function history($lang)
	{
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		
		if($sess[0]->login == false){
			echo 'Access Denied';
			exit;
		}
		
		
		
		
		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$country = $this->input->get('country');		
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$member = $this->Member->get_id($sess[0]->member_id);
		$page = $this->input->get('page');
		if($page == false){ $page = 1;}
		
		
		switch($this->input->get('field'))
		{
			case'id';
				$field = $this->input->get('field');
			break;
			case'customer';
				$field = $this->input->get('field');
			break;
			case'customer_email';
				$field = $this->input->get('field');
			break;
			case'cost';
				$field = $this->input->get('field');
			break;
			case'tax';
				$field = $this->input->get('field');
			break;
			case'delivery';
				$field = $this->input->get('field');
			break;
			case'total';
				$field = $this->input->get('field');
			break;
			case'payment_entered';
				$field = $this->input->get('field');
			break;
			default:
				$field = 'id';
		}
	
		if($this->input->get('sort') == 'ASC'){
			$sort = 'DESC';
		}else{
			$sort = 'ASC';
		}

		$cart = $this->Cart->get($sess[0]->session_id);
		$languages = $this->Language->get_active();

		$data['web_module'] = $this->title_billing_history;
		$data['sess']		 = $sess;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['category'] = $category;
		$data['save'] = $this->input->get('save');
		$data['delete'] = $this->input->get('delete');
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['country'] = $this->Country->get();
		$data['member'] = $member;		
		$data['payment'] = $this->Payment->get_payment_by_email($member[0]->email);
		$data['field'] = $field;
		$data['sort'] = $sort;
		$data['page'] = $page;
		$data['cart'] = $cart;
		$data['languages'] = $languages;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();			

		$this->lang->load('var_lang.php', $lang);
		$this->load->view('website/page.account.history.php', $data);
	}
	
	function payment($lang)
	{
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		
		if($sess[0]->login == false){
			echo 'Access Denied';
			exit;
		}
		
		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$country = $this->input->get('country');		
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$member = $this->Member->get_id($sess[0]->member_id);
		$id = $this->input->get('id');
		$cart = $this->Cart->get($sess[0]->session_id);
		$page = $this->input->get('page');
		if($page == false){ $page = 1;}

		switch($this->input->get('field')){
			case'id';
				$field = $this->input->get('field');
			break;
			case'customer';
				$field = $this->input->get('field');
			break;
			case'customer_email';
				$field = $this->input->get('field');
			break;
			case'cost';
				$field = $this->input->get('field');
			break;
			case'tax';
				$field = $this->input->get('field');
			break;
			case'delivery';
				$field = $this->input->get('field');
			break;
			case'total';
				$field = $this->input->get('field');
			break;
			case'payment_entered';
				$field = $this->input->get('field');
			break;
			default:
				$field = '';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'DESC';
		}else{
			$sort = 'ASC';
		}

		$data['web_module'] = $this->title_payment;
		$data['sess']		 = $sess;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['category'] = $category;
		$data['save'] = $this->input->get('save');
		$data['delete'] = $this->input->get('delete');
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['country'] = $this->Country->get();
		$data['member'] = $member;		
		$data['payment'] = $this->Payment->get_payment_by_member($member[0]->member_id, $id);
		$data['cart'] = $cart;
		$data['languages'] = $this->Language->get_active();
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();
		$data['page'] = $page;
		$data['field'] = $field;
		$data['sort'] = $sort;

		$this->lang->load('var_lang.php', $lang);
		$this->load->view('website/page.account.payment.php', $data);
	}
}