<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Web_account_recurring_payment extends CI_Controller
{
    public $title_recurring_payment = 'Recurring Payment';
    public $title_transaction = 'Transaction';

    function index($lang)
    {
        $session_id = $this->Session->getcode();
        $sess = $this->Session->web_track($session_id);

        if($sess[0]->login == false){
            echo 'Access Denied';
            exit;
        }

        $property = $this->Property->get();
        $language = $this->Language->get_2code($lang);
        $sumcart = $this->Cart->get_sum($sess[0]->session_id);
        $category = $this->Category->get_active_category_tree($language[0]->code, $property);
        $member = $this->Member->get_id($sess[0]->member_id);
        $cart = $this->Cart->get($sess[0]->session_id);
        $languages = $this->Language->get_active();

        $page = $this->input->get('page');
        if($page == false){ $page = 1; }

        switch($this->input->get('field')){
            case'id':
                $field = $this->input->get('field');
                break;
            case'id_transaction':
                $field = $this->input->get('field');
                break;
            case'id_subscription':
                $field = $this->input->get('field');
                break;
            case'payment_status':
                $field = $this->input->get('field');
                break;
            case'payment_updated':
                $field = $this->input->get('field');
                break;
            case'payment_entered':
                $field = $this->input->get('field');
                break;
            //----------------
            case'name':
                $field = $this->input->get('field');
                break;
            case'customer_email':
                $field = $this->input->get('field');
                break;
            case'type':
                $field = $this->input->get('field');
                break;
            default:
                $field = '';
        }

        if($this->input->get('sort') == 'ASC'){
            $sort = 'DESC';
        }else{
            $sort = 'ASC';
        }

        $data['web_module'] = $this->title_recurring_payment;
        $data['language'] = $language;
        $data['category'] = $category;
        $data['currency'] = $this->Currency->get_array();
        $data['sumcart'] = $sumcart;
        $data['country'] = $this->Country->get();
        $data['member'] = $member;
        $data['cart'] = $cart;

        $data['payment'] = $this->Recurring_payment->get_with_subscr_info_by_email($member[0]->email);

        $data['sess'] = $sess;
        $data['property'] = $property;
        $data['page'] = $page;
        $data['sort'] = $sort;
        $data['field'] = $field;
        $data['languages'] = $languages;
        $data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
        $data['shipping_available'] = $this->Shipping->get_available_country();

        $this->lang->load('var_lang.php', $lang);
        $this->load->view('website/page.account.recurring.payment.php', $data);
    }

    function transaction($lang)
    {
        $session_id = $this->Session->getcode();
        $sess = $this->Session->web_track($session_id);

        if($sess[0]->login == false){
            echo 'Access Denied';
            exit;
        }

        $property = $this->Property->get();
        $language = $this->Language->get_2code($lang);
        $sumcart = $this->Cart->get_sum($sess[0]->session_id);
        $category = $this->Category->get_active_category_tree($language[0]->code, $property);
        $member = $this->Member->get_id($sess[0]->member_id);
        $cart = $this->Cart->get($sess[0]->session_id);
        $languages = $this->Language->get_active();

        $data['web_module'] = $this->title_transaction;
        $data['language'] = $language;
        $data['category'] = $category;
        $data['currency'] = $this->Currency->get_array();
        $data['sumcart'] = $sumcart;
        $data['country'] = $this->Country->get();
        $data['member'] = $member;
        $data['cart'] = $cart;

        $id = $this->input->get('id');
        $data['transaction'] = $this->Recurring_payment->get_transaction_with_subscr_info_by_member($member[0]->email, $id);
        
        $data['sess'] = $sess;
        $data['property'] = $property;
        $data['languages'] = $languages;
        $data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
        $data['shipping_available'] = $this->Shipping->get_available_country();

        $this->lang->load('var_lang.php', $lang);
        $this->load->view('website/page.account.recurring.payment.transaction.php', $data);
    }

    function transactions($lang)
    {
        $session_id = $this->Session->getcode();
        $sess = $this->Session->web_track($session_id);

        if($sess[0]->login == false){
            echo 'Access Denied';
            exit;
        }

        $property = $this->Property->get();
        $language = $this->Language->get_2code($lang);
        $sumcart = $this->Cart->get_sum($sess[0]->session_id);
        $category = $this->Category->get_active_category_tree($language[0]->code, $property);
        $member = $this->Member->get_id($sess[0]->member_id);
        $cart = $this->Cart->get($sess[0]->session_id);
        $languages = $this->Language->get_active();

        $page = $this->input->get('page');
        if($page == false){ $page = 1; }

        switch($this->input->get('field')){
            case'id':
                $field = $this->input->get('field');
                break;
            case'id_transaction':
                $field = $this->input->get('field');
                break;
            case'id_subscription':
                $field = $this->input->get('field');
                break;
            case'payment_status':
                $field = $this->input->get('field');
                break;
            case'payment_updated':
                $field = $this->input->get('field');
                break;
            case'payment_entered':
                $field = $this->input->get('field');
                break;
            //----------------
            case'name':
                $field = $this->input->get('field');
                break;
            case'customer_email':
                $field = $this->input->get('field');
                break;
            case'type':
                $field = $this->input->get('field');
                break;
            default:
                $field = '';
        }

        if($this->input->get('sort') == 'ASC'){
            $sort = 'DESC';
        }else{
            $sort = 'ASC';
        }

        $data['web_module'] = $this->title_recurring_payment;
        $data['language'] = $language;
        $data['category'] = $category;
        $data['currency'] = $this->Currency->get_array();
        $data['sumcart'] = $sumcart;
        $data['country'] = $this->Country->get();
        $data['member'] = $member;
        $data['cart'] = $cart;

        $id_subscr = $this->input->get('sub');
        $data['payment'] = $this->Recurring_payment->get_with_subscr_info_by_email_and_id_subscr($member[0]->email, $id_subscr);
        $data['subscription'] = $this->Subscription->get_id($id_subscr);

        $data['sess'] = $sess;
        $data['property'] = $property;
        $data['sub'] = $id_subscr;
        $data['page'] = $page;
        $data['sort'] = $sort;
        $data['field'] = $field;
        $data['languages'] = $languages;
        $data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
        $data['shipping_available'] = $this->Shipping->get_available_country();

        $this->lang->load('var_lang.php', $lang);
        $this->load->view('website/page.account.recurring.payments.php', $data);
    }
}