<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Web_account_subscription extends CI_Controller
{
	public $title_subscriptions = 'Subscriptions';
	public $title_subscription_info = 'Subscription Info';

	function index($lang)
	{
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);

		if($sess[0]->login == false){
			echo 'Access Denied';
			exit;
		}

		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$member = $this->Member->get_id($sess[0]->member_id);
		$cart = $this->Cart->get($sess[0]->session_id);
		$languages = $this->Language->get_active();
		
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }

		switch($this->input->get('field')){
			case'id':
				$field = $this->input->get('field');
				break;
			case'customer':
				$field = $this->input->get('field');
				break;
			case'customer_email':
				$field = $this->input->get('field');
				break;
			case'cost':
				$field = $this->input->get('field');
				break;
			case'tax':
				$field = $this->input->get('field');
				break;
			case'delivery':
				$field = $this->input->get('field');
				break;
			case'total':
				$field = $this->input->get('field');
				break;
			case'type':
				$field = $this->input->get('field');
				break;
			case'name':
				$field = $this->input->get('field');
				break;
			case'price':
				$field = $this->input->get('field');
				break;
			case'currency_subscr':
				$field = $this->input->get('field');
				break;
			case'interval':
				$field = $this->input->get('field');
				break;
			case'interval_count':
				$field = $this->input->get('field');
				break;
			case'trial_period':
				$field = $this->input->get('field');
				break;
			case'status':
				$field = $this->input->get('field');
				break;
			case'entered':
				$field = $this->input->get('field');
				break;
			default:
				$field = '';
		}

		if($this->input->get('sort') == 'ASC'){
			$sort = 'DESC';
		}else{
			$sort = 'ASC';
		}

		$data['web_module'] = $this->title_subscriptions;
		$data['language'] = $language;
		$data['category'] = $category;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['country'] = $this->Country->get();
		$data['member'] = $member;
		$data['cart'] = $cart;

		$data['subscription'] = $this->Subscription->get_subscription_by_email($member[0]->email);

		$data['sess'] = $sess;
		$data['property'] = $property;
		$data['page'] = $page;
		$data['sort'] = $sort;
		$data['field'] = $field;
		$data['languages'] = $languages;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();

		$this->lang->load('var_lang.php', $lang);
		$this->load->view('website/page.account.subscription.php', $data);
	}
	
	function info($lang)
	{
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);

		if($sess[0]->login == false){
			echo 'Access Denied';
			exit;
		}

		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$member = $this->Member->get_id($sess[0]->member_id);
		$cart = $this->Cart->get($sess[0]->session_id);
		$languages = $this->Language->get_active();

		$data['web_module'] = $this->title_subscription_info;
		$data['language'] = $language;
		$data['category'] = $category;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['country'] = $this->Country->get();
		$data['member'] = $member;
		$data['cart'] = $cart;

		$id = $this->input->get('id');
		//$subscription = $this->Subscription->get_id($id);
		//$data['subscription'] = $subscription;
		$data['subscription'] = $this->Subscription->get_subscription_by_member($member[0]->email, $id);

		$data['sess'] = $sess;
		$data['property'] = $property;
		$data['languages'] = $languages;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();

		if($this->session->flashdata('unsubscribe'))
		{
			$data['unsubscribe'] = 1;
		}

		$this->lang->load('var_lang.php', $lang);
		$this->load->view('website/page.account.subscription.info.php', $data);
	}

	function unsubscribe($lang)
	{
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);

		if($sess[0]->login == false){
			echo 'Access Denied';
			exit;
		}

		$id = $this->input->get('id');
		if($id)
		{
			$member = $this->Member->get_id($sess[0]->member_id);
			$subscription = $this->Subscription->get_subscription_by_member($member[0]->email, $id);
			if($subscription && $subscription[0]->status != STATUS_CANCELLED && $subscription[0]->canceled == DATE_TIME_EMPTY)
			{
				if($subscription[0]->type == 'PayPal')
				{
					$res = $this->unsubscribe_paypal($subscription[0]->id_subscription);
					if(!empty($res) && isset($res['ACK']) && isset($res['PROFILEID'])
						&& ($res['ACK'] == STATUS_SUCCESS) && ($res['PROFILEID'] == $subscription[0]->id_subscription))
					{
						$arr['canceled'] = date(TIME_FORMAT_DB);
						$arr['note'] = NOTE_CLIENT;
						$this->Subscription->update($id, $arr);
						$this->session->set_flashdata('unsubscribe', '1');
						header('location:'.base_url().$sess[0]->lang.'/account/subscription/info?id='.$id);
						exit;
					}else{
						header('location:'.base_url().$sess[0]->lang.'/account/subscription/info?id='.$id);
						exit;
					}
				}
				elseif($subscription[0]->type == 'Stripe')
				{
					if( $this->unsubscribe_stripe($subscription[0]->id_subscription) ){
						$this->session->set_flashdata('unsubscribe', '1');
						header('location:'.base_url().$sess[0]->lang.'/account/subscription/info?id='.$id);
						exit;
					}else{
						header('location:'.base_url().$sess[0]->lang.'/account/subscription/info?id='.$id);
						exit;
					}
				}
				$this->session->set_flashdata('unsubscribe', '1');
				header('location:'.base_url().$sess[0]->lang.'/account/subscription/info?id='.$id);
				exit;
			}
			else
			{
				header('location:'.base_url().$sess[0]->lang.'/account/subscription');
				exit;
			}
		}
		else
		{
			header('location:'.base_url().$sess[0]->lang.'/account/subscription');
			exit;
		}
	}

	function unsubscribe_paypal($id_subscr)
	{
		$paypal = $this->Payment->get_setting_type('PayPal');
		$api_credentials = json_decode($paypal[0]->detail,true);
		$action = 'Cancel';

		$api_request = 'USER=' . urlencode( $api_credentials['api_username'] )
			.  '&PWD=' . urlencode( $api_credentials['api_password'] )
			.  '&SIGNATURE=' . urlencode( $api_credentials['api_signature'] )
			.  '&VERSION=76.0'
			.  '&METHOD=ManageRecurringPaymentsProfileStatus'
			.  '&PROFILEID=' . urlencode( $id_subscr )
			.  '&ACTION=' . urlencode( $action )
			.  '&NOTE=' . urlencode( 'Profile cancelled at store ('.NOTE_CLIENT.')' );

		$ch = curl_init();

		$url = isset($api_credentials['sandbox']) ? PAYPAL_URL_API_3T_SANDBOX : PAYPAL_URL_API_3T;

		curl_setopt( $ch, CURLOPT_URL, $url );
		curl_setopt( $ch, CURLOPT_VERBOSE, 1 );
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt( $ch, CURLOPT_POST, 1 );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $api_request );// Set the API parameters for this transaction

		// Request response from PayPal
		$response = curl_exec( $ch );

		// If no response was received from PayPal there is no point parsing the response
		if( ! $response )
		{
			$error = curl_error($ch);
			$errno = curl_errno($ch);
			return false;
		}

		curl_close( $ch );

		// An associative array is more usable than a parameter string
		$parsed_response = array();
		parse_str( $response, $parsed_response );

		return $parsed_response;
	}

	function unsubscribe_stripe($id_subscr)
	{
		$stripe = $this->Payment->get_setting_type('Stripe');
		$stripe = json_decode($stripe[0]->detail,true);
		$stripe_secret_key = isset($stripe['stripe_sandbox']) ? $stripe['stripe_test_secret_key'] : $stripe['stripe_live_secret_key'];

		require_once (APPPATH.'lib/vendor/autoload.php');

		\Stripe\Stripe::setApiKey($stripe_secret_key);

		try
		{
			$subscription = \Stripe\Subscription::retrieve($id_subscr);
			//$cancel = $subscription->cancel(array('at_period_end' => true));//A flag that if set to true will delay the cancellation of the subscription until the end of the current period
			$cancel = $subscription->cancel();
			if($cancel->status == 'canceled'){
				$arr['canceled'] = date(TIME_FORMAT_DB);
				$arr_key_details = array(
					"id",
					"object",
					"application_fee_percent",
					"cancel_at_period_end",
					"canceled_at",
					"created",
					"current_period_end",
					"current_period_start",
					"customer",
					"discount",
					"ended_at",
					"items",
					"livemode",
					"metadata",
					"plan",
					"quantity",
					"start",
					"status",
					"tax_percent",
					"trial_end",
					"trial_start"
				);

				$arr_details = array();
				foreach ($arr_key_details as $detail){
					if(isset($cancel->$detail)){
						$arr_details[$detail] = $cancel->$detail;
					}
				}
				$arr['status'] = STATUS_CANCELLED;
				$arr['note'] = NOTE_CLIENT;
				$arr['cancel_detail'] = json_encode($arr_details);
				$this->Subscription->update_by_id_subscr($id_subscr, $arr);
				return true;
			}
		}
		catch (Exception $e)
		{
			//$response['error'] = '<div class="alert alert-danger"><strong>Error!</strong> '.$e->getMessage().'</div>';
			//echo json_encode($response);
			//exit;
			return false;
		}

		return false;
	}
}