<?php

class Web_blog extends CI_Controller{
	
	var $module = 'Blog';
	
	function index($lang)
	{
		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$error = 0;
		
		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$currency = $this->Currency->get_array();	
		$cart = $this->Cart->get($sess[0]->session_id);
		$page = $this->input->get('page');
		if($page == false){
			$page = 1;
		}
			
		$data['sumcart'] = $sumcart;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		//$data['seo'] = $this->Seo->get_file_type('blog');
		$data['sumcart'] = $sumcart;
		$data['currency'] = $currency;
		$data['category'] = $category;
		$data['languages'] = $this->Language->get_active();
		$data['cart'] = $cart;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();
		$data['content'] = $this->Content->get_active();
		$data['page'] = $page;

		
		
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}
		
		$data['module'] = $this->module;

		$this->load->view('website/page.blog.php', $data);
	}
	
	function info($lang, $slug)
	{
		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$error = 0;
		
		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$currency = $this->Currency->get_array();	
		$cart = $this->Cart->get($sess[0]->session_id);
		$content = $this->Content->get_slug($slug);
		$content = $this->Content->get_meta($content);

		if(empty($content)){
			header('location:'.base_url().$sess[0]->lang.'/404');
			exit;
		}
					
		$related = $this->Content->get_related($content[0]->category_id, $content[0]->article_id);
		$this->Content->update($content[0]->article_id, array('article_view'=>$content[0]->article_view+1));

		$data['sumcart'] = $sumcart;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		//$data['content'] = $this->Page->get_slug($language[0]->code, $property, 'about-us');
		$data['sumcart'] = $sumcart;
		$data['currency'] = $currency;
		$data['category'] = $category;
		$data['languages'] = $this->Language->get_active();
		$data['cart'] = $cart;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();
		$data['content'] = $content;
		$data['related'] = $related;
		$data['user'] = $this->User->get_id($content[0]->user_id);
		$data['slug'] = $slug;


		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}

		$data['gallery'] = $this->Media->get_type('image', $content[0]->article_id);
		$data['video'] = $this->Media->get_type('video', $content[0]->article_id);

		
		//load the redirect yt page
		if( $this->input->get('redirect_yt')==1 ){
			$this->load->view('website/page.blog.redirect.php',$data);
		
		} else if( $content[0]->html_data!="" && file_exists(APPPATH.'views/website/include/'.$content[0]->html_data)){
			//this blog post has additional elements and there is an include file in the file system for it, so display that.
			$this->load->view('website/page.blog.info.php',$data);	
		} else {
			//this blog post doesn't have any additional elements to it, so just load the template file.
			$this->load->view('website/page.blog.info.template.php',$data); 
		}
		
		
// 		else if($content[0]->article_allow_subcontent){
// 			$this->load->view('website/page.blog.info.parent.php',$data);
// 		}else{
// 				
// 		}
	
	}
	
	
	function category($lang, $slug)
	{
		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$error = 0;
		
		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$currency = $this->Currency->get_array();	
		$cart = $this->Cart->get($sess[0]->session_id);
		$page = $this->input->get('page');
		if($page == false){
			$page = 1;
		}
					
		$data['sumcart'] = $sumcart;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		//$data['content'] = $this->Page->get_slug($language[0]->code, $property, 'about-us');
		$data['sumcart'] = $sumcart;
		$data['currency'] = $currency;
		$data['category'] = $category;
		$data['languages'] = $this->Language->get_active();
		$data['cart'] = $cart;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();
		$data['content'] = $this->Content->get_by_category_slug($slug);
		$data['page'] = $page;
		$data['type'] = 'category';
		$data['slug'] = $slug;

		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}
		
		$data['module'] = $this->module;

		$this->load->view('website/page.blog.php', $data);
	
	}
	
	function user($lang, $firstname)
	{

		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$error = 0;
		
		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$currency = $this->Currency->get_array();	
		$cart = $this->Cart->get($sess[0]->session_id);
		$page = $this->input->get('page');
		if($page == false){
			$page = 1;
		}
					
		$data['sumcart'] = $sumcart;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		//$data['content'] = $this->Page->get_slug($language[0]->code, $property, 'about-us');
		$data['sumcart'] = $sumcart;
		$data['currency'] = $currency;
		$data['category'] = $category;
		$data['languages'] = $this->Language->get_active();
		$data['cart'] = $cart;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();
		$data['content'] = $this->Content->get_by_user($firstname);
		$data['page'] = $page;
		$data['type'] = 'user';
		$data['slug'] = $firstname;

		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}
		
		$data['module'] = $this->module;

		$this->load->view('website/page.blog.php', $data);
	
	}
}