<?php

class Web_cart extends CI_Controller
{
	
	function test($lang){

		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$this->lang->load('var_lang.php', $lang); 
		$data['sess'] = $sess;
		
		$this->load->view('website/tpl.meta.php', $data);
		//$this->load->view('website/tpl.header.php', $data);
		$this->load->view('website/include.cart.test.php', $data);
		
	}
	
	function index($lang)
	{
		$this->lang->load('var_lang.php', $lang);

		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$product_id = $this->input->get('product_id');
		
		if($product_id){
			
			$product = $this->Product->get_id($product_id);
			$unit = $this->input->get('unit');
			if($unit == false){
				$unit = 1;
			}

			//-------------------------------------
			$cart = $this->Cart->get($sess[0]->session_id);
			if(!empty($cart)){
				$different_type = false;
				$subscription_counter = false;
				foreach ($cart as $cart_item){
					//$tmp_product = $this->Product->get_id($cart_item->product_id);
					if($product[0]->product_payment_type != $cart_item->product_payment_type){
						$different_type = true;
						break;
					}elseif($product[0]->product_payment_type == 'subscription' && $cart_item->product_payment_type){
						$subscription_counter = true;
						break;
					}
				}
				if($different_type){
					echo json_encode(array('error'=>1, 'msg'=>'<p>Subscription and standard products can not be stored in the cart at the same time.</p><p>Please complete checkout for the product already in the cart and then re-add this item. </p><p> Thanks!</p>'));
					exit;
				}elseif ($subscription_counter){
					echo json_encode(array('error'=>1, 'msg'=>'<p>Multiple subscriptions cannot be simultaneously in the shopping cart.</p><p>Please complete checkout for the product already in the cart and then re-add this item. </p><p> Thanks!</p>'));
					exit;
				}
			}
			//-------------------------------------
			
			$arr['session_id'] = $session_id;
			$arr['product_id'] = $product_id;
			$arr['product_type'] = $product[0]->product_type;
			$arr['product_payment_type'] = $product[0]->product_payment_type;
			$arr['unit'] = $unit;
			$arr['cost'] = $product[0]->product_cost;
			$arr['tax'] = $product[0]->product_tax;
			$arr['total_tax'] = $product[0]->product_tax * $unit;
			$arr['price'] = $product[0]->product_price;
			$arr['total'] = $arr['price'] * $arr['unit']; 
			$arr['total_grand'] = $arr['total'] + ($arr['tax']*$arr['unit']);
			$arr['currency'] = $product[0]->product_currency;
			$arr['weight'] = $product[0]->product_weight;
			$arr['entered'] = date('Y-m-d H:i:s');
			
			if($this->input->get('option_size')){
				$options['Size'] = $this->input->get('option_size');
			}
			
			if($this->input->get('option_color')){
				$options['Color'] = $this->input->get('option_color');
			}
			
			if(isset($options)){
				$arr['options'] = json_encode($options);
			}
			
			$this->Cart->insert($arr);
			$cart = $this->Cart->get($sess[0]->session_id);
			
			echo json_encode(array('count'=>count($cart)));
			exit;
			
		}else{
			echo json_encode(array('error'=>1, 'msg'=>'Product Id is required!'));
			exit;
		}
		
	}
	
	function mycart($lang)
	{
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$country = $this->input->get('country');		
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$cart = $this->Cart->get($sess[0]->session_id);

		$this->lang->load('var_lang.php', $lang);
		
		$data['sess']		 = $sess;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['category'] = $category;
		$data['save'] = $this->input->get('save');
		$data['delete'] = $this->input->get('delete');
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['shipping_country'] = $this->Shipping->get_available_country();
		$data['country'] = $country;
		$data['cart'] = $cart;
		$data['languages'] = $this->Language->get_active();
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		
		if($country){
			$data['shipping'] = $this->Shipping->get_cost($country, $sumcart[0]->cart_weight);
		}

		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}
				
		$this->load->view('website/page.cart.php', $data);
	}
	
	function delete($lang){
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		
		$cart_id = $this->input->get('cart_id');
		$this->Cart->delete($session_id, $cart_id);
				
		//header('location:'.base_url().$sess[0]->lang.'/mycart?delete=1');
		exit;
	}
	
	function update($lang)
	{
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		
		$cart = $this->input->post('cart_id');
		$price = $this->input->post('price');
		$unit = $this->input->post('unit');
		$tax = $this->input->post('tax');
		$country = $this->input->post('country');
					
		foreach($cart as $index=>$cart_id){
			
			$arr['price'] =  $price[$index];
			$arr['unit'] = $unit[$index];
			$arr['tax'] = $tax[$index];
			$arr['total'] = $arr['price'] * $arr['unit'];
			$arr['total_tax'] = $arr['tax'] * $arr['unit'];
			
			$this->Cart->update($session_id, $cart_id, $arr);
		}
		
		if($this->input->post('save')){
			
			unset($arr);
			
			$this->Cart->delete_shipping_cart($session_id);
			
			$arr['session_id'] = $session_id;
			$arr['country'] = $this->input->post('country');
			//$arr['country'] = $this->input->post('cart_country');
			$arr['weight'] = $this->input->post('weight');
			$arr['cost'] = $this->input->post('cost');
			$arr['currency'] = $this->input->post('currency');

			$this->Cart->insert_shipping_cart($arr);
			
			header('location:'.base_url().$sess[0]->lang.'/checkout');
			exit;
		}
		
		header('location:'.base_url().$sess[0]->lang.'/mycart?save=1&country='.$country);
		exit;
	}
	
	function ajaxcart($lang)
	{
	
		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$cart = $this->Cart->get($sess[0]->session_id);

		$data['sess'] = $sess;
		$data['sumcart'] = $sumcart;
		$data['cart'] = $cart;
		$data['currency'] =  $this->Currency->get_array();
		$data['property'] = $this->Property->get();
		$data['shipping_available'] = $this->Shipping->get_available_country();		

		$this->load->view('website/tpl.cart.php', $data);
	}
	
	function ajax_get_shipping_cost($lang)
	{
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$property = $this->Property->get();
		$currency =  $this->Currency->get_array();
		
		$country = $this->input->get('country');
		$weight = $this->input->get('weight');

		$sipping_cost = $this->Shipping->get_cost($country, $weight);
		
		//echo number_format($sipping_cost[0]->rate,'0','','');
		echo money_format('%i', $sipping_cost[0]->rate);
	}
	
	function ajax_toolbar($lang)
	{
	
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$country = $this->input->get('country');		
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$cart = $this->Cart->get($sess[0]->session_id);

		$this->lang->load('var_lang.php', $lang);
		
		$data['sess']		 = $sess;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['shipping_country'] = $this->Shipping->get_available_country();
		$data['country'] = $country;
		$data['cart'] = $cart;
		$data['languages'] = $this->Language->get_active();
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();	
		
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}
		$this->load->view('website/include.cart.dropdowns.php', $data);
	
	}
	function ajax_toolbar_button( $lang, $type)
	{
	
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$country = $this->input->get('country');		
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$cart = $this->Cart->get($sess[0]->session_id);

		$this->lang->load('var_lang.php', $lang);
		
		$data['sess']		 = $sess;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['shipping_country'] = $this->Shipping->get_available_country();
		$data['country'] = $country;
		$data['cart'] = $cart;
		$data['languages'] = $this->Language->get_active();
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		
	switch($type) {
	
		case 'wish':
			$output = '<a id="toolbar-wish" href="#wish" class="toolbar-toggle">'.urldecode($value).'
				<i class="">
					<span class="material-icons favorite_border"></span> 
					<span id="count-wish" class="count"'. ( count($wishlist) == false ? 'style="display:none;"' : '' ) .'>'. count($wishlist) .'</span> 
				</i>
			  </a>';
			break;
		case 'account':
		
			$output = '<a id="toolbar-account" href="#account" class="toolbar-toggle"><i class="fa fa-user"></i><span class="button-val"></span></a>';
			break;
			
		case 'cart':
		
			$output = '<a id="toolbar-cart" href="#cart" class="toolbar-toggle"> '.urldecode($value).'
						<i> 
							<span class="fa fa-shopping-cart"></span> 
							<span class="button-val"></span>
							<span id="count-cart" class="count"' . (count($cart) == false ? 'style="display:none;"' : '') .'>'. count($cart) .'</span> 
						</i> 
					  </a>';
  
	}
  
		echo $output;
		
		//$this->load->view('website/include.cart.buttons.php', $data);
	
	}
}