<?php

class Web_category extends CI_Controller{

	var $module = 'Categories';

	function index($lang, $slug)
	{

		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }

		$language = $this->Language->get_2code($lang);
		$languages = $this->Language->get_active();
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$cart = $this->Cart->get($sess[0]->session_id);
		$current_category = $this->Category->get_slug($language[0]->code, $property, $slug);
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$pricerange = $this->Product->get_pricerange($current_category[0]->category_id);
		
		switch($this->input->get('field')){
			case'product_name';
				$field = $this->input->get('field');
			break;
			case'product_price';
				$field = $this->input->get('field');
			break;
			case'product_id';
				$field = $this->input->get('field');
			break;
			case'product_rating';
				$field = $this->input->get('field');
			break;
			default:
				$field = '';
		}
		
		if($this->input->get('sort') == 'asc'){
			$sort = 'asc';
		}else{
			$sort = 'desc';
		}
				
		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		$data['cart'] = $cart;		
		$data['currency'] = $this->Currency->get_array();
		$data['language'] = $language;
		$data['product'] = $this->Product->get_category($language[0]->code, $property, $current_category[0]->category_id);
		$data['page'] = $page;
		$data['slug'] = $slug;
		$data['category'] = $category;
		$data['sumcart'] = $sumcart;
		$data['current_category'] = $current_category;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['field'] = $field;
		$data['sort'] = $sort;
		$data['languages'] = $languages;
		$data['shipping_available'] = $this->Shipping->get_available_country();
		$data['pricerange'] = $pricerange;
		$data['count_active_product'] = $this->Product->count_active_product();
		
		
		if($this->input->get('min_price')){
			$data['min_price'] = $this->input->get('min_price');
		}else{
			$data['min_price'] = $pricerange[0]->min_price;
		}
		
		if($this->input->get('max_price')){
			$data['max_price'] = $this->input->get('max_price');
		}else{
			$data['max_price'] = $pricerange[0]->max_price;		
		}

		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}
		
		$data['q'] = $this->input->get('q');
		
				
		$this->load->view('website/product.category.php',$data);
	
	}

}