<?php

class Web_checkout extends CI_Controller
{
	public $module = 'checkout';
	
	function subscription($lang)
	{
		$this->lang->load('var_lang.php', $lang);

		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);

		$cart = $this->Cart->get($sess[0]->session_id);
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$payment = $this->Payment->get_type();
		$property = $this->Property->get();

		//-------- stripe settings ----------
		$stripe = $this->Payment->get_setting_type('Stripe');
		$stripe = json_decode($stripe[0]->detail,true);
		$stripe_secret_key = isset($stripe['stripe_sandbox']) ? $stripe['stripe_test_secret_key'] : $stripe['stripe_live_secret_key'];
		$stripe_public_key = isset($stripe['stripe_sandbox']) ? $stripe['stripe_test_public_key'] : $stripe['stripe_live_public_key'];
		$data['stripe_secret_key'] = $stripe_secret_key;
		$data['stripe_public_key'] = $stripe_public_key;
		//-------- end stripe settings ------

		if($this->input->post('save'))
		{
			$customer['firstname'] = $this->input->post('firstname');
			$customer['lastname'] = $this->input->post('lastname');
			$customer['address'] = $this->input->post('address');
			$customer['city'] = $this->input->post('city');
			$customer['state'] = $this->input->post('state');
			$customer['zipcode'] = $this->input->post('zipcode');
			$customer['country'] = $this->input->post('country');
			$customer['phone'] = $this->input->post('phone');
			$customer['fax'] = $this->input->post('fax');

			$delivery = $this->input->post('delivery');

			foreach($cart as $index=>$value){
				$items[$index]['id'] = $value->product_id;
				$items[$index]['code'] = $value->product_code;
				$items[$index]['name'] = $value->product_name;
				$items[$index]['options'] = $value->options;
				$items[$index]['unit'] = $value->unit;
				$items[$index]['unit_price'] = $value->price;
				$items[$index]['total_cost'] = $value->price * $value->unit;
				$items[$index]['total_tax'] = $value->total_tax;
				$items[$index]['total'] = $value->total;
			}

			$delivery_cost = $this->Shipping->get_cart_shipping($sess[0]->session_id);

			$arr['member_id'] = $sess[0]->member_id;
			$arr['customer'] = json_encode($customer);
			$arr['customer_email'] = $this->input->post('email');
			$arr['customer_delivery'] = json_encode($delivery);
			$arr['item'] = json_encode($items);
			$arr['cost'] = $sumcart[0]->cart_total;
			$arr['tax'] = $sumcart[0]->cart_tax;
			$arr['delivery'] = $delivery_cost[0]->cost;
			$arr['total'] = $sumcart[0]->cart_total + $delivery_cost[0]->cost;
			$arr['currency'] = $sumcart[0]->currency;
			$arr['type'] = $this->input->post('payment_type');
			//$arr['payment_entered'] = date('Y-m-d H:i:s');
			//$arr['status'] = 'Pending';
			//$id = $this->Payment->insert($arr);

			switch($this->input->post('payment_type'))
			{
				case'PayPal':
				{
					$arr['entered'] = date('Y-m-d H:i:s');
					$arr['status'] = 'Pending';

					$billing_plan = $this->Plan->get_billing_plan($this->input->post('billing_plan'), 'PayPal');
					$arr['id_billing_plan'] = $billing_plan[0]->id;//ID from table cms_billing_plan

					$arr['name'] = $billing_plan[0]->name;
					$arr['billing_plan_name'] = $billing_plan[0]->name;
					$arr['price'] = $billing_plan[0]->price;
					$arr['currency_subscr'] = $billing_plan[0]->currency;
					$arr['interval'] = $billing_plan[0]->interval;
					$arr['interval_count'] = $billing_plan[0]->interval_count;
					$arr['trial_period'] = $billing_plan[0]->trial_period;
					$arr['subscr_detail'] = json_encode($billing_plan[0]);

					$id = $this->Subscription->insert($arr);
					$tmp_id_subscr = 'tmp_'.$id.'_'.time();
					$this->Subscription->update($id, array('id_subscription'=>$tmp_id_subscr));

					header('location:'.base_url().$sess[0]->lang.'/checkout/paypal-subscription?id=' . $id);
					exit;
				}
				case'Stripe':
				{
					$data['sess'] = $sess;
					$this->stripe_subscription($data, $arr);
					return;
				}
				default:
					break;
			}
		}

		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}
		
		$data['module'] = $this->module;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['category'] = $category;
		$data['shipping'] = $this->Cart->get_shipping_cost($session_id);
		$data['country'] = $this->Country->get();
		$data['payment'] = $payment;
		$data['payment_setting'] = $this->Payment->get_setting_arr();
		$data['cart'] = $cart;
		$data['property'] = $property;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();
		$data['languages'] = $this->Language->get_active();
		$data['seo'] = $this->Seo->get_lang($language[0]->code);
		
		$product_plan_ids = $this->Product_plan->get_array_ids_plan_by_id_product($cart[0]->product_id);
		$data['product_plans'] = $this->Plan->get_ids($product_plan_ids);
		
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}

		$this->load->view('website/page.checkout.subscription.php', $data);
	}

	function index($lang)
	{
		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$cart = $this->Cart->get($sess[0]->session_id);

		if(empty($cart)){
			header('location: '.base_url().$sess[0]->lang.'/home');
			exit;
		}elseif(!empty($cart)){
			$subscription_counter = false;
			foreach ($cart as $cart_item){
				if( $cart_item->product_payment_type == 'subscription' ){
					$subscription_counter = true;
					break;
				}
			}
			if($subscription_counter){
				$this->subscription($lang);
				return;
			}
		}

		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$payment = $this->Payment->get_type();
		$property = $this->Property->get();

		//-------- stripe settings ----------
//		$stripe = $this->Payment->get_setting_type('Stripe');
//		$stripe = json_decode($stripe[0]->detail,true);
//		$stripe_secret_key = isset($stripe['stripe_secret_key']) ? $stripe['stripe_secret_key'] : '';
//		$stripe_public_key = isset($stripe['stripe_public_key']) ? $stripe['stripe_public_key'] : '';
//		$data['stripe_secret_key'] = $stripe_secret_key;
//		$data['stripe_public_key'] = $stripe_public_key;

		$stripe = $this->Payment->get_setting_type('Stripe');
		$stripe = json_decode($stripe[0]->detail,true);
		$stripe_secret_key = isset($stripe['stripe_sandbox']) ? $stripe['stripe_test_secret_key'] : $stripe['stripe_live_secret_key'];
		$stripe_public_key = isset($stripe['stripe_sandbox']) ? $stripe['stripe_test_public_key'] : $stripe['stripe_live_public_key'];
		$data['stripe_secret_key'] = $stripe_secret_key;
		$data['stripe_public_key'] = $stripe_public_key;
		//-------- end stripe settings ------

		//login not necessary! because login working AJAX on checkout page
//		if($this->input->post('login')){
//
//			$email = $this->input->post('email');
//			$password = $this->input->post('password');
//
//			$rs = $this->Member->check_member_email_password($email, $password);
//			$arr['member_id'] = $rs[0]->member_id;
//			$arr['login']= 1;
//
//			$this->Session->web_track_update($session_id, $arr);
//
//			header('location: '.base_url().$sess[0]->lang.'/checkout');
//			exit;
//		}
		//end login
		
		if($this->input->post('save')){
			
			//$cart = $this->Cart->get($sess[0]->session_id);
			
			$customer['firstname'] = $this->input->post('firstname');
			$customer['lastname'] = $this->input->post('lastname');
			$customer['address'] = $this->input->post('address');
			$customer['city'] = $this->input->post('city');
			$customer['state'] = $this->input->post('state');
			$customer['zipcode'] = $this->input->post('zipcode');
			$customer['country'] = $this->input->post('country');
			$customer['phone'] = $this->input->post('phone');
			$customer['fax'] = $this->input->post('fax');
			
			$delivery = $this->input->post('delivery');
			
			foreach($cart as $index=>$value){
				$items[$index]['id'] = $value->product_id;
				$items[$index]['code'] = $value->product_code;
				$items[$index]['name'] = $value->product_name;
				$items[$index]['options'] = $value->options;
				$items[$index]['unit'] = $value->unit;
				$items[$index]['unit_price'] = $value->price;
				$items[$index]['total_cost'] = $value->price * $value->unit;
				$items[$index]['total_tax'] = $value->total_tax;
				$items[$index]['total'] = $value->total;
			}
			
			$delivery_cost = $this->Shipping->get_cart_shipping($sess[0]->session_id);
			
			$arr['member_id'] = $sess[0]->member_id;
			$arr['customer'] = json_encode($customer);
			$arr['customer_email'] = $this->input->post('email');
			$arr['customer_delivery'] = json_encode($delivery);
			$arr['item'] = json_encode($items);
			$arr['cost'] = $sumcart[0]->cart_total;
			$arr['tax'] = $sumcart[0]->cart_tax; 
			$arr['delivery'] = $delivery_cost[0]->cost;
			$arr['total'] = $sumcart[0]->cart_total + $delivery_cost[0]->cost; 		
			$arr['currency'] = $sumcart[0]->currency;
			$arr['payment_type'] = $this->input->post('payment_type');
			$arr['payment_entered'] = date('Y-m-d H:i:s');
			$arr['payment_status'] = 'Pending';
			$id = $this->Payment->insert($arr);
			
			switch($this->input->post('payment_type'))
			{
				case'PayPal';
					header('location:'.base_url().$sess[0]->lang.'/checkout/paypal?id=' . $id);
					exit;
				break;
				case'Stripe':
				{
					$data['property'] = $property;
					$data['language'] = $language;
					$data['sess'] = $sess;
					$data['currency'] = $this->Currency->get_array();
					$data['sumcart'] = $sumcart;
					$data['category'] = $category;
					$data['invoice'] = $this->Payment->get_id($id);
					//-----
					$data['shipping'] = $this->Cart->get_shipping_cost($session_id);
					$data['country'] = $this->Country->get();
					$data['payment'] = $payment;
					$data['payment_setting'] = $this->Payment->get_setting_arr();
					//------
					$data['cart'] = $cart;
					$data['property'] = $property;
					$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
					$data['languages'] = $this->Language->get_active();
					$data['shipping_available'] = $this->Shipping->get_available_country();
					if($sess[0]->member_id){
						$data['member'] = $this->Member->get_id($sess[0]->member_id);
					}

					$this->stripe($id, $data, $arr);
					return;
				}
				break;
				case'Skrill';
					header('location:'.base_url().$sess[0]->lang.'/checkout/skrill?id=' . $id);
					exit;
				break;
				default;
					
					if($this->input->post('payment_type') == 'Credit Card'){
						$card['card'] = $this->input->post('card');
						$card['card_number'] = $this->input->post('card_number');
						$card['card_bank_issue'] = $this->input->post('card_bank_issue');
						$card['card_holder'] = $this->input->post('card_holder');
						$card['card_cvc'] = $this->input->post('card_cvc');
						
						$arr_update = array('payment_detail'=>json_encode($card));
						$this->Payment->update($id, $arr_update);
					}else{
						$arr_update = array('payment_detail'=>'Bank Transfer');
						$this->Payment->update($id, $arr_update);
					}
					
					$subject = $property[0]->property_name.' - Payment Completed #invoice '.$id;
					$from = 'administrator@'.str_replace(array('http://www.', 'http://'),'', $property[0]->property_website);
					$to = $this->input->post('email');
					
					$message = "<p>";
					$message .= "Thank you for shopping with us. We have received your order and it is currently being processed.";
					$message .= "</p>";
					$message .= '<p style="font-size: 12px;"><strong>Customer information</strong></p>';
					$message .= '<hr>';					
					$message .= '<p style="font-size: 12px;">';
					
					$country = $this->Country->get_code($customer['country']);
					$currency = $this->Currency->get_code($arr['currency']);
					
					$message .= $customer['firstname'] .' '.$customer['lastname'].'<br>';
					$message .= '<strong>Address</strong>: ';
					$message .= $customer['address'] .' '. $customer['city']. ' '.$customer['state'] ;
					$message .= $customer['zipcode']. ' '.$country[0]->name. ' ';
					$message .= '<br>';
					$message .= '<strong>Phone</strong>: '.$customer['phone'].' ';
					if($customer['fax']){
						$message .= '<strong>Fax</strong>: '.$customer['fax'].' ';
					}
					$message .= '<strong>Email</strong>: <a href="mailto:'.$arr['customer_email'].'">'.$arr['customer_email'].'</a>';
					$message .= '</p>';
					
					$message .= '<p style="font-size: 12px;"><strong>Order Information</strong></p>';
					$message .= '<hr>';					
					$message .= '<table width="100%">';
					$message .= '<tr>';
					$message .= '<td style="font-weight:bold; font-size: 12px;">Product Name</td>';
					$message .= '<td style="font-weight:bold; font-size: 12px;">Qty.</td>';
					$message .= '<td style="font-weight:bold; font-size: 12px;" nowrap>Unit Price</td>';
					$message .= '<td style="font-weight:bold; font-size: 12px;">Cost</td>';
					$message .= '<td style="font-weight:bold; font-size: 12px;">Tax</td>';
					$message .= '<td style="font-weight:bold; font-size: 12px;">Total</td>';
					$message .= '</tr>';
					foreach($items as $index=>$value){
						
						$options = json_decode($value['options'],true);
						
						$message .= '<tr>';
						$message .= '<td style="font-size: 12px;">'.$value['code'] .  ' - ' .$value['name']. ' ';

						if(isset($options['Size'])){ $message .= ' Size : '. $options['Size']. ' ';}
						if(isset($options['Color'])){ $message .= ' Color : '.$options['Color']; }

						$message .= '</td>';
						$message .= '<td style="font-size: 12px;">'.$value['unit'].'</td>';
						$message .= '<td style="font-size: 12px;">'.$items[$index]['unit_price'].'</td>';
						$message .= '<td style="font-size: 12px;">'.$items[$index]['total_cost'].'</td>';
						$message .= '<td style="font-size: 12px;">'.$items[$index]['total_tax'].'</td>';
						$message .= '<td style="font-size: 12px;">'.$items[$index]['total'].'</td>';
						$message .= '</tr>';
					}
					$message .= '</table>';
					$message .= '<hr>';					
					$message .= '<table width="100%">';
					$message .= '<tr>';
					$message .= '<td colspan="2" align="right" style="font-size: 12px;font-weight: bold;">Total Cost</td>';
					$message .= '<td align="right" width="80" style="font-size: 12px;font-weight: bold;">'.$arr['cost'].'</td>';
					$message .= '</tr>';
					$message .= '<tr>';
					$message .= '<td colspan="2" align="right" style="font-size: 12px;font-weight: bold;">Total Tax</td>';
					$message .= '<td align="right" style="font-size: 12px;font-weight: bold;">'.$arr['tax'].'</td>';
					$message .= '</tr>';
					$message .= '<tr>';
					$message .= '<td colspan="2" align="right" style="font-size: 12px;font-weight: bold;">Shipping</td>';
					$message .= '<td align="right" style="font-size: 12px;font-weight: bold;">'.$arr['delivery'].'</td>';
					$message .= '</tr>';
					$message .= '<tr>';
					$message .= '<td style="font-size: 12px;">* Currencies are in '.$currency[0]->name.'</td>';
					$message .= '<td align="right" style="font-size: 12px;font-weight: bold;">Grand Total</td>';
					$message .= '<td align="right" style="font-size: 12px;font-weight: bold;">'.number_format($arr['total'],2,'.','').'</td>';
					$message .= '</tr>';
					$message .= '</table>';
					$message .= '<hr>';

					$rs = $this->Country->get_code($delivery['country']);
					
					$message .= '<table width="100%">';
					$message .= '<tr>';
					$message .= '<td width="120" valign="top" nowrap style="font-size: 12px;"><strong>Delivery to address</strong>: </td>';
					$message .= '<td valign="top" style="font-size: 12px;">';
					$message .= $delivery['address']. ' ';
					$message .= $delivery['city'].' ';
					$message .= $delivery['state'].' ';
					$message .= $delivery['zipcode'].' ';
					$message .= $rs[0]->name.' ';
					$message .= '</td>';
					$message .= '</tr>';
					$message .= '</table>';					
					$message .= '<br>';
					
					if($arr['payment_type'] == 'Bank Transfer'){
						$banktransfer = $this->Payment->get_setting_type('Bank Transfer');
						$message .= '<p style="font-size: 12px;">You can make payments by making transactions directly to seller\'s bank account. Details are as follow:</p>';
						$message .= '<table width="100%">';
						$message .= '<tbody>';
						$message .= '<tr>';
						$message .= '<td style="font-size: 12px;"><strong>Bank</strong></td>';
						$message .= '<td style="font-size: 12px;"><strong>Branch</strong></td>';
						$message .= '<td style="font-size: 12px;"><strong>Account number</strong></td>';
						$message .= '<td style="font-size: 12px;"><strong>Account type</strong></td>';
						$message .= '<td style="font-size: 12px;"><strong>Account name</strong></td>';
						$message .= '</tr>';

						foreach($banktransfer as $index=>$value){ 
							$arr = json_decode($value->detail, true);
							$message .= '<tr>';
							$message .= '<td style="font-size: 12px;">'.$arr['bankname'].'</td>';
							$message .= '<td style="font-size: 12px;">'.$arr['branch'].'</td>';
							$message .= '<td style="font-size: 12px;">'.$arr['accountnumber'].'</td>';
							$message .= '<td style="font-size: 12px;">'.$arr['accounttype'].'</td>';
							$message .= '<td style="font-size: 12px;">'.$arr['accountname'].'</td>';
							$message .= '</tr>';
						}
						$message .= '</tbody>';
						$message .= '</table>';						
					}

					$rs = $this->Country->get_code($property[0]->property_country);
					
					$message .= '<p style="font-size: 12px;">';
					$message .= '<strong>'.$property[0]->property_name. '</strong><br>';
					$message .= '<strong>Address</strong>: '.$property[0]->property_address. ' ';
					$message .= $property[0]->property_city. ' ';
					$message .= $property[0]->property_state. ' ';
					$message .= $property[0]->property_zipcode. ' ';
					$message .= $rs[0]->name .'<br>';
					$message .= '<strong>Phone</strong>: '.$property[0]->property_phone. ' ';
					$message .= '<strong>Fax</strong>: '.$property[0]->property_fax. ' ';
					$message .= '<strong>Email</strong>: <a href="mailto:'.$property[0]->property_email.'">'.$property[0]->property_email. '</a> ';
					$message .= '</p>';
										
					$this->Sendmail->send($to, $from, $subject, $message);
					$this->Sendmail->send($property[0]->property_email, $from, $subject, $message);
					
				break;
			}
			
			$this->Cart->remove($sess[0]->session_id);
			
			header('location:'.base_url().$sess[0]->lang.'/thankyou?id='.$id);			
			exit;
		}

		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}

		$data['module'] = $this->module;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['category'] = $category;
		$data['shipping'] = $this->Cart->get_shipping_cost($session_id);
		$data['country'] = $this->Country->get();
		$data['payment'] = $payment;
		$data['payment_setting'] = $this->Payment->get_setting_arr();
		$data['cart'] = $cart;
		$data['property'] = $property;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();
		$data['languages'] = $this->Language->get_active();
		$data['seo'] = $this->Seo->get_lang($language[0]->code);
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}

		$this->load->view('website/page.checkout.php', $data);
	
	}
	
	function paypal($lang)
	{
		$id = $this->input->get('id');

		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$paypal = $this->Payment->get_setting_type('PayPal');
		$invoice = $this->Payment->get_id($id);

		$data['paypal'] =$paypal;
		$data['invoice'] = $invoice; 
		$data['sess'] = $sess;
		$data['arr'] = json_decode($paypal[0]->detail,true);
		$data['customer'] = json_decode($invoice[0]->customer, true);
		
		$this->load->view('website/payment.paypal.php', $data);	
	}

	function paypal_subscription($lang)
	{
		$id = $this->input->get('id');

		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$paypal = $this->Payment->get_setting_type('PayPal');
		$subscription = $this->Subscription->get_id($id);

		$plan = $this->Plan->get_billing_plan_by_id($subscription[0]->id_billing_plan);//ID from table cms_billing_plan
		switch ($plan[0]->interval){
			case 'day':{
				$plan[0]->interval = 'D';
			}
				break;
			case 'week':{
				$plan[0]->interval = 'W';
			}
				break;
			case 'month':{
				$plan[0]->interval = 'M';
			}
				break;
			case 'year':{
				$plan[0]->interval = 'Y';
			}
				break;
		}
		$data['plan'] = $plan;

		$data['paypal'] = $paypal;
		$data['subscription'] = $subscription;
		$data['sess'] = $sess;
		$data['arr'] = json_decode($paypal[0]->detail,true);
		$data['customer'] = json_decode($subscription[0]->customer, true);

		$this->load->view('website/payment.paypal.subscription.php', $data);
	}

	function stripe($id, $data, $arr)
	{
		//require APPPATH.'lib/Stripe.php';
		require_once(APPPATH.'lib/vendor/autoload.php');

		\Stripe\Stripe::setApiKey($data['stripe_secret_key']);

		try
		{
			if (empty($_POST['address']) || empty($_POST['city']) || empty($_POST['zipcode']))
			{
				throw new Exception("Fill out all required fields.");
			}
			if (!isset($_POST['stripeToken']))
			{
				throw new Exception("The Stripe Token was not generated correctly");
			}

			$charge = \Stripe\Charge::create(array("amount" => $arr['total']*100,
				"currency" => $arr['currency'],
				"card" => $_POST['stripeToken'],
				"description" => $_POST['email'],
				"metadata" => array('invoice'=>$id)
			));

			if($charge->status == 'succeeded' || $charge->status == 'pending')
			{
				$detail_payment['payment_entered'] = date('Y-m-d H:i:s');
				$detail_payment['payment_status'] = $charge->status == 'succeeded' ? 'Completed' : ucfirst($charge->status);

				$arr_key_details = array(
					'id',
					'object',
					'amount',
					'amount_refunded',
					'application',
					'application_fee',
					'balance_transaction',
					'captured',
					'created',
					'currency',
					'customer',
					'description',
					'destination',
					'dispute',
					'failure_code',
					'failure_message',
					'fraud_details',
					'invoice',
					'livemode',
					'metadata',
					'order',
					'outcome',
					'network_status',
					'reason',
					'risk_level',
					'rule',
					'seller_message',
					'type',
					'paid',
					'receipt_email',
					'receipt_number',
					'refunded',
					'refunds',
					'review',
					'shipping',
					'source',
					'source_transfer',
					'statement_descriptor',
					'status',
					'transfer'
				);
				$payment_arr_details = array();
				foreach ($arr_key_details as $detail){
					if(isset($charge->$detail)){
						$payment_arr_details[$detail] = $charge->$detail;
					}
				}

				if(isset($charge->metadata) && $charge->metadata && isset($charge->metadata->invoice)){
					$payment_arr_details['metadata'] = array('invoice'=>$charge->metadata->invoice);
				}

				$detail_payment['payment_detail'] = json_encode($payment_arr_details);
				$this->Payment->update($id, $detail_payment);

				$response = array(
					'status' => $charge->status,
					'chargeId' => $charge->id,
					'code' => '<strong>Code: </strong>'.$charge->failure_code,
					'msg' => '<strong>Message: </strong>'.$charge->failure_message,
					'url' => base_url().$data['sess'][0]->lang.'/stripe/thankyou',
					'id' => $id
				);
			}
			else
			{
				$response = array(
					'status' => $charge->status,
					'chargeId' => $charge->id,
					'code' => '<strong>Code: </strong>'.$charge->failure_code,
					'msg' => '<strong>Message: </strong>'.$charge->failure_message,
					'url' => '',
					'id' => $id
				);
			}
			echo json_encode($response);
			exit;
		}
		catch (Exception $e)
		{
			$response['error'] = '<div class="alert alert-danger"><strong>Error!</strong> '.$e->getMessage().'</div>';
			echo json_encode($response);
			exit;
		}
	}

	function stripe_subscription($data, $arr)
	{
		require_once(APPPATH.'lib/vendor/autoload.php');

		\Stripe\Stripe::setApiKey($data['stripe_secret_key']);

		try
		{
			if (empty($_POST['address']) || empty($_POST['city']) || empty($_POST['zipcode']) || empty($_POST['billing_plan']))
			{
				throw new Exception("Fill out all required fields.");
			}
			if (!isset($_POST['stripeToken']))
			{
				throw new Exception("The Stripe Token was not generated correctly");
			}

			$billing_plan = $this->Plan->get_billing_plan($_POST['billing_plan'], 'Stripe');
			if (empty($billing_plan))
			{
				throw new Exception("The Stripe billing plan was not exist");
			}

			$token = $_POST['stripeToken'];
			//$email = $_POST['stripeEmail'];

			// Create a Customer:
			$customer = \Stripe\Customer::create(array(
				"email" => $this->input->post('email'),
				"source" => $token,
			));

			$subscription = \Stripe\Subscription::create(array(
				"customer" => $customer->id,
				"plan" => $billing_plan[0]->id_unique
			));

			$arr['entered'] = date('Y-m-d H:i:s');
			$arr['status'] = ucfirst($subscription->status);
			$arr['id_subscription'] = $subscription->id;
			$arr['id_billing_plan'] = $billing_plan[0]->id;//ID from table cms_billing_plan
			$arr['trial_start'] = $subscription->trial_start ? date('Y-m-d H:i:s', $subscription->trial_start) : $subscription->trial_start;
			$arr['trial_end'] = $subscription->trial_end ? date('Y-m-d H:i:s', $subscription->trial_end) : $subscription->trial_end;

			$arr['name'] = $billing_plan[0]->name;
			$arr['billing_plan_name'] = $billing_plan[0]->name;
			$arr['price'] = $billing_plan[0]->price;
			$arr['currency_subscr'] = $billing_plan[0]->currency;
			$arr['interval'] = $billing_plan[0]->interval;
			$arr['interval_count'] = $billing_plan[0]->interval_count;
			$arr['trial_period'] = $billing_plan[0]->trial_period;
			$arr['subscr_detail'] = json_encode($billing_plan[0]);

			$id = $this->Subscription->insert($arr);
			
			if($subscription->status == 'active' || $subscription->status == 'trialing')
			{
				$detail_payment['updated'] = date('Y-m-d H:i:s');

				$arr_key_details = array(
					"id",
					"object",
					"application_fee_percent",
					"cancel_at_period_end",
					"canceled_at",
					"created",
					"current_period_end",
					"current_period_start",
					"customer",
					"discount",
					"ended_at",
					"items",
					"livemode",
					"metadata",
					"plan",
					"quantity",
					"start",
					"status",
					"tax_percent",
					"trial_end",
					"trial_start"
				);

				$payment_arr_details = array();
				foreach ($arr_key_details as $detail){
					if(isset($subscription->$detail)){
						$payment_arr_details[$detail] = $subscription->$detail;
					}
				}
				$detail_payment['signup_detail'] = json_encode($payment_arr_details);
				$this->Subscription->update($id, $detail_payment);

				$response = array(
					'status' => $subscription->status,
					'subscriptionId' => $subscription->id,
					'url' => base_url().$data['sess'][0]->lang.'/stripe/thankyou-subscription',
					'id' => $id
				);
			}
			else
			{
				$response = array(
					'status' => $subscription->status,
					'chargeId' => $subscription->id,
					'url' => '',
					'id' => $id
				);
			}
			echo json_encode($response);
			exit;
		}
		catch (Exception $e)
		{
			$response['error'] = '<div class="alert alert-danger"><strong>Error!</strong> '.$e->getMessage().'</div>';
			echo json_encode($response);
			exit;
		}
	}
	
	function skrill($lang)
	{
		$this->load->view('website/payment.skrill.php');	
	}
}