<?php

class Web_contact extends CI_Controller{

	function index($lang)
	{
		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$error = 0;
		
		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$currency = $this->Currency->get_array();		
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$cart = $this->Cart->get($sess[0]->session_id);

		if($this->input->post('save')){			
			
			if($this->input->post('g-recaptcha-response') == false){
				$error_reason[$error] = 'g-recaptcha-response';
				$error++;
			}
			if($this->input->post('contactname') == false){
				$error_reason[$error] = 'contactname';
				$error++;			
			}
			if($this->input->post('email') == false){
				$error_reason[$error] = 'email';
				$error++;
			}
			if($this->input->post('title') == false){
				$error_reason[$error] = 'title';
				$error++;			
			}
			if($this->input->post('comments') == false){
				$error_reason[$error] = 'comments';
				$error++;			
			}
		
			if($error == false){
				
				$contactname = $this->input->post('contactname');
				$email = $this->input->post('email');
				$title = $this->input->post('title');
				$comments = $this->input->post('comments');
				$subject = $property[0]->property_name.' - Contact';
				
				$message = "Contact name: ".$contactname . "\n";
				$message .= "Email: ".$email . "\n";
				$message .= "Title: ".$title . "\n";
				$message .= "Comments: ".$comments . "\n";
				$message = nl2br($message);
				
				$this->Sendmail->send($property[0]->property_email, $email, $subject, $message);
				
				$arr['contactname'] = $this->input->post('contactname');
				$arr['email'] = $this->input->post('email');
				$arr['title'] = $this->input->post('title');
				$arr['comments'] = $this->input->post('comments');				
				
				$this->Contact->insert($arr);
				
				header('location:'.base_url().$sess[0]->lang.'/contact-us?save=1');
				exit;
			}
		}
		
		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		$data['recaptcha'] = $this->Api->get_api('reCAPTCHA');
		$data['googlemap'] = $this->Api->get_api('googlemap');
		$data['content'] = $this->Page->get_slug($language[0]->code, $property, 'contact-us');
		$data['save'] = $this->input->get('save');
		$data['category'] = $category;
		$data['currency'] = $currency;
		$data['sumcart'] = $sumcart;
		$data['cart'] = $cart;
		$data['languages'] = $this->Language->get_active();
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);		
		$data['shipping_available'] = $this->Shipping->get_available_country();
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}

		if(isset($error_reason)){
			$data['error_reason'] = $error_reason;
		}
		$data['error'] = $error;
					
		$this->load->view('website/page.contact.php', $data);
	
	}

}