<?php

class Web_download extends CI_Controller{

	function index($lang, $download_id)
	{
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);

		
		//check to see if the person is logged into the system.  If not, redirect them to the login page with a redirect back to this page.
		if($sess[0]->login == false){
			$this->_redirect_to_login_page($sess);
			exit;
		}
		
		$member_id = $sess[0]->member_id;
		$privilege = false;
		
		
		//look up the slug and get the INFO
		$download = $this->db->get_where('cms_product_download', array('id'=> $download_id))->row_array();
		
		if($download) {
		
			//check that the person who is viewing this page has purchased the product 

			$product_id = $download['access_id'];
			//echo $product_id;
			
			//look through purchases
			$purchases = $this->db->get_where('cms_payment', array('member_id'=> $member_id))->result_array();
			foreach($purchases as $purchase) {
			
				$item = json_decode($purchase['item'], true);
				
				if($item) {
					if($item['id'] == $product_id) {
						//echo 'found in purchases';
						$privilege = true;
					}
				}
			}
					
			//look through subscriptions
			$subscriptions = $this->db->get_where('cms_subscription', array('member_id'=> $member_id))->result_array();
			foreach($subscriptions as $subscription) {
			
				$item = json_decode($subscription['item'], true);
				
				if($item) {
					if($item['id'] == $product_id) {
						//echo 'found in subscriptions';
						$privilege = true;
					}
				}
			}
				
				
		} else {
		
			$this->load->view('website/page.membership.notfound.php' , $data);
			
		}

		
		
		$data[] = "";
		
		if($privilege) {

			
			$file = dirname( FCPATH ) . '/' . $download['filepath'];

			  if (file_exists($file)) {
			  
				header('Content-Description: File Transfer');
				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename='.$download['filename']);
				header('Content-Transfer-Encoding: binary');
				header('Expires: 0');
				header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				header('Pragma: public');
				header('Content-Length: ' . filesize($file));

				ob_clean();
				flush();
				readfile($file);
				exit;

			} 
			
		} else {
		
			//page was found, but the viewer does not have access to it.  Show them the link to the page where they can get more info.
			$data['link_url'] = "en/products/" . $product_id;
			
			$this->load->view('website/page.membership.noaccess.php' , $data);
		}
		
		
	}
	
	
	private function _redirect_to_login_page($sess)
	{
		// Determine the login redirect
		$redirect = $this->input->get('redirect')
			? urlencode( $this->input->get('redirect') ) 
			: urlencode( $this->uri->uri_string() );

		// Set the redirect protocol
		//$redirect_protocol = USE_SSL ? 'https' : NULL;

		// Load URL helper for the site_url function
		$this->load->helper('url');



		// Redirect to the login form
		header(
			'Location: ' . site_url( $sess[0]->lang . '/login?redirect=' . $redirect, $redirect_protocol ),
			TRUE,
			302
		);
	}
	

}