<?php

class Web_forgot extends CI_Controller{
	
	function __construct(){
            parent::__construct();
            $this->load->library('form_validation');    
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        }    
	
	function index($lang)
	{
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$country = $this->input->get('country');		
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);

		$this->lang->load('var_lang.php', $lang);
	
		if($this->input->post('save')){
			
			$email = $this->input->post('email');
			$rs = $this->Member->check_email($email);
			
			if(isset($rs[0]->member_id)){
				
				$to = $rs[0]->email;
				$from = $property[0]->property_email;
				
				
				$token = $this->Member->insertToken($rs[0]->member_id);                    
                $qstring = $this->base64url_encode($token);                      
                $url = site_url() . 'en/reset/' . $qstring;
                $link = '<a href="' . $url . '">' . $url . '</a>'; 
                
                $subject = 'Reset your {company} Password';
                
				$message = '<div style="text-align:center;padding-top:30px; padding-bottom:50px">';
				$message .= '<h3>Reset your password</h3>';
				$message .= '<p>Forgot your password? No problem!</p>';
				$message .= '<p>Reset your password by clicking the link below or copying and pasting it into your browser.</p>';
				$message .= '<p>'.$link.'</p>';
				$message .= '<p>This link expires in 24 hours. If the link has expired, you can request a new one from the site.</p>';
				$message .= '</div>';
				
				$this->Email->send_branded_email($to, $subject, $message);
				
				echo 'save';
				
			}
			
			exit;
		}
		
		$data['sess'] = $sess;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['category'] = $category;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['complete'] = $this->input->get('complete');
		$data['error'] = $this->input->get('error');
		
		//$this->load->view('website/page.forgot.php', $data);
	}
	
	public function reset_password($lang, $token)
        {
            $token = $this->base64url_decode($token);                  
            $cleanToken = $this->security->xss_clean($token);
            
            $Member = $this->Member->isTokenValid($cleanToken); //either false or array();               
            
            
            if(!$Member){
            	
                $this->session->set_flashdata('flash_message', 'Token is invalid or expired');
                $data['error_token'] = 'true';
                $this->load->view('website/page.login.reset.php', $data);
				return;
				
            }    
            
			$data['firstName'] = $Member[0]->firstname;
			$data['email'] = $Member[0]->email;
			$data['token'] = $this->base64url_encode($token);

            $this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');
            $this->form_validation->set_rules('passconf', 'Password Confirmation', 'required|matches[password]');              
            
            if ($this->form_validation->run() == FALSE) {   
                $this->load->view('website/page.login.reset.php', $data);
            }else{

                                            
                $post = $this->input->post(NULL, TRUE);                
                $cleanPost = $this->security->xss_clean($post);         
                $hashed =  password_hash( $cleanPost['password'], PASSWORD_DEFAULT);                     
                $cleanPost['password'] = $hashed;
                $cleanPost['user_id'] = $Member[0]->member_id;
                unset($cleanPost['passconf']);         
                

                if(!$this->Member->updatePassword($cleanPost)){
                
                	$this->load->view('website/page.login.reset.php', $data);
                    $this->session->set_flashdata('flash_message', 'There was a problem updating your password');
                    return;
                    
                }else{
                	redirect(site_url().'en/login?reset=success'); 
                }
                               
            }
        }

	public function base64url_encode($data) { 
      return rtrim(strtr(base64_encode($data), '+/', '-_'), '='); 
    } 
    public function base64url_decode($data) { 
      return base64_decode(str_pad(strtr($data, '-_', '+/'), strlen($data) % 4, '=', STR_PAD_RIGHT)); 
    } 
    
}