<?php

class Web_membership extends CI_Controller{

	function index($lang, $page_slug)
	{
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);

		
		//check to see if the person is logged into the system.  If not, redirect them to the login page with a redirect back to this page.
		if($sess[0]->login == false){
			$this->_redirect_to_login_page($sess);
			exit;
		}
		
		$member_id = $sess[0]->member_id;
		$privilege = false;
		
		
		//look up the slug and get the INFO
		$page = $this->db->get_where('cms_membership_pages', array('page_slug'=> $page_slug))->row_array();
		
		if($page) {
		
			//check that the person who is viewing this page is in the access list
			
			$access_list = $this->db->get_where('cms_membership_access', array('file_id' => $page['file_id']))->result_array();

			foreach($access_list as $access) {
			
				if($access['access_type'] == 'product') {
					
					//user can gain access to page by purchasing a product, look through the products and see if the user purchased
					$product_id = $access['access_id'];
					//echo $product_id;
					
					//look through purchases
					$purchases = $this->db->get_where('cms_payment', array('member_id'=> $member_id))->result_array();
					foreach($purchases as $purchase) {
					
						$item = json_decode($purchase['item'], true);
						
						if(!array_key_exists("id", $item)) {
							$item = $item[0];
						}
			
						
						if($item) {
							if($item['id'] == $product_id) {
								//echo 'found in purchases';
								$privilege = true;
							}
						}
					}
					
					//look through subscriptions
					$subscriptions = $this->db->get_where('cms_subscription', array('member_id'=> $member_id))->result_array();
					foreach($subscriptions as $subscription) {
					
						$item = json_decode($subscription['item'], true);
						
						if(!array_key_exists("id", $item)) {
							$item = $item[0];
						}
						
						if($item) {
							if($item['id'] == $product_id) {
								//echo 'found in subscriptions';
								$privilege = true;
							}
						}
					}
				
				} else if($access['access_type'] == 'member') {
				
					//echo 'access type is member- allowing';
					$privilege = true;
				
				}
				
			}
		} else {
		
			$this->load->view('website/page.membership.notfound.php' , $data);
			
		}

		
		
		$data[] = "";
		
		if($privilege) {
			
			$this->load->view('membership/'.$page['file_id'] , $data);
			
		} else {
		
			//page was found, but the viewer does not have access to it.  Show them the link to the page where they can get more info.
			$data['link_url'] = "";
			
			$settings = (isset($page['file_settings']))?$page['file_settings']:'{}';
			
			if (is_string($settings)){
				$settings = json_decode($settings,true);
				
				if($settings['link_url']){
					$data['link_url'] = $settings['link_url'];
				}
			}
			
			
			$this->load->view('website/page.membership.noaccess.php' , $data);
		}
		
		
	}
	
	
	private function _redirect_to_login_page($sess)
	{
		// Determine the login redirect
		$redirect = $this->input->get('redirect')
			? urlencode( $this->input->get('redirect') ) 
			: urlencode( $this->uri->uri_string() );

		// Set the redirect protocol
		//$redirect_protocol = USE_SSL ? 'https' : NULL;

		// Load URL helper for the site_url function
		$this->load->helper('url');



		// Redirect to the login form
		header(
			'Location: ' . site_url( $sess[0]->lang . '/login?redirect=' . $redirect, $redirect_protocol ),
			TRUE,
			302
		);
	}
	

}