<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Web_paypal extends CI_Controller
{
	function ipn($lang)
	{
//		$json = '{"amount3":"1.00","address_status":"confirmed","subscr_date":"12:17:02 Feb 27, 2017 PST","payer_id":"FWURVZPTAK3QJ","address_street":"1 Main St","mc_amount3":"1.00","charset":"windows-1252","address_zip":"95131","first_name":"test","reattempt":"1","address_country_code":"US","address_name":"test buyer","notify_version":"3.8","subscr_id":"I-BRBY2DHVMWWX","custom":"{\"id_subscription\":\"6\",\"tmp_id_subscr\":\"tmp_6_1488224989\"}","payer_status":"verified","business":"panchenkoprog-facilitator@gmail.com","address_country":"United States","address_city":"San Jose","verify_sign":"AiPC9BjkCyDFQXbSkoZcgqH3hpacA5kxUsCp7cxWTnpR1lf-KkmW7zfP","payer_email":"panchenkoprog-buyer@gmail.com","last_name":"buyer","address_state":"CA","receiver_email":"panchenkoprog-facilitator@gmail.com","recurring":"1","txn_type":"subscr_cancel","item_name":"Test billing plan 3","mc_currency":"USD","item_number":"Subscription number: 6","residence_country":"US","test_ipn":"1","period3":"1 D","ipn_track_id":"deddcb1e5403a"}';
//		$_POST = json_decode($json, true);
//		$this->update_subscription_status();
//		exit;
		
		//load the lang so we know what to say in the emails
		$this->lang->load('var_lang.php', $lang);
		
		if(empty($_POST))
		{
			$raw_post_data = file_get_contents('php://input');
			$raw_post_array = explode('&', $raw_post_data);
			$myPost = array();
			foreach ($raw_post_array as $keyval) {
				$keyval = explode ('=', $keyval);
				if (count($keyval) == 2)
					$myPost[$keyval[0]] = urldecode($keyval[1]);
			}
			$_POST = $myPost;
		}
		
		//debug
		//$this->debug($_POST, date("Y-m-d H:i:s", time()), 'debug-paypal-ipn.txt');

		//choose paypal URL
		$paypal_url = ($_POST['test_ipn'] == 1) ? PAYPAL_URL_SANDBOX_WEBSCR : PAYPAL_URL_WEBSCR;

		$post_string = "cmd=_notify-validate"; // append ipn command

		foreach ($_POST as $field => $value) {
			$post_string .= '&' . $field . '=' . urlencode(stripslashes($value));
		}

		$ch = curl_init($paypal_url);
		curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_string);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 25);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
		curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close'));

		// In wamp like environments that do not come bundled with root authority certificates,
		// please download 'cacert.pem' from "http://curl.haxx.se/docs/caextract.html" and set the directory path
		// of the certificate as shown below.
		// curl_setopt($ch, CURLOPT_CAINFO, dirname(__FILE__) . '/cacert.pem');
		if( !($res = curl_exec($ch)) )
		{
			// error_log("Got " . curl_error($ch) . " when processing IPN data");
			curl_close($ch);
			//exit;
		}
		curl_close($ch);

		if (strcmp ($res, "VERIFIED") == 0)
		{
			//$this->debug(json_encode($_POST), 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()), 'debug-paypal-ipn.txt');
			if($this->input->post('txn_type')=='web_accept' && $this->input->post('invoice'))
			{
				$this->update_status();
			}
			elseif ($this->input->post('custom'))
			{
				$this->update_subscription_status();
			}
		}
		else if (strcmp ($res, "INVALID") == 0)
		{
			//$this->debug(json_encode($_POST), 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()), 'debug-paypal-ipn.txt');
		}
	}
	
	function update_status()
	{
		//debug
		//$this->debug($_POST, date("Y-m-d H:i:s", time()), 'debug-paypal-web-accept.txt');

		$invoice = $this->input->post('invoice');
		//$property = $this->Property_Model->info();
		$payment_status = $this->input->post('payment_status');
		$property = $this->Property->get();
		

		$arr['payment_detail'] = json_encode($_POST);
		$arr['payment_status'] = $payment_status;
		$arr['payment_updated'] = date("Y-m-d H:i:s", time());
		
		//get current payment status and see if we should send out an email
		$sendmail = false;
		
		$payment = $this->Payment->get_id($invoice);
		if($payment) {
			if($payment[0]->payment_status == 'Pending' && $payment_status == 'Completed') {
				//this is the initial payment status, send out the email
				$sendmail = true;
				//it used to send out tons of emails when it was sending more than one update
			}
		}

		$this->Payment->update($invoice, $arr);

		//email notification
		if($sendmail ) {
			//get latest record
			$payment = $this->Payment->get_id($invoice);
			$this->Email->send_template_email('Order Confirmation', $payment  );
			
			//add to the mailer
			$this->Mailer->add_user_for_purchase($invoice);
		}

	}

	function update_subscription_status()
	{
		//debug
		//$this->debug(json_encode($_POST), 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()), 'debug-paypal-subscription.txt');
		//$this->debug($_POST, date("Y-m-d H:i:s", time()), 'debug-paypal-subscription.txt');

		if(!$this->input->post('custom')){
			return;
		}

		$paypal = $this->Payment->get_setting_type('PayPal');
		$paypal = json_decode($paypal[0]->detail,true);
		$paypal_username = isset($paypal['username']) ? $paypal['username'] : '';
		if(!$paypal_username || $paypal_username != $this->input->post('receiver_email')){
			return;
		}

		$custom = json_decode($this->input->post('custom'));
		$id = $custom->id_subscription;
		$tmp_id_subscr = $custom->tmp_id_subscr;
		$id_subscription = $this->input->post('subscr_id');

		if($this->input->post('txn_type') == 'subscr_signup')
		{
			$subscription = $this->Subscription->get_id($id);
			if($subscription && $subscription[0]->type == PAYMENT_TYPE_PAYPAL && $subscription[0]->id_subscription == $tmp_id_subscr)
			{
				if( $subscription[0]->status != STATUS_CANCELLED
					&& $subscription[0]->status != STATUS_ACTIVE )
				{
					if($this->input->post('period1')){
						$arr['status'] = STATUS_TRIALING;
						$trial_period = intval($this->input->post('period1'));
						$trial_start = date("Y-m-d H:i:s");
						$trial_end = $trial_start + (60*60*24*$trial_period);
						$arr['trial_start'] = $trial_start;
						$arr['trial_end'] = $trial_end;
					}else{
						$arr['status'] = STATUS_ACTIVE;
					}
				}
				$arr['id_subscription'] = $id_subscription;
				$arr['signup_detail'] = json_encode($_POST);
				$arr['updated'] = date('Y-m-d H:i:s');
				$this->Subscription->update($id, $arr);
				
				
				$this->Email->send_template_email('Subscription Created', $this->Subscription->get_id($id) );
				
			}
		}
		elseif($this->input->post('txn_type') == 'subscr_payment')
		{
			$subscription = $this->Subscription->get_id($id);
			$txn_id = $this->input->post('txn_id');
			if( $subscription && $subscription[0]->type == PAYMENT_TYPE_PAYPAL
				&& ($subscription[0]->id_subscription == $this->input->post('subscr_id') || $subscription[0]->id_subscription == $tmp_id_subscr))
			{
				$transaction_detail = json_encode($_POST);
				$transaction = $this->Recurring_payment->get_transaction($txn_id);
				if(empty($transaction))
				{
					if( ($subscription[0]->price == $this->input->post('mc_gross'))
						&& ($subscription[0]->currency_subscr == $this->input->post('mc_currency')))
					{
						if( $subscription[0]->status != STATUS_CANCELLED
							&& $subscription[0]->status != STATUS_ACTIVE )
						{
							$arr1['status'] = STATUS_ACTIVE;
							$arr1['updated'] = date('Y-m-d H:i:s');
							$this->Subscription->update($subscription[0]->id, $arr1);
						}

						$arr['id_transaction'] = $txn_id;
						$arr['id_subscription'] = $id;
						$arr['transaction_detail'] = $transaction_detail;
						$payment_status = $this->input->post('payment_status');

						if($payment_status == 'Completed')
						{
							$arr['payment_status'] = $this->input->post('payment_status');
							$arr['payment_updated'] = date('Y-m-d H:i:s');
							$insert_id = $this->Recurring_payment->insert($arr);

							$property = $this->Property->get();
							$customer = json_decode($subscription[0]->customer, true);
							

							
							$transaction = $this->Recurring_payment->get_transaction_with_subscr_info_by_member($subscription[0]->customer_email, $insert_id);
							
							//log_message('debug',print_r('PAYPAL sub payment 1',TRUE));
							//log_message('debug',print_r($customer,TRUE));
							//log_message('debug',print_r($insert_id,TRUE));
							//log_message('debug',print_r($transaction,TRUE));
							
							$this->Email->send_template_email('Subscription Payment', $transaction);
// 
// 							$subject = $property[0]->property_name.' - Subscription payment '.$arr['payment_status'];
// 							$from = 'administrator';
// 							$to = $subscription[0]->customer_email;
// 
// 							$message = '';
// 
// 							$this->Sendmail->send($to, $from, $subject, $message);
// 							$this->Sendmail->send($property[0]->property_email, $from, $subject, $message);
						}
						else
						{
							$arr['payment_status'] = $payment_status;
							$arr['payment_updated'] = date('Y-m-d H:i:s');
							$this->Recurring_payment->insert($arr);
						}
					}
				}
				elseif(!empty($transaction) && $transaction[0]->payment_status != 'Completed')
				{
					if( ($subscription[0]->price == $this->input->post('mc_gross'))
						&& ($subscription[0]->currency_subscr == $this->input->post('mc_currency')))
					{
						$arr['transaction_detail'] = $transaction_detail;
						$payment_status = $this->input->post('payment_status');

						if($payment_status == 'Completed')
						{
							$arr['payment_status'] = $this->input->post('payment_status');
							$arr['payment_updated'] = date('Y-m-d H:i:s');
							$this->Recurring_payment->update($transaction[0]->id, $arr);

							$property = $this->Property->get();
							$customer = json_decode($subscription[0]->customer, true);
							
							$transaction = $this->Recurring_payment->get_transaction_with_subscr_info_by_member($subscription[0]->customer_email, $transaction[0]->id );
							
							//log_message('debug',print_r('PAYPAL sub payment 2',TRUE));
							//log_message('debug',print_r($transaction[0]->id,TRUE));
							//log_message('debug',print_r($transaction,TRUE));
							
							$this->Email->send_template_email('Subscription Payment', $transaction);
							
// 							$subject = $property[0]->property_name.' - Subscription payment '.$arr['payment_status'];
// 							$from = 'administrator';
// 							$to = $subscription[0]->customer_email;
// 
// 							$message = '';
// 
// 							$this->Sendmail->send($to, $from, $subject, $message);
// 							$this->Sendmail->send($property[0]->property_email, $from, $subject, $message);
						}
						else
						{
							$arr['payment_status'] = $payment_status;
							$arr['payment_updated'] = date('Y-m-d H:i:s');
							$this->Recurring_payment->update($transaction[0]->id, $arr);
						}
					}
				}
				else
				{
					$t=0;//
				}
			}
		}
		elseif($this->input->post('txn_type') == 'subscr_modify')
		{
			$subscription = $this->Subscription->get_by_id_and_id_subscr($id, $id_subscription);
			if($subscription)
			{
				$arr['status'] = 'modified';
				$arr['updated'] = date('Y-m-d H:i:s');
				$this->Subscription->update($id, $arr);
			}
		}
		elseif($this->input->post('txn_type') == 'subscr_cancel')
		{
			$subscription = $this->Subscription->get_by_id_and_id_subscr($id, $id_subscription);
			if($subscription)
			{
				$arr['status'] = STATUS_CANCELLED;
				$arr['cancel_detail'] = json_encode($_POST);
				$arr['updated'] = date('Y-m-d H:i:s');
				$arr['canceled'] = date('Y-m-d H:i:s');
				$this->Subscription->update($id, $arr);

				$property = $this->Property->get();
				$customer = json_decode($subscription[0]->customer, true);
				
					
				//log_message('debug',print_r('PAYPAL SUB Cancelled',TRUE));
				//log_message('debug',print_r($subscription,TRUE));
					
				$this->Email->send_template_email('Subscription Cancelled', $this->Subscription->get_id($id));

// 				$subject = $property[0]->property_name.' - Subscription '.$arr['status'];
// 				$from = 'administrator';
// 				$to = $subscription[0]->customer_email;
// 
// 				$message = '';
// 
// 				$this->Sendmail->send($to, $from, $subject, $message);
// 				$this->Sendmail->send($property[0]->property_email, $from, $subject, $message);
			}
		}
		elseif($this->input->post('txn_type') == 'subscr_eot')
		{
			//
		}
	}

	function cancel($lang)
	{
		//debug
		//$this->debug(json_encode($_REQUEST), 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()), 'debug-paypal-cancel.txt');
		//$this->debug($_REQUEST, '', 'debug-paypal-cancel.txt');

		$this->lang->load('var_lang.php', $lang);

		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);

		//$id = $this->input->post('invoice');

		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$cart = $this->Cart->get($sess[0]->session_id);

		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['category'] = $category;
		//$data['invoice'] = $this->Payment->get_id($id);
		$data['cart'] = $cart;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['languages'] = $this->Language->get_active();
		$data['shipping_available'] = $this->Shipping->get_available_country();
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}

		$this->load->view('website/page.paypal.cancel.php', $data);
	}

	//debug($str, 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()));
	function debug( $msg, $line='', $file='' )
	{
		if(is_array($msg))
		{
			ob_start();
			print_r($msg);
			$msg = ob_get_clean();
		}

		if(!$file){
			$file = 'debug.txt';
		}

		$line = $line ? "\r\n--$line--\r\n" : "\r\n---\r\n";
		//log_message('debug', $line . $msg );
	}
}