<?php

class Web_product extends CI_Controller{

	function index($lang, $product_id)
	{
		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		
		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$product = $this->Product->get_id($product_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$cart = $this->Cart->get($sess[0]->session_id);
		
		if(isset($product[0]->category_id)){
			$current_category = $this->Category->get_category_lang($language[0]->code, $property, $product[0]->category_id);
			$data['current_category'] = $current_category;
		}
		if(isset($product[0]->category_id)){
			$related = $this->Product->get_related($product_id, $product[0]->category_id);
			$data['related'] = $related;
		}
		
		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		$data['product'] = $product;
		$data['cart'] = $cart;
		$data['currency'] = $this->Currency->get_array();
		$data['gallery'] = $this->Product->gallery_get($product_id);
		$data['document'] = $this->Document->get($product_id);
		$data['download'] = $this->Download->get($product_id);
		$data['language'] = $language;
		$data['category'] = $category;
		$data['sumcart'] = $sumcart;
		//$data['services'] = $this->Widget->get_lang('services', $language[0]->code, $property);
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['shipping_available'] = $this->Shipping->get_available_country();
		$data['languages'] = $this->Language->get_active();
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}
		
		if($language[0]->code != $property[0]->lang){
			$data['translate'] = $this->Product->get_lang($language[0]->code, $product[0]->product_id);
		}
		
		//$data['googletranslate'] = $this->Api->get_api('Google Translate');

		$this->load->view('website/product.detail.php',$data);
		
	}
	
}