<?php

class Web_register extends CI_Controller{
	
	function index($lang)
	{
	
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$country = $this->input->get('country');		
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$property = $this->Property->get();

		$this->lang->load('var_lang.php', $lang);

		if($sess[0]->member_id != 0 && $this->input->post('save')){
			echo 'logged_in';
			exit;
		}
		elseif($this->input->post('save')){
			
			$email = $this->input->post('email');
			$password = $this->input->post('password');
			$phone = $this->input->post('phone');
			$firstname = $this->input->post('firstname');
			$lastname = $this->input->post('lastname');
			
			if(trim($email) == '' || is_null($email) || is_null($password) || trim($password) == '') {
				
				$data['headline_text'] = 'Sorry, required data is missing.';
				$data['subheadline_text'] = "Please go back and try again.";
				
				$this->load->view('website/page.login_register_from_form.php', $data);
						
				return;
			}
			
			$result = $this->Member->check_member($email);
			if($result == true){

				$arr['email'] = $email;
				$arr['firstname'] = (string) $firstname;
				$arr['lastname'] = (string) $lastname;
				$arr['phone'] = (string) $phone;
				$arr['password'] = $password;
				$arr['member_entered'] = date('Y-m-d H:i:s');
				
				$member_id = $this->Member->insert($arr);
				
				$member = $this->Member->get_id($member_id);
				$this->Email->send_template_email('New Member', $member);
				
				$this->Mailer->add_user_to_list($firstname . ' ' . $lastname , $email, $property[0]->property_form_id);
				
				
				//is this from a built form?
				if($this->input->post('f')=='1'){
				
					if( trim($this->input->post('redirect')) ) {
						
						redirect( trim($this->input->post('redirect')) , 'refresh'); 
						
					} else {
						$data['redirect'] = '/';
						$data['headline_text'] = 'Thank you for registering.';
						$data['subheadline_text'] = '';
						
						$this->load->view('website/page.login_register_from_form.php', $data);
						
					}
				
				} else {
			
					echo 'save';
					exit;
				}
				
				
				
				
			}elseif($this->input->post('checkout') && !$result){

				exit;
				
			}elseif($this->input->post('f') && !$result){
						
				$data['redirect'] = '/';
				$data['headline_text'] = 'Sorry, an error occurred registering that email address.';
				$data['subheadline_text'] = "The email address may already be in the system";
				
				$this->load->view('website/page.login_register_from_form.php', $data);
						
			}
		}
	
	}
	
	function complete($lang)
	{

		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$property = $this->Property->get();
		$language = $this->Language->get_2code($lang);
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);

		$this->lang->load('var_lang.php', $lang);

		$data['sess']		 = $sess;
		$data['property'] = $property;
		$data['language'] = $language;
		$data['category'] = $category;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;	
	
	}
	
}