<?php

class Web_stripe extends CI_Controller{

	function index()
	{
		try
		{
			$stripe = $this->Payment->get_setting_type('Stripe');
			$stripe = json_decode($stripe[0]->detail,true);
			$stripe_secret_key = isset($stripe['stripe_sandbox']) && $stripe['stripe_sandbox'] !="" ? $stripe['stripe_test_secret_key'] : $stripe['stripe_live_secret_key'];

			// Set your secret key: remember to change this to your live secret key in production
			// See your keys here: https://dashboard.stripe.com/account/apikeys
			require_once(APPPATH.'lib/vendor/autoload.php');
			\Stripe\Stripe::setApiKey($stripe_secret_key);

			// Retrieve the request's body and parse it as JSON
			$input = @file_get_contents("php://input");
			$event_json = json_decode($input);

			// Verify the event by fetching it from Stripe
			$event = \Stripe\Event::retrieve($event_json->id);

			//------------------------------------
			
            if ($event->type == 'customer.subscription.created')
            {
                $server_subscription = $this->Subscription->get_by_id_subscr($event->data->object->id);
                if($server_subscription && ucfirst($server_subscription[0]->status) != STATUS_ACTIVE){
                    $arr['signup_detail'] = $input;
                    $arr['status'] = ucfirst($event->data->object->status);
                    $arr['updated'] = date('Y-m-d H:i:s');
                    $this->Subscription->update($server_subscription[0]->id, $arr);
            
                    $property = $this->Property->get();
                    $customer = json_decode($server_subscription[0]->customer, true);
            
            		//log_message('debug',print_r('STRIPE SUB',TRUE));
					//log_message('debug',print_r($server_subscription,TRUE));
					//log_message('debug',print_r($customer,TRUE));
		
            		$this->Email->send_template_email('Subscription Created', $server_subscription);
                    // $subject = $property[0]->property_name.' - Subscription '.$arr['status'];
//                     $from = 'administrator';
//                     $to = $server_subscription[0]->customer_email;
//             
//                     $message = '';
//             
//                     $this->Sendmail->send($to, $from, $subject, $message);
//                     $this->Sendmail->send($property[0]->property_email, $from, $subject, $message);
                }
            }
			elseif ($event->type == 'invoice.payment_succeeded')
			{
				$customer_id = $event->data->object->customer;
				$customer = \Stripe\Customer::retrieve($customer_id);
				$invoice = \Stripe\Invoice::retrieve($event->data->object->id);
				$total = $invoice->total / 100.0;
				$currency = $event->data->object->currency;

				$server_subscription = $this->Subscription->get_by_id_subscr($event->data->object->subscription);

				if($server_subscription && $customer->email == $server_subscription[0]->customer_email)
				{
					$transaction = $this->Recurring_payment->get_transaction($event->id);
					if(empty($transaction))
					{
						if( (floatval($server_subscription[0]->price) == $total)
							&& ($server_subscription[0]->currency_subscr == strtoupper($currency)))
						{
							if( $server_subscription[0]->status != STATUS_CANCELLED 
								&& $server_subscription[0]->status != STATUS_ACTIVE )
							{
								$arr['status'] = STATUS_ACTIVE;
								$arr['updated'] = date('Y-m-d H:i:s');
								$this->Subscription->update($server_subscription[0]->id, $arr);
							}
							
							$arr['id_transaction'] = $event->id;
							$arr['id_subscription'] = $server_subscription[0]->id;
							$arr['transaction_detail'] = $input;
							$arr['payment_status'] = 'Completed';
							$arr['payment_updated'] = date('Y-m-d H:i:s');
							$this->Recurring_payment->insert($arr);

							$property = $this->Property->get();
							$customer = json_decode($server_subscription[0]->customer, true);

							$subject = $property[0]->property_name.' - Subscription payment '.$arr['payment_status'];
							$from = 'administrator';
							$to = $server_subscription[0]->customer_email;

							$message = '';

							$this->Sendmail->send($to, $from, $subject, $message);
							$this->Sendmail->send($property[0]->property_email, $from, $subject, $message);
						}
					}
				}
			}
			elseif ($event->type == 'customer.subscription.deleted')
			{
				$server_subscription = $this->Subscription->get_by_id_subscr($event->data->object->id);
				if($server_subscription && $server_subscription[0]->status != STATUS_CANCELLED){
					$arr['cancel_detail'] = $input;
					$arr['status'] = STATUS_CANCELLED;
					$arr['updated'] = date('Y-m-d H:i:s');
					$arr['canceled'] = date('Y-m-d H:i:s');
					$this->Subscription->update($server_subscription[0]->id, $arr);

					$property = $this->Property->get();
					$customer = json_decode($server_subscription[0]->customer, true);

					$subject = $property[0]->property_name.' - Subscription '.$arr['status'];
					$from = 'administrator';
					$to = $server_subscription[0]->customer_email;

					$message = '';

					$this->Sendmail->send($to, $from, $subject, $message);
					$this->Sendmail->send($property[0]->property_email, $from, $subject, $message);
				}
			}

			//------------------------------------

			http_response_code(200); // PHP 5.4 or greater

			//debug
			//$this->debug($input, 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()), 'debug-stripe-subscription.txt');
			//$this->debug($event, '', 'debug-stripe-subscription.txt');
			exit;
		}
		catch (Exception $e)
		{
			//$this->debug(json_encode($e), 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()), 'debug-stripe-subscription.txt');
			exit;
		}
	}

	//debug($str, 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()));
	function debug( $msg, $line='', $file='' )
	{
		if(is_array($msg))
		{
			ob_start();
			print_r($msg);
			$msg = ob_get_clean();
		}

		if(!$file){
			$file = 'debug.txt';
		}

		$line = $line ? "\r\n--$line--\r\n" : "\r\n---\r\n";
		file_put_contents($file, $line . $msg, FILE_APPEND);
	}
}