<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Web_thankyou extends CI_Controller{
	
	function paypal($lang, $id)
	{
		//debug
		$this->debug(json_encode($_REQUEST), 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()), 'debug-thankyou-paypal.txt');
		$this->debug($_REQUEST, '', 'debug-thankyou-paypal.txt');
		
		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);

		//$id = $this->input->post('invoice');
		
		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$cart = $this->Cart->get($sess[0]->session_id);
		
		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['category'] = $category;
		$data['invoice'] = $this->Payment->get_id($id);
		$data['cart'] = $cart;
		$data['property'] = $property;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);	
		$data['languages'] = $this->Language->get_active();
		$data['shipping_available'] = $this->Shipping->get_available_country();
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}
		
		//clear out the cart
		$this->Cart->remove($session_id);
		
		//email notification - this happens in the paypal api page
		
		$this->load->view('website/page.thankyou.php', $data);
	}

	function stripe($lang)
	{
		//debug
		//$this->debug(json_encode($_REQUEST), 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()), 'debug-thankyou-stripe.txt');
		//$this->debug($_REQUEST, '', 'debug-thankyou-stripe.txt');

		$this->lang->load('var_lang.php', $lang);

		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);

		$id = $this->input->post('invoice_id');

		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$cart = $this->Cart->get($sess[0]->session_id);

		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['category'] = $category;
		$data['invoice'] = $this->Payment->get_id($id);
		$data['cart'] = $cart;
		$data['property'] = $property;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['languages'] = $this->Language->get_active();
		$data['shipping_available'] = $this->Shipping->get_available_country();
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}

		//clear out the cart
		$this->Cart->remove($session_id);
		
		//add to the mailer
		$this->Mailer->add_user_for_purchase($id);
		
		//send order email
		$this->Email->send_template_email('Order Confirmation', $this->Payment->get_id($id) );
		//$this->Email->send_order_confirmation( $this->Payment->get_id($id) );
		
		$this->load->view('website/page.thankyou.php', $data);

		/*
		if ($_SERVER['REQUEST_METHOD'] == 'POST') {

			require_once(APPPATH.'lib/vendor/autoload.php');
			
			$postdata = @file_get_contents("php://input");
			$event = json_decode($postdata);
			if ($event->type == 'invoice.payment_succeeded') {
				$customer_id = $event->data->object->customer;
				$customer = \Stripe\Customer::retrieve($customer_id);
				$invoice = \Stripe\Invoice::retrieve($event->data->object->id);

				// This is where we'd normally e-mail the invoice, but we'll just write out the invoice to a file instead.
				$from = "From: Oscar Wilde";
				$to = "To: ".$customer->email;
				$subject = "Subject: You have made a payment for another month of Wilde quotes";
				$body = "You have made a new payment for $".($invoice->total / 100.0).":\n\n";

				foreach($invoice->lines->data as &$line) {
					if ($line->type == 'subscription') {
						$body .= "Subscription - ".$line->plan->name.": ".$line->amount."\n";
					}
					else if ($line->type == 'invoiceitem') {
						$body .= "Additional -".$line->description.": ".$line->amount;
					}
				}

				$email_file = fopen($customer->id."-".$invoice->date, 'a');
				$email = $from."\n".$to."\n".$subject."\n".$body;
				fwrite($email_file, $email);
			}
		}
		*/
	}

	function stripe_subscription($lang)
	{
		//debug
		//$this->debug(json_encode($_REQUEST), 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()), 'debug-thankyou-stripe-subscription.txt');
		//$this->debug($_REQUEST, '', 'debug-thankyou-stripe-subscription.txt');

		$this->lang->load('var_lang.php', $lang);

		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		//$stripe = $this->Payment->get_setting_type('Stripe');

		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$cart = $this->Cart->get($sess[0]->session_id);

		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['category'] = $category;
		$data['cart'] = $cart;
		$data['property'] = $property;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['languages'] = $this->Language->get_active();
		$data['shipping_available'] = $this->Shipping->get_available_country();
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}

		$id = $this->input->post('subscription_id');
		if(!$id){
			$data['error'] = 'Oops something went wrong!';
			$this->load->view('website/page.thankyou.subscription.php', $data);
			return;
		}

		$subscription = $this->Subscription->get_by_id_and_member_id($id, $sess[0]->member_id);
		$plan = $this->Plan->get_billing_plan_by_id($subscription[0]->id_billing_plan);

		$data['plan'] = $plan;
		$data['subscription'] = $subscription;
		
		//clear out the cart
		$this->Cart->remove($session_id);

		//add to mailer
		$this->Mailer->add_user_for_subscription($id);
		
		$this->load->view('website/page.thankyou.subscription.php', $data);
	}

	function paypal_subscription($lang, $subscr_id='')
	{
		//debug
		//$this->debug(json_encode($_REQUEST), 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()), 'debug-thankyou-paypal-subscription.txt');
		//$this->debug($_REQUEST, '', 'debug-thankyou-paypal-subscription.txt');

		$this->lang->load('var_lang.php', $lang);

		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		//$paypal = $this->Payment->get_setting_type('PayPal');

		$language = $this->Language->get_2code($lang);
		$session_id = $this->Session->getcode();
		$property = $this->Property->get();
		$sumcart = $this->Cart->get_sum($sess[0]->session_id);
		$category = $this->Category->get_active_category_tree($language[0]->code, $property);
		$cart = $this->Cart->get($sess[0]->session_id);

		$data['property'] = $property;
		$data['language'] = $language;
		$data['sess'] = $sess;
		$data['currency'] = $this->Currency->get_array();
		$data['sumcart'] = $sumcart;
		$data['category'] = $category;
		$data['cart'] = $cart;
		$data['property'] = $property;
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['languages'] = $this->Language->get_active();
		$data['shipping_available'] = $this->Shipping->get_available_country();
		if($sess[0]->member_id){
			$data['member'] = $this->Member->get_id($sess[0]->member_id);
		}

		$id = '';
		if($subscr_id){
			$id = str_replace('subscr-', '', $subscr_id);
		}

		$auth = $this->input->get('auth');
		$form_charset = $this->input->get('form_charset');

		if(!$id || !$auth || !$form_charset){
			$data['error'] = 'Oops something went wrong!';
			$this->load->view('website/page.thankyou.subscription.php', $data);
			return;
		}

		$subscription = $this->Subscription->get_by_id_and_member_id($id, $sess[0]->member_id);
		$plan = $this->Plan->get_billing_plan_by_id($subscription[0]->id_billing_plan);

		if(!$subscription){
			$data['error'] = 'Oops something went wrong!';
			$this->load->view('website/page.thankyou.subscription.php', $data);
			return;
		}

		$data['plan'] = $plan;
		$data['subscription'] = $subscription;
		
		//clear out the cart
		$this->Cart->remove($session_id);
		
		//add to mailer		
		$this->Mailer->add_user_for_subscription($id);
		
		$this->load->view('website/page.thankyou.subscription.php', $data);
	}

	//debug($str, 'file: ' . __FILE__ .' line: '. __LINE__ .' time: '. date("Y-m-d H:i:s", time()));
	function debug( $msg, $line='', $file='' )
	{
		if(is_array($msg))
		{
			ob_start();
			print_r($msg);
			$msg = ob_get_clean();
		}

		if(!$file){
			$file = 'debug.txt';
		}

		$line = $line ? "\r\n--$line--\r\n" : "\r\n---\r\n";
		file_put_contents($file, $line . $msg, FILE_APPEND);
	}
}