<?php

class Web_wishlist extends CI_Controller{

	function index($lang)
	{
		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$product_id = $this->input->get('product_id');
		$language = $this->Language->get_2code($lang);
		$property = $this->Property->get();
		
		if($product_id){
			
			$product = $this->Product->get_id($product_id);
			$unit = $this->input->get('unit');
			if($unit == false){
				$unit = 1;
			}
			
			$arr['session_id'] = $session_id;
			$arr['product_id'] = $product_id;
			$arr['entered'] = date('Y-m-d H:i:s');
			
			$this->Wishlist->insert($arr);
			
			$wishlist = $this->Wishlist->get($language[0]->code, $property, $sess[0]->session_id);
			
			echo count($wishlist);
			exit;
			
		}else{
			echo 'Product Id is required!';
			exit;
		}	
	}	
	
	function mywishlist($lang)
	{

		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$language = $this->Language->get_2code($lang);
		$property = $this->Property->get();
		
		$data['property'] = $this->Property->get();
		$data['wishlist'] = $this->Wishlist->get($language[0]->code, $property, $session_id);
		$data['sess'] = $sess;
		$data['currency'] = $this->Currency->get_array();
		
		$this->load->view('website/tpl.wishlist.php', $data);
	}
	
	function delete($lang)
	{

		$this->lang->load('var_lang.php', $lang);
		
		$session_id = $this->Session->getcode();
		$sess = $this->Session->web_track($session_id);
		$language = $this->Language->get_2code($lang);
		$id = $this->input->get('id');
		
		$this->Wishlist->delete($id);
	}

}