<?php

class Activity extends CI_Model{
		
  public function __construct()
	{
		parent::__construct();
	}
	
	public function table()
	{
		$table = 'cms_user_activity_'.date('Y');
		return $table;
	}
	
	public function msg($user_id, $message)	
	{
		
		$table = $this->table();
		
		$sql = 'CREATE TABLE IF NOT EXISTS `'.$table.'` (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`user_id` int(11) COLLATE utf8_unicode_ci NOT NULL,
		`message` text COLLATE utf8_unicode_ci NOT NULL,
		`entered` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		PRIMARY KEY (`id`)
		) ';
		
		$this->db->query($sql);
		$message = addslashes($message);
		$this->db->insert($table, array('user_id'=>$user_id,'message'=>$message));
	}
	
	public function get($year)
	{

		$table = $this->table();
		
		$limit = 20;
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		$start = $page * $limit - $limit;

		$field = '';		
		switch($this->input->get('field')){
			case'message';
				$field = 'message';
			break;
			case'entered';
				$field = 'entered';
			break;
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		
		$this->db->select('*');
		$this->db->from($table);
		$this->db->join('cms_user', $table.'.user_id = cms_user.user_id');
		$this->db->where('1');
		
		if($field){
			$this->db->order_by($field, $sort);
		}else{
			$this->db->order_by('id', 'DESC');
		}
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		

	
	}
	
	public function get_by_user($user_id)
	{
		
		$user_id = $this->db->escape($user_id);
		
		$data = array();
		$table = $this->table();
		
		$limit = 100;
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		$start = $page * $limit - $limit;

		$field = '';
		switch($this->input->get('field')){
			case'message';
				$field = 'message';
			break;
			case'entered';
				$field = 'entered';
			break;
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from($table);
		$this->db->where('1');
		$this->db->where('user_id', $user_id);
		
		if($field){
			$this->db->order_by($field, $sort);
		}else{
			$this->db->order_by('id', 'DESC');
		}
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		
		if($results > 0 ) {
			$data['pages'] = ceil($results/$limit);
		
			$this->db->limit($limit, $start );
			$query = $this->db->get();
			$data['rows'] = $query->result();
		}
			
		return $data;
		

	
	}
}