<?php

class Cart extends CI_Model{


	function has_physical($session_id)
	{

		$cart = $this->get($session_id);
		$physical = false;
		
		if(empty($cart)){
			return false;	
		}elseif(!empty($cart)){
			
			foreach ($cart as $cart_item){
				if( $cart_item->product_type == 'Standard' ){
					$physical = true;
					break;
				}
			}
		}
		
		return $physical;
		
	}
	
	
	function get($session_id)
	{

		$this->db->select('*');
		$this->db->from('cms_cart');
		$this->db->join('cms_product', 'cms_cart.product_id = cms_product.product_id');
		$this->db->where('cms_cart.session_id', $session_id );
		$this->db->order_by('cart_id', 'DESC');
		$query = $this->db->get();
		
		return $query->result();
		
	}
	
	
	function get_sum($session_id)
	{
		
		$property = $this->Property->get();
		$cart_records = $this->db->get_where('cms_cart', array('session_id' => $session_id))->result_array();
		
		foreach($cart_records as $cr) {
			$cart_total = $cart_total + $cr['total'];
			$cart_weight = $cart_weight + ($cr['weight']*$cr['unit']);
			if($cr['tax'] > 0) {
				$cart_taxable = $cart_taxable + $cr['total'];
			}
			$currency = $cr['currency'];
		}

		$cart = array();
 		$cart[0] = new stdClass();		
 		$cart[0]->cart_total = $cart_total;	
		$cart[0]->cart_tax = ($property[0]->store_tax * .01) * $cart_taxable;
		$cart[0]->cart_weight = $cart_weight;
		$cart[0]->cart_cost = $cart_total;	
		$cart[0]->grand_total = $cart[0]->cart_total + $cart[0]->cart_tax;	
		$cart[0]->cart_cost = $cart_total;
		$cart[0]->currency = $currency;

		return $cart;
		
		
// 		$this->db->select_sum('total','cart_total');
// 		$this->db->select_sum('total_tax','cart_tax');
// 		$this->db->select('SUM(weight * unit) AS cart_weight');
// 		$this->db->select('SUM(total) - SUM(total_tax) AS cart_cost');
// 		$this->db->select('currency');
// 		$this->db->from('cms_cart');
// 		$this->db->where('session_id', $session_id );
// 		$query = $this->db->get();
// 
// 		$sum = $query->result();
// 		
// 		if($sum){
// 			
// 			$cart_total = 
// 			foreach($sum as &$cart_item) {
// 			
// 			
// 			print_r($cart_item->cart_tax);
// 			}
// 		
// 		}
// 		
// 		die();
// 		
// 		return $query->result();
	}
	
	function insert($arr){
		$this->db->insert('cms_cart', $arr);
		return $this->db->insert_id();
	}
	
	function update($session_id, $cart_id, $arr)
	{
		$this->db->where('cart_id', $cart_id);
		$this->db->where('session_id', $session_id);
		$this->db->update('cms_cart', $arr);
	}
	
	function delete($session_id, $cart_id)
	{		
		$this->db->where('cart_id', $cart_id);
		$this->db->delete('cms_cart');
	}
	
	function remove($session_id){
		$this->db->where('session_id', $session_id);
		$this->db->delete('cms_cart');
	}
	
	function insert_shipping_cart($arr)
	{
		$this->db->insert('cms_cart_shipping', $arr);
		return $this->db->insert_id();
	}
	
	function delete_shipping_cart($session_id)
	{
		$this->db->where('session_id', $session_id);
		$this->db->delete('cms_cart_shipping');
	}
	
	function get_shipping_cost($session_id)
	{

		$this->db->select('*');
		$this->db->from('cms_cart_shipping');
		$this->db->where('session_id', $session_id );
		$query = $this->db->get();
	
		return $query->result();
	}

}