<?php

class Content extends CI_Model{

	function get()
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1;}
		$q = addslashes($this->input->get('q'));
		$category_id = $this->input->get('category_id');
		$article_status = $this->input->get('article_status');
		$limit = 10;
		$start = $page * $limit - $limit;
		
		$field = '';
		switch($this->input->get('field'))
		{
			case"article_id";
				$field = $this->input->get('field');
			break;
			case"category_id";
				$field = $this->input->get('field');
			break;
			case"parent_id";
				$field = $this->input->get('field');
			break;
			case"article_slug";
				$field = $this->input->get('field');
			break;
			case"article_title";
				$field = $this->input->get('field');
			break;
			case"article_meta";
				$field = $this->input->get('field');
			break;
			case"article_description";
				$field = $this->input->get('field');
			break;
			case"user_id";
				$field = $this->input->get('field');
			break;
			case"article_date";
				$field = $this->input->get('field');
			break;
			case"article_view";
				$field = $this->input->get('field');
			break;
			case"article_comment";
				$field = $this->input->get('field');
			break;
			case"article_share";
				$field = $this->input->get('field');
			break;
			case"article_type";
				$field = $this->input->get('field');
			break;
			case"article_status";
				$field = $this->input->get('field');
			break;
			case"article_updated";
				$field = $this->input->get('field');
			break;
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_article');
		$this->db->where('1');
		
		if($q){
			$this->db->like('article_title', $q);
			$this->db->or_like('article_description', $q);
			$this->db->or_like('article_detail', $q);
		}
		if($category_id){
			$this->db->where('category_id', $category_id);
		}
		if($article_status == '0'){
			$this->db->where('article_status', $article_status);
		}else if($article_status == '1'){
			$this->db->where('article_status', $article_status);	
		}
		
		if($field){
			$this->db->order_by($field, $sort);
		}else{
			$this->db->order_by('sticky_post', 'DESC');
			$this->db->order_by('article_date', 'DESC');
		}
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		
	}

	function get_meta($content) {
	
		
		if(isset($content[0]->article_meta)) {
			$meta_output = "";
			$md = json_decode($content[0]->article_meta,true);
			

			if(is_array($md)) {	
			
				if(isset($md['fb_og_title']) && $md['fb_og_title'] != "") {
					$meta_output .= '<meta property="og:title" content="'. strip_tags ($md['fb_og_title'] ).'"/>';
				} else {	
					$meta_output .= '<meta property="og:title" content="'. strip_tags ($content[0]->article_title ).'"/>'; 
				}
				
				if(isset($md['fb_og_type']) && $md['fb_og_type'] != "") {
					$meta_output .= '<meta property="og:type" content="'. strip_tags ($md['fb_og_type'] ).'"/>';
				} else {
					$meta_output .= '<meta property="og:type" content="website"/>';
				}
				
				if(isset($md['fb_og_description']) && $md['fb_og_description'] != "") {
					$meta_output .= '<meta property="og:description" content="'. strip_tags ($md['fb_og_description']) .'"/>';
				} else {
					$meta_output .= '<meta property="og:description" content="'. strip_tags ($content[0]->article_detail) .'"/>';
				}
				
				
				if(isset($md['fb_thumbnail']) && $md['fb_thumbnail'] != "") {
					$meta_output .= '<meta property="og:image" content="'.pages_url().'/slide/'. $md['fb_thumbnail'] .'/full" />';
				} else {
					$meta_output .= '<meta property="og:image" content="'.pages_url().'/slide/'. $content[0]->thumbnail .'/full" />';
				}
				
				if(isset($md['youtube_id']) && $md['youtube_id'] != "" && $this->input->get('redirect_yt')==1 ) {
					$meta_output .= '<script type="text/javascript">function reloadToYt(){window.location = "https://www.youtube.com/watch?v='.$md['youtube_id'].'";}</script>';
				}
				
				$content[0]->meta_data = $meta_output;
			}
			
			
			
		}
		return $content;
		
	}
	
	function get_id($article_id){
		$query = $this->db->get_where('cms_article', array('article_id'=>$article_id));
		return $query->result();
	}

	function get_allow_sub_content()
	{
		$this->db->order_by('article_id','desc');
		$query = $this->db->get_where('cms_article', array('article_allow_subcontent'=>1));
		return $query->result();
	}

	function insert($arr)
	{
		$this->db->insert('cms_article', $arr);
		return $this->db->insert_id();
	}
	
	function update($article_id, $arr)
	{
		$this->db->where('article_id', $article_id);
		$this->db->update('cms_article', $arr);
	}
	
	function delete($article_id)
	{
		$this->db->where('article_id', $article_id);
		$this->db->delete('cms_article');
	}
	
	
	function insert_lang($lang, $arr)
	{
		$table = 'cms_article_lang_'.strtolower($lang);
		$this->db->insert($table, $arr);
		return $this->db->insert_id();
	}
	
	function update_lang($lang, $id, $arr)
	{
		$table = 'cms_article_lang_'.strtolower($lang);
		$this->db->where('id', $id);
		$this->db->update($table, $arr);
	}
	
	function delete_lang($lang, $id){
		$table = 'cms_article_lang_'.strtolower($lang);
		$this->db->where('id', $id);
		$this->db->delete($table);
	}
	
	function get_lang_id($lang, $article_id)
	{
		$table = 'cms_article_lang_'.strtolower($lang);
		$this->db->where('article_id', $article_id);
		$query = $this->db->get($table);
		return $query->result();
	}
	
	function get_slug($slug)
	{
	
		$this->db->where('article_slug', $slug);
		$query = $this->db->get('cms_article');
		return $query->result();
		
	}
	
	function post_view($article_id)
	{
	
		$this->db->set('article_view', 'article_view+1', FALSE); //don't escape the field, so the value will be used without '
		$this->db->where('article_id', $article_id);
		$this->db->update('cms_article'); 
		
	}

	function get_post_by_member($member_id)
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1;}
		$q = addslashes($this->input->get('q'));
		$category_id = $this->input->get('category_id');
		$article_status = $this->input->get('article_status');
		$limit = 10;
		$start = $page * $limit - $limit;
				
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_article');
		$this->db->where('member_id', $member_id);
		$this->db->where('article_status', '1');
			$this->db->order_by('sticky_post', 'DESC');
			$this->db->order_by('article_date', 'DESC');
		
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		
	
	}
	
	function latest($lang, $property)
	{
	
		$lang = $this->db->escape($lang);

		if($lang == $property['0']->lang){
		
			$this->db->select('article_slug AS slug,  article_title AS title, article_description AS description, thumbnail');
			$this->db->from('cms_article');
			$this->db->where('article_status', '1');
			$this->db->order_by('sticky_post', 'DESC');
			$this->db->order_by('article_date', 'DESC');
			$this->db->limit(6,0);
		
		}else{
			
			$table = "cms_article_lang_".strtolower($lang);
			
			$this->db->select('article_slug AS slug,  article_title AS title, article_description AS description, thumbnail');
			$this->db->from( $table );
			$this->db->where('article_status', '1');
			$this->db->order_by('sticky_post', 'DESC');
			$this->db->order_by('article_date', 'DESC');
			$this->db->limit(6,0);
		}
		
		$query = $this->db->get();
		return $query->result();
		
	}
	
	function get_active()
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1;}
		$q = addslashes($this->input->get('q'));
		$category_id = $this->input->get('category_id');
		$article_status = $this->input->get('article_status');
		$limit = 10;
		$start = $page * $limit - $limit;
		
		$field = '';
		switch($this->input->get('field'))
		{
			case"article_id";
				$field = $this->input->get('field');
			break;
			case"category_id";
				$field = $this->input->get('field');
			break;
			case"parent_id";
				$field = $this->input->get('field');
			break;
			case"article_slug";
				$field = $this->input->get('field');
			break;
			case"article_title";
				$field = $this->input->get('field');
			break;
			case"article_meta";
				$field = $this->input->get('field');
			break;
			case"article_description";
				$field = $this->input->get('field');
			break;
			case"user_id";
				$field = $this->input->get('field');
			break;
			case"article_date";
				$field = $this->input->get('field');
			break;
			case"article_view";
				$field = $this->input->get('field');
			break;
			case"article_comment";
				$field = $this->input->get('field');
			break;
			case"article_share";
				$field = $this->input->get('field');
			break;
			case"article_type";
				$field = $this->input->get('field');
			break;
			case"article_status";
				$field = $this->input->get('field');
			break;
			case"article_updated";
				$field = $this->input->get('field');
			break;
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->select('cms_article.thumbnail AS thumbnail');
		$this->db->from('cms_article');
// 		$this->db->join('cms_user', 'cms_user.user_id = cms_article.user_id');
		$this->db->join('cms_category', 'cms_category.category_id = cms_article.category_id ');
		$this->db->where('article_status', '1');
		
		if($q){
			$this->db->like('article_title', $q);
			$this->db->or_like('article_description', $q);
			$this->db->or_like('article_detail', $q);
		}
		if($category_id){
			$this->db->where('category_id', $category_id);
		}
		if($article_status == '0'){
			$this->db->where('article_status', $article_status);
		}else if($article_status == '1'){
			$this->db->where('article_status', $article_status);	
		}
		
		$this->db->where("article_date <= NOW()");
		
		if($field){
			$this->db->order_by($field, $sort);
		}else{
			$this->db->order_by('sticky_post', 'DESC');
			$this->db->order_by('article_date', 'DESC');
		}
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;	
	}
	
	function get_related($category_id, $article_id)
	{
		
		$this->db->select('*');
		$this->db->from('cms_article');
		$this->db->where('article_id <', $article_id);
		$this->db->where('article_status', '1');
			$this->db->order_by('sticky_post', 'DESC');
			$this->db->order_by('article_date', 'DESC');
		$this->db->limit('0', '5' );
		$query = $this->db->get();
		
		return $query->result();
		
	}
	
	function get_child($parent_id)
	{	
		
		$this->db->select('*');
		$this->db->from('cms_article');
		$this->db->where('1');
		$this->db->where('article_status', '1');
		$this->db->where('parent_id', $parent_id);
		$this->db->where('article_date <= NOW()');		
			$this->db->order_by('sticky_post', 'DESC');
			$this->db->order_by('article_date', 'DESC');
		$query = $this->db->get();

		return $query->result();
	}
	
	function get_by_category_slug($slug)
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1;}
		$q = addslashes($this->input->get('q'));
		$category_id = $this->input->get('category_id');
		$article_status = $this->input->get('article_status');
		$limit = 10;
		$start = $page * $limit - $limit;
		
		$field = '';
		switch($this->input->get('field'))
		{
			case"article_id";
				$field = $this->input->get('field');
			break;
			case"category_id";
				$field = $this->input->get('field');
			break;
			case"parent_id";
				$field = $this->input->get('field');
			break;
			case"article_slug";
				$field = $this->input->get('field');
			break;
			case"article_title";
				$field = $this->input->get('field');
			break;
			case"article_meta";
				$field = $this->input->get('field');
			break;
			case"article_description";
				$field = $this->input->get('field');
			break;
			case"user_id";
				$field = $this->input->get('field');
			break;
			case"article_date";
				$field = $this->input->get('field');
			break;
			case"article_view";
				$field = $this->input->get('field');
			break;
			case"article_comment";
				$field = $this->input->get('field');
			break;
			case"article_share";
				$field = $this->input->get('field');
			break;
			case"article_type";
				$field = $this->input->get('field');
			break;
			case"article_status";
				$field = $this->input->get('field');
			break;
			case"article_updated";
				$field = $this->input->get('field');
			break;
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->select('cms_article.thumbnail AS thumbnail');
		$this->db->from('cms_article');
// 		$this->db->join('cms_user', 'cms_user.user_id = cms_article.user_id');
		$this->db->join('cms_category', 'cms_category.category_id = cms_article.category_id ');
		$this->db->where('article_status', '1');
		$this->db->where('cms_article.parent_id', '0');
		$this->db->where('cms_category.category_slug', $slug);
		
		if($q){
			$this->db->like('article_title', $q);
			$this->db->or_like('article_description', $q);
			$this->db->or_like('article_detail', $q);
		}
		if($category_id){
			$this->db->where('category_id', $category_id);
		}
		if($article_status == '0'){
			$this->db->where('article_status', $article_status);
		}else if($article_status == '1'){
			$this->db->where('article_status', $article_status);	
		}
		
		$this->db->where("article_date <= NOW()");
		
		if($field){
			$this->db->order_by($field, $sort);
		}else{
			$this->db->order_by('sticky_post', 'DESC');
			$this->db->order_by('article_date', 'DESC');
		}
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
		
		

		return $data;	
	
	}
	
	function get_by_user($slug)
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1;}
		$q = addslashes($this->input->get('q'));
		$category_id = $this->input->get('category_id');
		$article_status = $this->input->get('article_status');
		$limit = 10;
		$start = $page * $limit - $limit;
		
		$field = '';
		switch($this->input->get('field'))
		{
			case"article_id";
				$field = $this->input->get('field');
			break;
			case"category_id";
				$field = $this->input->get('field');
			break;
			case"parent_id";
				$field = $this->input->get('field');
			break;
			case"article_slug";
				$field = $this->input->get('field');
			break;
			case"article_title";
				$field = $this->input->get('field');
			break;
			case"article_meta";
				$field = $this->input->get('field');
			break;
			case"article_description";
				$field = $this->input->get('field');
			break;
			case"user_id";
				$field = $this->input->get('field');
			break;
			case"article_date";
				$field = $this->input->get('field');
			break;
			case"article_view";
				$field = $this->input->get('field');
			break;
			case"article_comment";
				$field = $this->input->get('field');
			break;
			case"article_share";
				$field = $this->input->get('field');
			break;
			case"article_type";
				$field = $this->input->get('field');
			break;
			case"article_status";
				$field = $this->input->get('field');
			break;
			case"article_updated";
				$field = $this->input->get('field');
			break;
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->select('cms_article.thumbnail AS thumbnail');
		$this->db->from('cms_article');
 		$this->db->join('cms_user', 'cms_user.user_id = cms_article.user_id');
		$this->db->join('cms_category', 'cms_category.category_id = cms_article.category_id ');
		$this->db->where('article_status', '1');
		$this->db->where('cms_article.parent_id', '0');
		$this->db->where('cms_user.user_firstname', $slug);
		
		if($q){
			$this->db->like('article_title', $q);
			$this->db->or_like('article_description', $q);
			$this->db->or_like('article_detail', $q);
		}
		if($category_id){
			$this->db->where('category_id', $category_id);
		}
		if($article_status == '0'){
			$this->db->where('article_status', $article_status);
		}else if($article_status == '1'){
			$this->db->where('article_status', $article_status);	
		}
		
		$this->db->where("article_date <= NOW()");
		
		if($field){
			$this->db->order_by($field, $sort);
		}else{
			$this->db->order_by('sticky_post', 'DESC');
			$this->db->order_by('article_date', 'DESC');
		}
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
		
		return $data;	
		
	
	
	}
	
	function update_db()
	{
	
		$query = $this->db->get('cms_article');
		
		if(is_array( $query->row_array() )) {
			$tar = $query->row_array();
			
			if (!array_key_exists("sticky_post",$tar)) {
				$sql = "ALTER TABLE cms_article ADD sticky_post INT(10) NOT NULL;";
				$this->db->query($sql);
			}
		}
	}
	
}