<?php

class Currency extends CI_Model{

	function get(){
		$query = $this->db->get('cms_currency');
		return $query->result();
	}
	
	function get_active()
	{
		$this->db->where('active','1');
		$query = $this->db->get('cms_currency');
		return $query->result();
	}
	
	function insert($arr)
	{
		$this->db->insert('cms_currency', $arr);
		return $this->db->insert_id;
	}
	
	function update($id, $arr)
	{
		$this->db->where('id', $id);
		$this->db->update('cms_currency', $arr);
	}
	
	function delete($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('cms_currecy');
	}
	
	function get_array()
	{
		$currency = $this->get();
		foreach($currency as $index=>$value){
			$arr[$value->code] = $value->value_usd;
		}
		
		return $arr;
	}
	
	function convert($price, $from, $to, $currency)
	{
		if($from != $to){
			$value = ($price/$currency[$from]) * $currency[$to];
			return number_format($value,2,'.',',');
		}else{
			return number_format($price,2,'.',',');		
		}
	}
	
	function get_code($code)
	{
		$this->db->where('code', $code);
		$query = $this->db->get('cms_currency');
		return $query->result();
	}

}