<?php

class Email extends CI_Model{

	public $remote_db;
	
	
	function insert($arr)
	{
		$this->db->insert('cms_emails', $arr);
		return $this->db->insert_id();
	}
	
	function update($id, $arr)
	{
		$this->db->where('id', $id);
		$this->db->update('cms_emails', $arr);
	}
	
	function delete($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('cms_emails');
	}
	
	function get_id($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('cms_emails');
		return $query->result();
	}

	function get_ids($ids)
	{
		$this->db->where_in('id', $ids);
		$query = $this->db->get('cms_emails');
		return $query->result();
	}
	
	function get_type($email_type)
	{
		$this->db->where_in('email_type', $email_type);
		$query = $this->db->get('cms_emails');
		return $query->result();
	}
	
	function get()
	{
		switch($this->input->get('field')){
			case'id':
				$field = $this->input->get('field');
				break;
			case'email_name':
				$field = $this->input->get('field');
				break;
			case'email_type':
				$field = $this->input->get('field');
				break;
			default:
				$field = 'id';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_emails');
		
		$this->db->order_by($field, $sort);
		$query = $this->db->get();
		
		return $query->result();
	}
	
	function get_email_template($email_type) {
		$html = "";
		$email = $this->get_type($email_type);
		if($email) {
			$html = $email[0]->email_html;
		}
		return $html;
	}
	
	function get_email_subject($email_type) {
		$subject = "";
		$email = $this->get_type($email_type);
		if($email) {
			$subject = $email[0]->email_subject;
		}
		return $subject;
	
	}

	function send_branded_email($to, $subject, $email_message) {

		
		$property = $this->Property->get();
		$from = $property[0]->property_email;
		
		//merge with SITE TEMPLATE
		$site_template = $this->get_email_template( "Site Email Template" );
		$email_message = str_replace('{email-body}', $email_message, $site_template);
		
		//setup a nothing data-record
		$data_record = array();
		
		//pass the message thru the FILTER
		$email_message = $this->message_filter( $data_record , $email_message);

		
		//pass the subject thru as well
		$subject = $this->message_filter( $data_record , $subject );
	
		$this->Sendmail->send_email($to, $from, $subject, $email_message);
		//$this->Sendmail->send_email($property[0]->property_email, $from, $subject, $email_message);

	
	}
	
	function send_template_email($email_template, $data_record) {
	
		$property = $this->Property->get();
		
		$from = $property[0]->property_email;
		$to = $data_record[0]->customer_email;
		
		//fallback to standard email (for new members)
		if(!$to) {
			$to = $data_record[0]->email;
		}
		
		//'Order Confirmation'
		//'Subscription Created'
		//'Subscription Payment'
		//'New Member'
		
		$email_message = $this->get_email_template( $email_template );
		
		//merge with SITE TEMPLATE
		$site_template = $this->get_email_template( "Site Email Template" );
		$email_message = str_replace('{email-body}', $email_message, $site_template);
		
		//pass the message thru the FILTER
		$email_message = $this->message_filter($data_record, $email_message);
		
		//pass the subject thru as well
		$subject = $this->message_filter( $data_record , $this->get_email_subject( $email_template ) );
	
		$this->Sendmail->send_email($to, $from, $subject, $email_message);
		//$this->Sendmail->send_email($property[0]->property_email, $from, $subject, $email_message);
	
	
	}
	
	function message_filter($payment, $email_message) {
		$property = $this->Property->get();

		$email_message = str_replace('{order_info}', $this->order_info_block($payment), $email_message);
		$email_message = str_replace('{customer_info}', $this->customer_info_block($payment), $email_message);
		$email_message = str_replace('{invoice_number}', $payment[0]->id, $email_message);
		$email_message = str_replace('{company}', $property[0]->property_name, $email_message);
		$email_message = str_replace('{shipping_info}', $this->shipping_info_block($payment), $email_message);
		$email_message = str_replace('{subscription_info}', $this->subscription_info_summary($payment), $email_message);
		$email_message = str_replace('{subscription_info_small}', $this->subscription_info_small($payment), $email_message);
		$email_message = str_replace('{subscription_payment_info}', $this->subscription_payment_info($payment), $email_message);
		$email_message = str_replace('{access_info}', $this->member_info_block($payment), $email_message);
		$email_message = str_replace('{company_info}', $this->company_info_block(), $email_message);
		$email_message = str_replace('{shipping_details}', $this->shipping_tracking_block($payment), $email_message);
						
		return $email_message;
	
	}

	function customer_info_block($payment) {
	
		$html = "";
		if(!isset($payment[0]->customer)) { return $html; }
		
		$customer = json_decode($payment[0]->customer, true);
		$country = $this->Country->get_code($customer['country']);

		$html = "";
		$html .= '<p style="line-height:22px" margin:0px>';
		$html .= $customer['firstname'] . ' '.$customer['lastname'].'<br>';
		$html .= $customer['address'] . '<br>';
		$html .= $customer['city'] . ', '. $customer['state'] . ' '. $customer['zipcode']. '<br>';
		$html .= $country[0]->name. '<br>';
		$html .= $customer['phone']. '<br>';
		$html .= '<a href="mailto:'.$payment[0]->customer_email.'">'.$payment[0]->customer_email.'</a>';
		$html .= '</p>';
				
		return $html;
	
	}
	
	function shipping_info_block($payment) {
	
		$html = "";
		if(!isset($payment[0]->customer_delivery)) { return $html; }
		if(!isset($payment[0]->customer)) { return $html; }
		
		$delivery = json_decode($payment[0]->customer_delivery,true);		
		$customer = json_decode($payment[0]->customer, true);
		$country = $this->Country->get_code($delivery['country']);
		
		$html = "";
		$html .= '<p style="line-height:22px; margin:0px">';
		$html .= $customer['firstname'] . ' '.$customer['lastname'].'<br>';
		$html .= $delivery['address'] . '<br>';
		$html .= $delivery['city'] . ', '. $delivery['state'] . ' '. $delivery['zipcode']. '<br>';
		$html .= $country[0]->name. '<br>';
		$html .= '</p>';
				
		return $html;
	
	}

	function order_info_block($payment ) {

		$html = "";
		if(!isset($payment[0]->item)) { return $html; }
		
	    $items = json_decode($payment[0]->item,true);
	
		$html = '';
		
		$html .= '<div class="table-responsive">';
        $html .= '<table class="table" style="border: solid 1px #EEE; border-collapse: collapse; width:100%">';
        $html .= '  <thead style="background-color: whitesmoke; padding: 10px;">';
        $html .= '    <tr style="border: solid 1px #eee">';
        $html .= '      <th width="50%" nowrap="nowrap">Product Name</th>';
        $html .= '      <th width="25%" nowrap="nowrap">Qty</th>';
        $html .= '      <th width="25%" nowrap="nowrap" style="padding:20px; text-align:right" >Total</th>';
        $html .= '    </tr>';
        $html .= '  </thead>';
        $html .= '  <tbody>';

		foreach($items as $index=>$value){
        	$html .= '    <tr style="border: solid 1px #eee">';
			$html .= '      <td nowrap="nowrap" style="padding:20px">'.$value['name']; 
			$html .= 			'<br><small><b>SKU:</b>'. $value['code']. '</small>';						
					$options = json_decode($value['options'],true);
					if(isset($options['Size'])){ $html .= '<br><small>'. $options['Size']. '</small>';}
					if(isset($options['Color'])){ $html .= '<br><small>'.$options['Color']. '</small>'; }
			$html .= '	    </td>';
			$html .= '	          <td nowrap="nowrap" style="padding:20px">'.$value['unit'].'</td>';
			$html .= '	          <td align="right" nowrap="nowrap" style="padding:20px">'.$value['total'].'</td>';
			$html .= '	        </tr>';
         }
      
          $html .= '</tbody>';
          $currency = $this->Currency->get_code($payment[0]->currency);
          
          $html .= '<tr>';
          $html .= ' <td colspan="2" align="right" nowrap="nowrap" style="padding-top:15px">Total Cost:</td>';
          $html .= '  <td width="25%" align="right" nowrap="nowrap" style="padding:15px 20px 5px 5px">'.$payment[0]->cost.'</td>';
          $html .= '</tr>';
          $html .= '<tr>';
          $html .= '  <td colspan="2" align="right" nowrap="nowrap">Tax:</td>';
          $html .= ' <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px">'.$payment[0]->tax.'</td>';
          $html .= '</tr>';
          $html .= '<tr>';
          $html .= ' <td colspan="2" align="right" nowrap="nowrap">Shipping:</td>';
          $html .= ' <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px">'.$payment[0]->delivery.'</td>';
          $html .= '</tr>';
          $html .= '<tr>';
          $html .= '  <td nowrap="nowrap" >* Currencies are in '.$currency[0]->name.'</td>';
          $html .= '  <td align="right" nowrap="nowrap"><strong>Grand Total</strong></td>';
          $html .= '  <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px"><strong>'.$payment[0]->total.'</strong></td>';
          $html .= '</tr>';
          
          if($payment[0]->payment_status) {
			$html .= '<tr>';
			$html .= '  <td nowrap="nowrap" ></td>';
			$html .= '  <td align="right" nowrap="nowrap"><strong>Payment Status:</strong></td>';
			$html .= '  <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px"><strong>'.$payment[0]->payment_status.'</strong></td>';
			$html .= '</tr>';
          }
          
        $html .= '</table>';
        $html .= '</div>';
				
		return $html;
	
	}
	
	function subscription_payment_info($transaction ) {
	
		$html = '';
		if(!isset($transaction[0]->type)) { return $html; }
		
		if($transaction[0]->type == 'Stripe') {
		
			$transaction_detail = json_decode($transaction[0]->transaction_detail, true);
			$invoice_detail = $transaction_detail['data']['object'];
			if(is_array($invoice_detail))
			{
				$total          = $invoice_detail['total'] / 100;
				$currency       = strtoupper($invoice_detail['currency']);
				$payment_status = $transaction[0]->payment_status;
				$updated        = $transaction[0]->payment_updated;
			}
			
		} elseif($transaction[0]->type == 'PayPal') {
		
			$transaction_detail = json_decode($transaction[0]->transaction_detail, true);
			if(!empty($transaction_detail))
			{
				$total          = $transaction_detail['mc_gross'];
				$currency       = strtoupper($transaction_detail['mc_currency']);
				$payment_status = $transaction[0]->payment_status;
				$updated        = $transaction[0]->payment_updated;
			}
		}
            

		
		if($total) {
			$items = json_decode($transaction[0]->item,true);

			$html .= '<div class="table-responsive">';
			$html .= '<table class="table" style="border: solid 1px #EEE; border-collapse: collapse; width:100%">';
			$html .= '  <thead style="background-color: whitesmoke; padding: 10px;">';
			$html .= '    <tr style="border: solid 1px #eee">';
			$html .= '      <th width="25%" nowrap="nowrap" style="padding:20px;">Date</th>';
			$html .= '      <th width="50%" nowrap="nowrap" style="padding:20px;">Item</th>';
			$html .= '      <th width="25%" nowrap="nowrap" style="padding:20px;text-align:right" >Total</th>';
			$html .= '    </tr>';
			$html .= '  </thead>';
			$html .= '  <tbody>';

			foreach($items as $index=>$value){
				$html .= '    <tr style="border: solid 1px #eee">';
				$html .= '	          <td nowrap="nowrap" style="padding:20px">'.$updated .'</td>';
				$html .= '      <td nowrap="nowrap" style="padding:20px">'.$value['name']; 
				$html .= 			'<br><small><b>SKU:</b>'. $value['code']. '</small>';						
						$options = json_decode($value['options'],true);
						if(isset($options['Size'])){ $html .= '<br><small>'. $options['Size']. '</small>';}
						if(isset($options['Color'])){ $html .= '<br><small>'.$options['Color']. '</small>'; }
				$html .= '	    </td>';
				$html .= '	          <td align="right" nowrap="nowrap" style="padding:20px">'.$total.'</td>';
				$html .= '	        </tr>';
			 }
	  
			  $html .= '</tbody>';
		  
			  $html .= '<tr>';
			  $html .= '  <td nowrap="nowrap" >* Currencies are in '.$currency.'</td>';
			  $html .= '  <td align="right" nowrap="nowrap"><strong>Amount Paid:</strong></td>';
			  $html .= '  <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px"><strong>'.$total.'</strong></td>';
			  $html .= '</tr>';
		  
			  if($payment[0]->payment_status) {
				$html .= '<tr>';
				$html .= '  <td nowrap="nowrap" ></td>';
				$html .= '  <td align="right" nowrap="nowrap"><strong>Payment Status:</strong></td>';
				$html .= '  <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px"><strong>'.$payment_status.'</strong></td>';
				$html .= '</tr>';
			  }
		  
			$html .= '</table>';
			$html .= '</div>';
		}
				
		return $html;
	
	}
	
	function subscription_info_small($subscription) {
	
		$html = '';
		if(!isset($subscription[0]->subscr_detail)) { return $html; }

		  if($subscription[0]->subscr_detail)
		  {
			  $plan = json_decode($subscription[0]->subscr_detail);
			  $interval = $plan->interval_count ? ($plan->interval_count. ' / '.$plan->interval) : $plan->interval_count;
			  
			  $html = '';

			  $html .= '<table style="border: solid 1px #EEE;">';
			  $html .= '<tr><td>Name:</td><td style="text-align: right;">&nbsp;'.$plan->name.'</td></tr>';
			  $html .= '<tr><td>Price:</td><td style="text-align: right;">&nbsp;'.$plan->price.'</td></tr>';
			  $html .= '<tr><td>Interval:</td><td style="text-align: right;">&nbsp;'.$interval.'</td></tr>';
			  $html .= '<tr><td>Trial:</td><td style="text-align: right;">&nbsp;'.$plan->trial_period.'</td></tr>';
			  if($subscription[0]->trial_period){
				  $trial_start = $subscription[0]->trial_start ? $subscription[0]->trial_start : ' - ';
				  $trial_end = $subscription[0]->trial_end ? $subscription[0]->trial_end : ' - ';
				  $html .= '<tr><td>Trial start:</td><td style="text-align: right;">&nbsp;'.$trial_start.'</td></tr>';
				  $html .= '<tr><td>Trial end:</td><td style="text-align: right;">&nbsp;'.$trial_end.'</td></tr>';
			  }
			  $html .= '<tr><td>Subscription Type:</td><td style="text-align: right;">'.$subscription[0]->type.'</td></tr>';
			  $html .= '<tr><td>Subscription Status:</td><td style="text-align: right;">'.ucfirst($subscription[0]->status).'</td></tr>';
			  if(ucfirst($subscription[0]->status) == STATUS_CANCELLED){
				  $note = $subscription[0]->note ? $subscription[0]->note : ' --- ';
				  $html .= '<tr><td>Subscription Canceled:</td><td style="text-align: right;">'.$note.'</td></tr>';
			  }
			  $html .= '</table>';
		  }

		return $html;
	}
	
	function subscription_info_summary($subscription ) {
		
		$html = '';
		if(!isset($subscription[0]->subscr_detail)) { return $html; }
				
		if($subscription[0]->subscr_detail) {
		  
			$items = json_decode($subscription[0]->item,true);
			$plan = json_decode($subscription[0]->subscr_detail);
			$interval = $plan->interval_count ? ($plan->interval_count. ' / '.$plan->interval) : $plan->interval_count;
	
		
			$html .= '<div class="table-responsive">';
			$html .= '<table class="table" style="border: solid 1px #EEE; border-collapse: collapse; width:100%">';
			$html .= '  <thead style="background-color: whitesmoke; padding: 10px;">';
			$html .= '    <tr style="border: solid 1px #eee">';
			$html .= '      <th width="50%" nowrap="nowrap" style="padding:20px">Name</th>';
			$html .= '      <th width="25%" nowrap="nowrap" style="padding:20px">Interval</th>';
			$html .= '      <th width="25%" nowrap="nowrap" style="padding:20px" align="right" >Amount</th>';
			$html .= '    </tr>';
			$html .= '  </thead>';
			
			foreach($items as $index=>$value){
				$html .= '  <tbody>';
				$html .= '    <tr style="border: solid 1px #eee">';
				$html .= '      <td nowrap="nowrap" style="padding:20px">'.$value['name']; 
				$html .= 			'<br><small><b>Plan:</b>'. $plan->name . '</small>';						
				$html .= '	    </td>';
				$html .= '	          <td nowrap="nowrap" style="padding:20px">'.$interval.'</td>';
				$html .= '	          <td align="right" nowrap="nowrap" style="padding:20px">'.$plan->price .'</td>';
				$html .= '	        </tr>';
				$html .= '</tbody>';
			}
			  $currency = $this->Currency->get_code($subscription[0]->currency);
		  
			  if($subscription[0]->trial_period){
				  $trial_start = $subscription[0]->trial_start ? $subscription[0]->trial_start : ' - ';
				  $trial_end = $subscription[0]->trial_end ? $subscription[0]->trial_end : ' - ';
			  
				  $html .= '<tr>';
				  $html .= ' <td colspan="2" align="right" nowrap="nowrap" style="padding-top:15px">Trial Start:</td>';
				  $html .= '  <td width="25%" align="right" nowrap="nowrap" style="padding:15px 20px 5px 5px">'.$trial_start.'</td>';
				  $html .= '</tr>';
				  $html .= '<tr>';
				  $html .= '  <td colspan="2" align="right" nowrap="nowrap">Trial End:</td>';
				  $html .= ' <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px">'.$trial_end.'</td>';
				  $html .= '</tr>';
			   }
			  $html .= '<tr>';
			  $html .= ' <td colspan="2" align="right" nowrap="nowrap">Subscription Type:</td>';
			  $html .= ' <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px">'.$subscription[0]->type.'</td>';
			  $html .= '</tr>';
			  $html .= '<tr>';
			  $html .= '  <td nowrap="nowrap" >* Currencies are in '.$currency[0]->name.'</td>';
			  $html .= '  <td align="right" nowrap="nowrap"><strong>Subscription Status:</strong></td>';
			  $html .= '  <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px"><strong>'.ucfirst($subscription[0]->status).'</strong></td>';
			  $html .= '</tr>';
		  

			$html .= '</table>';
			$html .= '</div>';
    
    	}
				
		return $html;
	
	}
	
	function member_info_block($member) {
		
		$html = "";
		if(!isset($member[0]->email)) { return $html; }
					
		$html .= '<p style="line-height:22px">';
		$html .= 'Access: <a href="'.base_url().'en/login">'.base_url()."en/login</a><br>";
		$html .= 'username: '.$member[0]->email."<br>";
		$html .= '</p>';
		$html .= '<br>';
		
		return $html;
	
	}
	
	
	function company_info_block() {

		$html = "";
		
		$property = $this->Property->get();
		$country = $this->Country->get_code($property[0]->property_country);
					
		$html .= $property[0]->property_address.'<br>';
		$html .= $property[0]->property_city.', '.$property[0]->property_state.' '.$property[0]->property_zipcode.'<br>';
		$html .= $country[0]->name; 
		
		return $html;
	
	}
	
	function shipping_tracking_block($payment) {
	
	    $items = json_decode($payment[0]->item,true);
	
		$html = '';
		
		$html .= '<div class="table-responsive">';
		$html .= '<table class="table" style="border: solid 1px #EEE; border-collapse: collapse; width:100%">';
		$html .= '  <thead style="background-color: whitesmoke; padding: 10px;">';
		$html .= '    <tr style="border: solid 1px #eee">';
		$html .= '      <th width="50%" nowrap="nowrap" style="padding:10px;">Tracking #:</th>';
		$html .= '      <th width="50%" nowrap="nowrap" style="padding:10px;">'.$payment[0]->order_tracking_number.'</th>';
		$html .= '    </tr>';
		$html .= '  </thead>';
		$html .= '  <tbody>';
		$html .= '<tr style="border: solid 1px #EEE; border-collapse: collapse; width:100%">';
		$html .= ' <td align="center" nowrap="nowrap" style="padding:10px;">Carrier:</td>';
		$html .= ' <td align="center" nowrap="nowrap" style="padding:10px;">'.$payment[0]->order_shipping_carrier.'</td>';
		$html .= '</tr>';
		$html .= '<tr>';
		$html .= ' <td colspan="2" style="padding:30px;" align="left" nowrap="nowrap" >'.$payment[0]->order_notes.'</td>';
		$html .= '</tr>';
		$html .= '</tbody>';
		$html .= '</table>';
		$html .= '</div>';
				
		return $html;
	
	}	
	// function send_order_confirmation($payment) {
// 	
// 		$property = $this->Property->get();
// 		
// 		$subject = $property[0]->property_name.' - Order Confirmation #'.$payment[0]->id;
// 		$from = $property[0]->property_email;
// 		$to = $payment[0]->customer_email;
// 					
// 		$email_message = $this->get_email_template('Order Confirmation');
// 		
// 		//pass the message thru the FILTER
// 		$email_message = $this->order_text_replace($payment, $email_message);
// 		
// 		//pass the subject thru as well
// 		$subject = $this->order_text_replace($payment, $this->get_email_subject('Order Confirmation'));
// 	
// 		$this->Sendmail->send_email($to, $from, $subject, $email_message);
// 		$this->Sendmail->send_email($property[0]->property_email, $from, $subject, $email_message);
// 	
// 	
// 	}
	
// 	function order_text_replace($payment, $email_message) {
// 		$property = $this->Property->get();
// 
// 		
// 		$email_message = str_replace('{order_info}', $this->order_info_block($payment), $email_message);
// 		$email_message = str_replace('{customer_info}', $this->customer_info_block($payment), $email_message);
// 		$email_message = str_replace('{invoice_number}', $payment[0]->id, $email_message);
// 		$email_message = str_replace('{company}', $property[0]->property_name, $email_message);
// 		$email_message = str_replace('{shipping_info}', $this->shipping_info_block($payment), $email_message);
// 		
// 		
// 		return $email_message;
// 	
// 	}

// 	function customer_info_block($payment) {
// 	
// 		
// 		$customer = json_decode($payment[0]->customer, true);
// 		$country = $this->Country->get_code($customer['country']);
// 		$items = json_decode($payment[0]->item,true);
// 		$html = "";
// 		$html .= '<p style="line-height:22px">';
// 		$html .= $customer['firstname'] . ' '.$customer['lastname'].'<br>';
// 		$html .= $customer['address'] . '<br>';
// 		$html .= $customer['city'] . ', '. $customer['state'] . ' '. $customer['zipcode']. '<br>';
// 		$html .= $country[0]->name. '<br>';
// 		$html .= $customer['phone']. '<br>';
// 		$html .= '<a href="mailto:'.$payment[0]->customer_email.'">'.$payment[0]->customer_email.'</a>';
// 		$html .= '</p>';
// 		$html .= '<br>';
// 				
// 		return $html;
// 	
// 	}
// 	
// 	function shipping_info_block($payment) {
// 	
// 		$delivery = json_decode($payment[0]->customer_delivery,true);		
// 		$customer = json_decode($payment[0]->customer, true);
// 		$country = $this->Country->get_code($delivery['country']);
// 		
// 		$html = "";
// 		$html .= '<p style="line-height:22px">';
// 		$html .= $customer['firstname'] . ' '.$customer['lastname'].'<br>';
// 		$html .= $delivery['address'] . '<br>';
// 		$html .= $delivery['city'] . ', '. $delivery['state'] . ' '. $delivery['zipcode']. '<br>';
// 		$html .= $country[0]->name. '<br>';
// 		$html .= '</p>';
// 		$html .= '<br>';
// 				
// 		return $html;
// 	
// 	}
// 
// 	function order_info_block($payment ) {
// 	
// 	    $items = json_decode($payment[0]->item,true);
// 	
// 		$html = '';
// 		
// 		$html .= '<div class="table-responsive">';
//         $html .= '<table class="table" style="border: solid 1px #EEE; border-collapse: collapse; width:100%">';
//         $html .= '  <thead style="background-color: whitesmoke; padding: 10px;">';
//         $html .= '    <tr style="border: solid 1px #eee">';
//         $html .= '      <th width="50%" nowrap="nowrap">'.$this->lang->line('Product Name').'</th>';
//         $html .= '      <th width="25%" nowrap="nowrap">'.$this->lang->line('Qty').'</th>';
//         $html .= '      <th width="25%" nowrap="nowrap" style="padding:20px" align="right" >'.$this->lang->line('Total').'</th>';
//         $html .= '    </tr>';
//         $html .= '  </thead>';
//         $html .= '  <tbody>';
// 
// 		foreach($items as $index=>$value){
//         	$html .= '    <tr style="border: solid 1px #eee">';
// 			$html .= '      <td nowrap="nowrap" style="padding:20px">'.$value['name']; 
// 			$html .= 			'<br><small><b>SKU:</b>'. $value['code']. '</small>';						
// 					$options = json_decode($value['options'],true);
// 					if(isset($options['Size'])){ $html .= '<br><small>'. $options['Size']. '</small>';}
// 					if(isset($options['Color'])){ $html .= '<br><small>'.$options['Color']. '</small>'; }
// 			$html .= '	    </td>';
// 			$html .= '	          <td nowrap="nowrap" style="padding:20px">'.$value['unit'].'</td>';
// 			$html .= '	          <td align="right" nowrap="nowrap" style="padding:20px">'.$value['total'].'</td>';
// 			$html .= '	        </tr>';
//          }
//       
//           $html .= '</tbody>';
//           $currency = $this->Currency->get_code($payment[0]->currency);
//           
//           $html .= '<tr>';
//           $html .= ' <td colspan="2" align="right" nowrap="nowrap" style="padding-top:15px">'.$this->lang->line('Total Cost').':</td>';
//           $html .= '  <td width="25%" align="right" nowrap="nowrap" style="padding:15px 20px 5px 5px">'.$payment[0]->cost.'</td>';
//           $html .= '</tr>';
//           $html .= '<tr>';
//           $html .= '  <td colspan="2" align="right" nowrap="nowrap">'.$this->lang->line('Total Tax').':</td>';
//           $html .= ' <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px">'.$payment[0]->tax.'</td>';
//           $html .= '</tr>';
//           $html .= '<tr>';
//           $html .= ' <td colspan="2" align="right" nowrap="nowrap">'.$this->lang->line('Shipping').':</td>';
//           $html .= ' <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px">'.$payment[0]->delivery.'</td>';
//           $html .= '</tr>';
//           $html .= '<tr>';
//           $html .= '  <td nowrap="nowrap" >* '.$this->lang->line('Currencies are in').' '.$currency[0]->name.'</td>';
//           $html .= '  <td align="right" nowrap="nowrap"><strong>'.$this->lang->line('Grand Total').'</strong></td>';
//           $html .= '  <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px"><strong>'.$payment[0]->total.'</strong></td>';
//           $html .= '</tr>';
//           
// 
//         $html .= '</table>';
//         $html .= '</div>';
// 				
// 		return $html;
// 	
// 	}
// 	
// 	
// 	function send_subscription_creation($subscription) {
// 	
// 	
// 		log_message('debug',print_r('STRIPE SUB',TRUE));
// 		log_message('debug',print_r($subscription,TRUE));
// 					
// 		$property = $this->Property->get();
// 		
// 		$from = $property[0]->property_email;
// 		$to = $payment[0]->customer_email;
// 					
// 		$email_message = $this->get_email_template('Subscription Created');
// 		
// 		//pass the message thru the FILTER
// 		$email_message = $this->order_text_replace($subscription, $email_message);
// 		
// 		//pass the subject thru as well
// 		$subject = $this->order_text_replace($subscription, $this->get_email_subject('Subscription Created'));
// 	
// 		$this->Sendmail->send_email($to, $from, $subject, $email_message);
// 		$this->Sendmail->send_email($property[0]->property_email, $from, $subject, $email_message);
// 	
// 	
// 	}
// 	
// 	function order_text_replace($payment, $email_message) {
// 		$property = $this->Property->get();
// 
// 		
// 		$email_message = str_replace('{order_info}', $this->order_info_block($payment), $email_message);
// 		$email_message = str_replace('{customer_info}', $this->customer_info_block($payment), $email_message);
// 		$email_message = str_replace('{invoice_number}', $payment[0]->id, $email_message);
// 		$email_message = str_replace('{company}', $property[0]->property_name, $email_message);
// 		$email_message = str_replace('{shipping_info}', $this->shipping_info_block($payment), $email_message);
// 		$email_message = str_replace('{subscription_info}', $this->subscription_info_summary($payment), $email_message);
// 		$email_message = str_replace('{subscription_info_small}', $this->subscription_info_small($payment), $email_message);
// 		
// 		return $email_message;
// 	
// 	}
// 	
// 	function subscription_info_small($subscription) {
// 	
// 
// 		  if($subscription[0]->subscr_detail)
// 		  {
// 			  $plan = json_decode($subscription[0]->subscr_detail);
// 			  $interval = $plan->interval_count ? ($plan->interval_count. ' / '.$plan->interval) : $plan->interval_count;
// 			  
// 			  $html = '';
// 
// 			  $html .= '<table style="border: solid 1px #EEE;">';
// 			  $html .= '<tr><td>Name:</td><td style="text-align: right;">&nbsp;'.$plan->name.'</td></tr>';
// 			  $html .= '<tr><td>Price:</td><td style="text-align: right;">&nbsp;'.$plan->price.'</td></tr>';
// 			  $html .= '<tr><td>Interval:</td><td style="text-align: right;">&nbsp;'.$interval.'</td></tr>';
// 			  $html .= '<tr><td>Trial:</td><td style="text-align: right;">&nbsp;'.$plan->trial_period.'</td></tr>';
// 			  if($subscription[0]->trial_period){
// 				  $trial_start = $subscription[0]->trial_start ? $subscription[0]->trial_start : ' - ';
// 				  $trial_end = $subscription[0]->trial_end ? $subscription[0]->trial_end : ' - ';
// 				  $html .= '<tr><td>Trial start:</td><td style="text-align: right;">&nbsp;'.$trial_start.'</td></tr>';
// 				  $html .= '<tr><td>Trial end:</td><td style="text-align: right;">&nbsp;'.$trial_end.'</td></tr>';
// 			  }
// 			  $html .= '<tr><td>Subscription Type:</td><td style="text-align: right;">'.$subscription[0]->type.'</td></tr>';
// 			  $html .= '<tr><td>Subscription Status:</td><td style="text-align: right;">'.ucfirst($subscription[0]->status).'</td></tr>';
// 			  if(ucfirst($subscription[0]->status) == STATUS_CANCELLED){
// 				  $note = $subscription[0]->note ? $subscription[0]->note : ' --- ';
// 				  $html .= '<tr><td>Subscription Canceled:</td><td style="text-align: right;">'.$note.'</td></tr>';
// 			  }
// 			  $html .= '</table>';
// 		  }
// 
// 		return $html;
// 	}
// 	
// 	function subscription_info_summary($subscription ) {
// 		
// 		$html = '';
// 				
// 		if($subscription[0]->subscr_detail) {
// 		  
// 			$items = json_decode($subscription[0]->item,true);
// 			$plan = json_decode($subscription[0]->subscr_detail);
// 			$interval = $plan->interval_count ? ($plan->interval_count. ' / '.$plan->interval) : $plan->interval_count;
// 	
// 		
// 			$html .= '<div class="table-responsive">';
// 			$html .= '<table class="table" style="border: solid 1px #EEE; border-collapse: collapse; width:100%">';
// 			$html .= '  <thead style="background-color: whitesmoke; padding: 10px;">';
// 			$html .= '    <tr style="border: solid 1px #eee">';
// 			$html .= '      <th width="50%" nowrap="nowrap">'.$this->lang->line('Product Name').'</th>';
// 			$html .= '      <th width="25%" nowrap="nowrap">Interval</th>';
// 			$html .= '      <th width="25%" nowrap="nowrap" style="padding:20px" align="right" >Amount</th>';
// 			$html .= '    </tr>';
// 			$html .= '  </thead>';
// 			
// 			foreach($items as $index=>$value){
// 				$html .= '  <tbody>';
// 				$html .= '    <tr style="border: solid 1px #eee">';
// 				$html .= '      <td nowrap="nowrap" style="padding:20px">'.$value['name']; 
// 				$html .= 			'<br><small><b>Plan:</b>'. $plan->name . '</small>';						
// 				$html .= '	    </td>';
// 				$html .= '	          <td nowrap="nowrap" style="padding:20px">'.$interval.'</td>';
// 				$html .= '	          <td align="right" nowrap="nowrap" style="padding:20px">'.$value['total'].'</td>';
// 				$html .= '	        </tr>';
// 				$html .= '</tbody>';
// 			}
// 			  $currency = $this->Currency->get_code($subscription[0]->currency);
// 		  
// 			  if($subscription[0]->trial_period){
// 				  $trial_start = $subscription[0]->trial_start ? $subscription[0]->trial_start : ' - ';
// 				  $trial_end = $subscription[0]->trial_end ? $subscription[0]->trial_end : ' - ';
// 			  
// 				  $html .= '<tr>';
// 				  $html .= ' <td colspan="2" align="right" nowrap="nowrap" style="padding-top:15px">Trial Start:</td>';
// 				  $html .= '  <td width="25%" align="right" nowrap="nowrap" style="padding:15px 20px 5px 5px">'.$trial_start.'</td>';
// 				  $html .= '</tr>';
// 				  $html .= '<tr>';
// 				  $html .= '  <td colspan="2" align="right" nowrap="nowrap">Trial End:</td>';
// 				  $html .= ' <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px">'.$trial_end.'</td>';
// 				  $html .= '</tr>';
// 			   }
// 			  $html .= '<tr>';
// 			  $html .= ' <td colspan="2" align="right" nowrap="nowrap">Subscription Type:</td>';
// 			  $html .= ' <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px">'.$subscription[0]->type.'</td>';
// 			  $html .= '</tr>';
// 			  $html .= '<tr>';
// 			  $html .= '  <td nowrap="nowrap" >* '.$this->lang->line('Currencies are in').' '.$currency[0]->name.'</td>';
// 			  $html .= '  <td align="right" nowrap="nowrap"><strong>Subscription Status:</strong></td>';
// 			  $html .= '  <td align="right" nowrap="nowrap" style="padding:5px 20px 5px 5px"><strong>'.ucfirst($subscription[0]->status).'</strong></td>';
// 			  $html .= '</tr>';
// 		  
// 
// 			$html .= '</table>';
// 			$html .= '</div>';
//     
//     	}
// 				
// 		return $html;
// 	
// 	}
}