<?php

class Language extends CI_Model{
	
	function get(){
		
		$q = $this->input->get('q');
		
		switch($this->input->get('field')){
			case"code";
				$field = $this->input->get('field');
			break;
			case"name";
				$field = $this->input->get('field');
			break;
			case"active";
				$field = $this->input->get('field');
			break;
			default:
				$field = 'code';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		if($q){
			$this->db->like('name',$q);
		}
		if($this->input->get('field')){
			$this->db->order_by($field, $sort);
		}
		$query = $this->db->get('cms_language');
		return $query->result();
		
	}
	
	function update($code, $status)
	{
	
		$code = $this->db->escape($code);
		
		if($status == 1){
			
			$sql = "CREATE TABLE IF NOT EXISTS `cms_article_lang_".$code."` (";
			$sql .= "`id` int(11) NOT NULL AUTO_INCREMENT,";
			$sql .= "`article_id` int(11) NOT NULL,";
			$sql .= "`slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`lang` varchar(5) COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`meta` text COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`detail` text COLLATE utf8_unicode_ci NOT NULL,";			
			$sql .= "`description` text COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`user_id` int(11) NOT NULL,";
			$sql .= "`datepublish` datetime NOT NULL,";
			$sql .= "`view` int(11) NOT NULL,";
			$sql .= "`comment` int(11) NOT NULL,";
			$sql .= "`share` int(11) NOT NULL,";
			$sql .= "`status` int(11) NOT NULL,";
			$sql .= "`updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,";
			$sql .= "`entered` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',";
			$sql .= "PRIMARY KEY (`id`) ";
			$sql .= ") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
			$this->db->query($sql);
			
			$sql = "CREATE TABLE IF NOT EXISTS `cms_upload_".$code."` (";
			$sql .= "`id` int(11) NOT NULL AUTO_INCREMENT,";
			$sql .= "`upload_id` int(11) NOT NULL,";
			$sql .= "`lang` varchar(5) NOT NULL,";
			$sql .= "`caption` text COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`entered` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,";
			$sql .= "PRIMARY KEY (`id`)";
			$sql .= ") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
			$this->db->query($sql);			
			
			$sql = "CREATE TABLE IF NOT EXISTS `cms_page_lang_".$code."` ( ";
			$sql .= "`id` int(11) NOT NULL AUTO_INCREMENT,";
			$sql .= "`page_id` int(11) NOT NULL,";
			$sql .= "`slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`menu` varchar(255) COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`detail` text COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`status` int(11) NOT NULL,";
			$sql .= "`datepublish` datetime NOT NULL,";
			$sql .= "`updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,";
			$sql .= "`entered` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',";
			$sql .= "PRIMARY KEY (`id`)";
			$sql .= ") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
			$this->db->query($sql);
			
			$sql = "CREATE TABLE IF NOT EXISTS cms_gallery_lang_".$code."(";
			$sql .= "	`id` int(11) NOT NULL AUTO_INCREMENT,";
			$sql .= "	`gallery_id` int(11) NOT NULL,";
			$sql .= "	`title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "	`description` text COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "	`entered` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,";
			$sql .= "	PRIMARY KEY (`id`)";
			$sql .= ") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
			$this->db->query($sql);

			$sql = "CREATE TABLE IF NOT EXISTS `cms_product_lang_".$code."` (";
			$sql .= "`id` int(11) NOT NULL AUTO_INCREMENT,";
			$sql .= "`product_id` int(11) NOT NULL,";
			$sql .= "`description` text COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`overview` text COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`specifications` text COLLATE utf8_unicode_ci NOT NULL,";
			$sql .= "`entered` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,";
			$sql .= "PRIMARY KEY (`id`)";
			$sql .= ") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
			$this->db->query($sql);

		}
		
		$this->db->where('code', $code);
		$this->db->update('cms_language', array('active'=>$status));
		
	}
	
	function get_active()
	{
		
		$this->db->where('active', '1');
		$query = $this->db->get('cms_language');
		return $query->result();
		
	}
	
	function get_code($code)
	{
		$this->db->where('code', $code);
		$query = $this->db->get('cms_language');
		$rs = $query->result();
		return $rs;		
	}
	
		
	function get_2code($lang)
	{
		$this->db->select('*');
		$this->db->from('cms_language');
		$this->db->where('SUBSTRING(code,1,2)', $lang);
		$this->db->where('active', '1');
		$query = $this->db->get();
		$rs = $query->result();	
		if(!$rs){
			header('location:'.base_url().'file-not-found');
			exit;
		}
		return $rs;
	}
	
}