<?php

class Mailer extends CI_Model{

	function add_user_to_list($name, $email, $list)
	{
	
		$property = $this->Property->get();
	
		if($property[0]->property_mailer_url) {
		
			//Check fields
			if($name=='' || $email=='')
			{
				return false;
			}
	
			
			if($property[0]->property_mailer_url =='engage') {
			
				//we're going to add them to the engage system here
				//lets send an API request()
				
				$parts = explode(" ", $name);
				$lastname = array_pop($parts);
				$firstname = implode(" ", $parts);
				
				$url = 'https://api.elasticemail.com/v2/contact/add?
					publicAccountID='.$property[0]->property_email_host.'
					&email='.$email.'
					&publicListID='.$list.'
					&firstName='.$firstname.'
					&lastName='.$lastname.'
					&source=pages-purchase
					&sendActivation=false';
					
				$result = file_get_contents($url);
				
				//check result and redirect
				if($result) {
					return true;
				} else {
					return false;
				}
					
			
			
			} else {

	
				//Subscribe
				$postdata = http_build_query(
					array(
					'name' => $name,
					'email' => $email,
					'list' => $list,
					'boolean' => 'true'
					)
				);
	
				$opts = array('http' => array('method'  => 'POST', 'header'  => 'Content-type: application/x-www-form-urlencoded', 'content' => $postdata));
				$context  = stream_context_create($opts);
				$result = file_get_contents($property[0]->property_mailer_url.'/subscribe', false, $context);
	
			
			
				//check result and redirect
				if($result) {
					return true;
				} else {
					return false;
				}
			}
		
		} else {
	
			return false;
	
		}
	
	}
	
	function add_user_for_purchase($payment_id) {
	
		//loop through the purchase and add the user to the needed lists
		$payment = $this->db->get_where('cms_payment', array('id' => $payment_id))->row_array();

			if($payment)  {
		
				//no longer going by member since we can allow anyone to purchase without being a member
// 				$member = $this->Member->get_id( $payment['member_id'] );
// 				if($member) {
			
					//loop through all products in the payment and get the downloads
					$customer = json_decode($payment['customer'], true);
					$customer_firstname = isset($customer['firstname']) ? $customer['firstname'] : "";
					$customer_lastname = isset($customer['lastname']) ? $customer['lastname'] : "";
					
					$items = json_decode($payment['item'], true);
			
					if(!empty($items) && is_array($items)) {
			
						foreach($items as $item) {
				
							$product_id = $item['id'];
							$product = $this->db->get_where('cms_product', array('product_id' => $product_id))->row_array();
					
							if($product) {
								//add these to my list
								$this->add_user_to_list( $customer_firstname . ' ' . $customer_lastname  , $payment['customer_email'] , $product['product_form_id'] );
							}
						}
					}
				//}
			}
		
		
		return true;
	
	
	}
	
	function add_user_for_subscription($subscription_id) {
	
		//loop through the purchase and add the user to the needed lists
		$payment = $this->db->get_where('cms_subscription', array('id' => $subscription_id))->row_array();
		
		
		if($payment)  {
		
			$member = $this->Member->get_id( $payment['member_id'] );
			
			if($member) {
			
				//loop through all products in the payment and get the downloads
				$items = json_decode($payment['item'], true);
			
				if(!empty($items) && is_array($items)) {
			
					foreach($items as $item) {
				
						$product_id = $item['id'];
						$product = $this->db->get_where('cms_product', array('product_id' => $product_id))->row_array();

						
						if($product) {
							//add these to my list
							$this->add_user_to_list( $member[0]->firstname . ' ' . $member[0]->lastname , $payment['customer_email'] , $product['product_form_id'] );
						}
					}
				}
			}
		}
		
		return true;
	
	
	}
	
}	