<?php

class Media extends CI_Model{
	
	function get_type($type, $article_id)
	{
		$this->db->select('*');
		$this->db->from('cms_upload');
		$this->db->join('cms_article_upload', 'cms_article_upload.upload_id = cms_upload.upload_id ');
		$this->db->where('article_id', $article_id);
		$this->db->where('cms_upload.type', $type);
		$this->db->order_by('filedisplayorder');
		$query = $this->db->get();
		
		return $query->result();
	
	}

	function get_thumbnail($article_id)
	{

		$this->db->select('*');
		$this->db->from('cms_upload');
		$this->db->join('cms_article_upload', 'cms_article_upload.upload_id = cms_upload.upload_id ');
		$this->db->where('article_id', $article_id);
		$this->db->where('cms_upload.type', 'image');
		$this->db->order_by('filedisplayorder');
		$this->db->limit(1, 0 );
		$query = $this->db->get();
		
		
		return $query->result();
	
	}

	
	function get_id($upload_id)
	{
		$this->db->where('upload_id', $upload_id);
		$query = $this->db->get('cms_upload');
		return $query->result();
	}
	
	function get_slug($slug)
	{
		$this->db->select('*');
		$this->db->from('cms_upload');
		$this->db->join('cms_article_upload', 'cms_article_upload.upload_id = cms_upload.upload_id ');
		$this->db->where('cms_article_upload.slug', $slug);
		$query = $this->db->get();

		return $query->result();
	}
	
	function get_session($type, $session_id)
	{	
		$this->db->select('*');
		$this->db->from('cms_upload');
		$this->db->where('session_id', $session_id);
		$this->db->where('type', $type);
		$this->db->order_by('filedisplayorder');
		$query = $this->db->get();

		return $query->result();
	}
	
	function delete($upload_id)
	{
	
		$upload_id = $this->db->escape($upload_id);
		
		$query = $this->db->get_where('cms_upload',array('upload_id'=>$upload_id));
		$rs = $query->result();
		if(is_file($rs[0]->filepath)){
			unlink($rs[0]->filepath);
		}
		
		$this->db->delete('cms_upload', array('upload_id' => $upload_id));
		
		$this->db->delete('cms_article_upload', array('upload_id' => $upload_id));
						
		
	}
	
	function remove_session($upload_id)
	{
		$this->db->set('session_id', '');
		$this->db->where('upload_id',$upload_id);
		$this->db->update('cms_upload');

	}
	
	function get_folder($type)
	{
		$this->db->select('MIN(fileentered) AS mindate, MAX(fileentered) AS maxdate ');
		$this->db->from('cms_upload');
		$this->db->where('type', $type);
		$query = $this->db->get();

		return $query->result();
		
	}
	
	function get_by_month($type, $mm, $yy)
	{
		
		$period1 = date('Y-m-d', mktime(0,0,0,$mm,1,$yy));
		$period2 = date('Y-m-d', mktime(0,0,0,$mm+1,1,$yy));
		
		$limit = 10;
		$page = $this->input->get('page');
		if($page == false){ $page = 1;}
		$start = $page * $limit - $limit;
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		switch($this->input->get('field')){
			case'upload_id';
				$field = $this->input->get('field');
			break;
			case'type';
				$field = $this->input->get('field');
			break;
			case'filetype';
				$field = $this->input->get('field');
			break;
			case'filepath';
				$field = $this->input->get('field');
			break;
			case'filecaption';
				$field = $this->input->get('field');
			break;
			case'fileentered';
				$field = $this->input->get('field');
			break;
			default:
				$field = 'upload_id';
		}
		
		
		$this->db->select('*');
		$this->db->from('cms_upload');
		$this->db->where("1 AND (fileentered BETWEEN '$period1' AND '$period2') ");
		$this->db->where('type', $type);
		$this->db->order_by($field, $sort);
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		

	}
	
	function insert_lang($lang, $arr)
	{
		$table = 'cms_upload_'.strtolower($lang);
		
		$this->db->insert($table, $arr);
		return $this->db->insert_id();
		
	}

	function update_lang($lang, $id, $arr)
	{
		$table = 'cms_upload_'.strtolower($lang);
		
		$this->db->where('id', $id);
		$this->db->update($table, $arr);
		
	}
	
	function delete_lang($lang, $id)
	{
		$table = 'cms_upload_'.strtolower($lang);
		$this->db->where('id', $id);
		$this->db->delete($table);
	}
	
	function get_lang($lang, $upload_id){

		$table = 'cms_upload_'.strtolower($lang);
		$this->db->where('upload_id', $upload_id);
		$query = $this->db->get($table);
		return $query->result();
	}
	
	
}