<?php

class Member extends CI_Model{

	function insert($arr)
	{
		
		$arr['password'] = password_hash( $arr['password'] , PASSWORD_DEFAULT);
		
		$this->db->insert('cms_member', $arr);
		return $this->db->insert_id();
	}
	
	function get_id($member_id)
	{
		$this->db->where('member_id', $member_id);
		$query = $this->db->get('cms_member');
		return $query->result();
	}

	function update($member_id, $arr)
	{
		
		//check to see if this member exists as another id
		$this->db->where('member_id !=', $member_id);
		$this->db->where('email' , $arr['email'] );
		
		$query = $this->db->get('cms_member');
		
		if ($query->num_rows() == 0) {
		
			$this->db->reset_query();
			
			if( $arr['password'] != "" ) {
				$arr['password'] = password_hash( $arr['password'] , PASSWORD_DEFAULT);
			} else {
				unset( $arr['password'] );
			}
		
			$this->db->where('member_id', $member_id);
			$this->db->update('cms_member', $arr);
		
		} else {
			return false;
			
		}
	}
	
	function delete($member_id)
	{
		$this->db->where('member_id', $member_id);
		$this->db->delete('cms_member');
	}
	
	function get()
	{
		$page = $this->input->get('page');
		$q = $this->input->get('q');
		if($page == false){ $page = 1;}
		$limit = 10;
		$start = $page * $limit - $limit;
	
		switch($this->input->get('field')){
			case'member_id';
				$field = $this->input->get('field');
			break;
			case'firstname';
				$field = $this->input->get('field');
			break;
			case'middlename';
				$field = $this->input->get('field');
			break;
			case'lastname';
				$field = $this->input->get('field');
			break;
			case'nickname';
				$field = $this->input->get('field');
			break;
			case'email';
				$field = $this->input->get('field');
			break;
			case'password';
				$field = $this->input->get('field');
			break;
			case'avatar';
				$field = $this->input->get('field');
			break;
			case'address';
				$field = $this->input->get('field');
			break;
			case'city';
				$field = $this->input->get('field');
			break;
			case'state';
				$field = $this->input->get('field');
			break;
			case'zipcode';
				$field = $this->input->get('field');
			break;
			case'member_status';
				$field = $this->input->get('field');
			break;
			case'member_updated';
				$field = $this->input->get('field');
			break;
			case'member_entered';
				$field = $this->input->get('field');
			break;
			default:
				$field = 'member_id';
		}
	
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_member');
		$this->db->where('1');
		
		if($q){
			$this->db->like('firstname', $q);
			$this->db->or_like('article_description', $q);
			$this->db->or_like('middlename', $q);
			$this->db->or_like('lastname', $q);
			$this->db->or_like('nickname', $q);
			$this->db->or_like('email', $q);
			$this->db->or_like('address', $q);
			$this->db->or_like('city', $q);
			$this->db->or_like('state', $q);
			$this->db->or_like('zipcode', $q);
			$this->db->or_like('country', $q);
			
		}
		$this->db->order_by($field, $sort);
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		
	}

	function check_member($email){

		$this->db->from('cms_member');
		$this->db->where('email', $email);
		
		if($this->db->count_all_results() > 0){
			return false;
		}else{
			return true;
		}
		
		return $this->db->count_all_results();
		
	}
	
	function check_member_email_password($email, $password)
	{
		$this->db->where('email', $email);
		//$this->db->where('password', $password);
		$query = $this->db->get('cms_member');
		
		if ($query->num_rows() != 1) return false;

        $row = $query->row();
        if (!password_verify($password, $row->password)) return false;
        
		return $query->result();
	}
	
	function check_email($email)
	{
		$this->db->where('email', $email);
		$query = $this->db->get('cms_member');
		return $query->result();
	}
	
	function get_md5_email($code)
	{
		$this->db->select('*');
		$this->db->from('cms_member');
		$this->db->where('MD5(email)', $code);
		
		$query = $this->db->get();
		return $query->result();
		
	}

	function get_md5_email_id($email, $id)
	{
		$this->db->select('*');
		$this->db->from('cms_member');
		$this->db->where('MD5(email)', $code);
		$this->db->where('MD5(member_id)', $id);
		
		$query = $this->db->get();
		return $query->result();
	}

	function get_last_login($member_id)
	{
		$member_id = $this->db->escape($member_id);
		
		$table = 'session_website_'.date('Y');
		
		$this->db->select('*');
		$this->db->from($table);
		$this->db->where('member_id', $member_id);
		$this->db->order_by('id', 'DESC');
		$this->db->limit( 10, 0 );
		
		$query = $this->db->get();
		
		return  $query->result();
	}
	
	function get_by_contact($name)
	{
		$name = $this->db->escape($name);
		
		$this->db->select('*');
		$this->db->from('cms_member');
		$this->db->where('concat(firstname,lastname)', $name);
		
		$query = $this->db->get();
		return $query->result();
	}
	
	function addview($member_id)
	{
		$this->db->set('profile_view', 'profile_view+1', FALSE);
		$this->db->where('member_id',$member_id);
		$this->db->update('cms_member');
		
	}
	
	function get_count_member()
	{
		$sql = "SELECT COUNT(*) AS num ";
		$sql .= "FROM cms_member ";
		$query = $this->db->query($sql);
		$rs = $query->result();
		return $rs[0]->num;
	}
 	
 	public function insertToken($user_id)
    {   
    	//check to see if the tokens table exist
		if (!$this->db->table_exists('tokens') ) {
			$this->update_tokens_table();
		}
    
        $token = substr(sha1(rand()), 0, 30); 
        $date = date('Y-m-d');
        
        $string = array(
                'token'=> $token,
                'user_id'=>$user_id,
                'created'=>$date
            );
        $query = $this->db->insert_string('tokens',$string);
        $this->db->query($query);
        return $token . $user_id;
    }
    
     public function isTokenValid($token)
    {
       $tkn = substr($token,0,30);
       $uid = substr($token,30);      
       
        $q = $this->db->get_where('tokens', array(
            'tokens.token' => $tkn, 
            'tokens.user_id' => $uid), 1);                         
               
        if($this->db->affected_rows() > 0){
            $row = $q->row();             
            
            $created = $row->created;
            $createdTS = strtotime($created);
            $today = date('Y-m-d'); 
            $todayTS = strtotime($today);
            
            if($createdTS != $todayTS){
                return false;
            }
            
            $user_info = $this->get_id($row->user_id);
            return $user_info;
            
        }else{
            return false;
        }
        
    }  
    
    public function update_tokens_table() {
    
		$SQL = 'CREATE TABLE IF NOT EXISTS `tokens` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `token` varchar(100) NOT NULL,
		  `user_id` varchar(50) NOT NULL,
		  `created` date NOT NULL,
		  PRIMARY KEY (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;';
    
    	$query = $this->db->query($SQL);
    
    }
    
    public function updatePassword($post)
    {   
        $this->db->where('member_id', $post['user_id']);
        $this->db->update('cms_member', array('password' => $post['password'])); 
        $success = $this->db->affected_rows(); 
        
        if(!$success){
            error_log('Unable to updatePassword('.$post['user_id'].')');
            return false;
        }        
        return true;
    } 

    
    
}