<?php

class Payment extends CI_Model{

	function get_setting()
	{
	
		switch($this->input->get('field'))
		{
			case'type';
				$field = $this->input->get('field');
			break;
			case'detail';
				$field = $this->input->get('field');
			break;
			case'updated';			
				$field = $this->input->get('field');
			break;
			default:
				$field = 'id';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->order_by($field, $sort);
		$query = $this->db->get('cms_payment_setting');
		return $query->result();
	
	}
	
	function get_setting_arr()
	{
		$arr = array();
		$query = $this->db->get('cms_payment_setting');
		
		$rs = $query->result();
		foreach($rs as $index=>$value){
			$arr[$value->type] = $value;
		}
		
		return $arr;	
	}
	
	function get_setting_id($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('cms_payment_setting');
		return $query->result();
	}
	
	function setting_insert($arr)
	{
		$this->db->insert('cms_payment_setting', $arr);
		return $this->db->insert_id();
	}
	
	function setting_update($id, $arr)
	{
	
		$this->db->where('id', $id);
		$this->db->update('cms_payment_setting', $arr);
	}
	
	function get_setting_type($type)
	{
		$this->db->where('type', $type);
		$query = $this->db->get('cms_payment_setting');
		return $query->result();
	}
	
	function get_type(){
		$this->db->group_by('type');
		$query = $this->db->get('cms_payment_setting');
		return $query->result();		
	}
	
	
	function get()
	{
		$q = $this->input->get('q');
		
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		$limit = 20;
		$start = $page * $limit - $limit;
		
		switch($this->input->get('field')){
			case'id';
				$field = $this->input->get('field');
			break;
			case'code';
				$field = $this->input->get('field');
			break;
			case'customer';
				$field = $this->input->get('field');
			break;
			case'customer_email';
				$field = $this->input->get('field');
			break;
			case'cost';
				$field = $this->input->get('field');
			break;
			case'tax';
				$field = $this->input->get('field');
			break;
			case'delivery';
				$field = $this->input->get('field');
			break;
			case'total';
				$field = $this->input->get('field');
			break;
			case'payment_type';
				$field = $this->input->get('field');
			break;
			case'payment_status';
				$field = $this->input->get('field');
			break;
			case'payment_entered';
				$field = $this->input->get('field');
			break;
			default:
				$field = 'id';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_payment');
		$this->db->where('1');
		
		if($q){
			$this->db->like('customer', $q);
			$this->db->or_like('id', $q);
			$this->db->or_like('customer_email', $q);
		}
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		
		
	}
	
	function get_id($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('cms_payment');
		return $query->result();
	}
	
	function insert($arr)
	{
		$this->db->insert('cms_payment', $arr);
		return $this->db->insert_id();
	}
	
	function update($id, $arr)
	{
		$this->db->where('id', $id);
		$this->db->update('cms_payment', $arr);
	}
	
	function get_sum_payment()
	{
		
		$sql = "SELECT ";
		$sql .= "SUM(total) AS sum_total ";
		$sql .= "FROM cms_payment ";
		$query = $this->db->query($sql);
		$rs = $query->result();
		
		return $rs[0]->sum_total;
	}
	
	
	function get_payment_by_member($member_id, $id)
	{
		
		$this->db->select('*');
		$this->db->from('cms_payment');
		$this->db->where('member_id', $member_id);
		$this->db->where('payment_status', 'Completed');
		$this->db->where('id', $id);
		$query = $this->db->get();

		return $query->result(); 
	}
	
	function get_payment_by_email($customer_email)
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		
		$limit = 10;
		$start = $page * $limit - $limit;
		
		switch($this->input->get('field')){
			case'id';
				$field = $this->input->get('field');
			break;
			case'code';
				$field = $this->input->get('field');
			break;
			case'customer';
				$field = $this->input->get('field');
			break;
			case'customer_delivery';
				$field = $this->input->get('field');
			break;
			case'customer_email';
				$field = $this->input->get('field');
			break;
			case'item';
				$field = $this->input->get('field');
			break;
			case'cost';
				$field = $this->input->get('field');
			break;
			case'tax';
				$field = $this->input->get('field');
			break;
			case'delivery';
				$field = $this->input->get('field');
			break;
			case'total';
				$field = $this->input->get('field');
			break;
			case'payment_type';
				$field = $this->input->get('field');
			break;
			case'payment_status';
				$field = $this->input->get('field');
			break;
			case'payment_entered';
				$field = $this->input->get('field');
			break;
			default:
				$field = 'id';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_payment');
		$this->db->where('customer_email', $customer_email);
		$this->db->where('payment_status', 'Completed');
		$this->db->order_by($field, $sort);
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;

	}
	
	function get_payment_by_member_id($member_id)
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		
		$limit = 10;
		$start = $page * $limit - $limit;
		
		switch($this->input->get('field')){
			case'id';
				$field = $this->input->get('field');
			break;
			case'code';
				$field = $this->input->get('field');
			break;
			case'customer';
				$field = $this->input->get('field');
			break;
			case'customer_delivery';
				$field = $this->input->get('field');
			break;
			case'customer_email';
				$field = $this->input->get('field');
			break;
			case'item';
				$field = $this->input->get('field');
			break;
			case'cost';
				$field = $this->input->get('field');
			break;
			case'tax';
				$field = $this->input->get('field');
			break;
			case'delivery';
				$field = $this->input->get('field');
			break;
			case'total';
				$field = $this->input->get('field');
			break;
			case'payment_type';
				$field = $this->input->get('field');
			break;
			case'payment_status';
				$field = $this->input->get('field');
			break;
			case'payment_entered';
				$field = $this->input->get('field');
			break;
			default:
				$field = 'id';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_payment');
		$this->db->where('member_id', $member_id);
		$this->db->order_by($field, $sort);
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;

	}
	
	function get_all_downloads_from_payment($id){
	
		$payment = $this->db->get_where('cms_payment', array('id' => $id))->row_array();
		$downloads = array();
		
		if($payment) {
		
			//loop through all products in the payment and get the downloads
			$items = json_decode($payment['item'], true);
			
			if(!empty($items) && is_array($items)) {
			
				foreach($items as $item) {
				
					$product_id = $item['id'];
					$download = $this->db->get_where('cms_product_download', array('product_id' => $product_id))->result_array();
					
					if($download) {
						//add these to my list
						$downloads = array_merge($download, $downloads);
					}
				}
			}
		
		}
		
		return $downloads;
		
		
	
	}
}