<?php

class Plan extends CI_Model{

	function insert($arr)
	{
		$this->db->insert('cms_plan', $arr);
		return $this->db->insert_id();
	}
	
	function update($id, $arr)
	{
		$this->db->where('id', $id);
		$this->db->update('cms_plan', $arr);
	}
	
	function delete($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('cms_plan');
	}
	
	function get_id($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('cms_plan');
		return $query->result();
	}

	function get_ids($ids)
	{
		$this->db->where_in('id', $ids);
		$query = $this->db->get('cms_plan');
		return $query->result();
	}
	
	function get()
	{
		switch($this->input->get('field')){
			case'id':
				$field = $this->input->get('field');
				break;
			case'name':
				$field = $this->input->get('field');
				break;
			case'price':
				$field = $this->input->get('field');
				break;
			case'currency':
				$field = $this->input->get('field');
				break;
			case'interval_count':
				$field = $this->input->get('field');
				break;
			case'interval':
				$field = $this->input->get('field');
				break;
			case'trial_period':
				$field = $this->input->get('field');
				break;
			case'updated':
				$field = $this->input->get('field');
				break;
			case'entered':
				$field = $this->input->get('field');
				break;
			default:
				$field = 'id';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_plan');
		$this->db->where('1');
		$this->db->order_by($field, $sort);
		$query = $this->db->get();
		
		return $query->result();
	}

	function insert_billing_plan($arr)
	{
		$this->db->insert('cms_billing_plan', $arr);
		return $this->db->insert_id();
	}

	function update_billing_plan($id_plan, $arr)
	{
		$this->db->where('id', $id_plan);
		$this->db->update('cms_billing_plan', $arr);
	}

	function delete_billing_plans($id_plan)
	{
		$this->db->where('id_plan', $id_plan);
		$this->db->delete('cms_billing_plan');
	}

	function delete_billing_plan($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('cms_billing_plan');
	}

	function get_billing_plans($id_plan)
	{
		$this->db->select('cms_plan.*, cms_billing_plan.*');
		$this->db->from('cms_billing_plan');
		$this->db->join('cms_plan', "cms_plan.id = cms_billing_plan.id_plan");
		$this->db->where('id_plan', $id_plan);
		

		return $this->db->get()->result();
	}

	function get_billing_plan($id, $type='')
	{
		$this->db->select('cms_plan.*, cms_billing_plan.*');
		$this->db->from('cms_billing_plan');
		if($type){
			$this->db->where('type', $type);
		}
		$this->db->where('id_plan', $id);
		$this->db->join('cms_plan', "cms_plan.id = cms_billing_plan.id_plan");

		return $this->db->get()->result();
	}

	function get_billing_plan_by_id($id)
	{
		$this->db->select('cms_plan.*, cms_billing_plan.*');
		$this->db->from('cms_billing_plan');
		$this->db->where('cms_billing_plan.id', $id);
		$this->db->join('cms_plan', "cms_plan.id = cms_billing_plan.id_plan");

		return $this->db->get()->result();
	}
}