<?php

class Product extends CI_Model{

	function insert($arr)
	{
		$this->db->insert('cms_product', $arr);
		return $this->db->insert_id();
	}
	
	function update($product_id, $arr)
	{
		$this->db->where('product_id', $product_id);
		$this->db->update('cms_product', $arr);
	}
	
	function delete($product_id)
	{
		$this->db->where('product_id', $product_id);
		$this->db->delete('cms_product');
	}
	
	function get()
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		
		$product_status = $this->input->get('product_status');
		$category_id = $this->input->get('category_id');
		
		$q = $this->input->get('q');
		$limit = 20;
		$start = $page * $limit - $limit;
		
		switch($this->input->get('field'))
		{
			case'product_id';
				$field = $this->input->get('field');
			break;
			case'product_code';
				$field = $this->input->get('field');
			break;
			case'product_name';
				$field = $this->input->get('field');
			break;
			case'product_description';
				$field = $this->input->get('field');
			break;
			case'product_overview';
				$field = $this->input->get('field');
			break;
			case'product_ specifications';
				$field = $this->input->get('field');
			break;
			case'product_weight';
				$field = $this->input->get('field');
			break;
			case'product_minorder';
				$field = $this->input->get('field');
			break;
			case'product_type';
				$field = $this->input->get('field');
				break;
			case'product_price';
				$field = $this->input->get('field');
			break;
			case'product_currency';
				$field = $this->input->get('field');
			break;
			case'product_status';
				$field = $this->input->get('field');
			break;
			case'product_updated';
				$field = $this->input->get('field');
			break;
			default:
				$field = 'product_id';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_product');
		$this->db->where('1');
		
		if($q){
			$this->db->like('product_code', $q);
			$this->db->or_like('product_name', $q);
			$this->db->or_like('product_description', $q);
			$this->db->or_like('product_overview', $q);
			$this->db->or_like('product_specifications', $q);
		}
		if($category_id){
			$this->db->where('category_id', $category_id);
		}
		if($product_status == '0'){
			$this->db->where('product_status', '0');
		}else if($product_status == '1'){
			$this->db->where('product_status', '1');	
		}
		
		$this->db->order_by($field, $sort);
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
		
		
		return $data;
		
	}
	
	function get_id($product_id)
	{
		$this->db->where('product_id', $product_id);
		$query = $this->db->get('cms_product');
		
		$product = $query->result();
		
		//process the product and get a price for it.
		if($product[0]->product_payment_type == 'subscription') {
			
			//get the plans for the product
			$plan = $this->db->get_where('cms_product_plan', array('id_product' => $product[0]->product_id))->row_array();
			
			if($plan) {
			
				$plan_details = $this->db->get_where('cms_plan', array('id' => $plan['id_plan']))->row_array();
				if($plan_details) {
					
					$product[0]->product_price = $plan_details['price'] . " /" . $plan_details['interval'];
					
				}
			
			}
			
		
		}
		
		return $product;
	}

	function gallery_insert($arr)
	{
		$this->db->insert('cms_product_gallery', $arr);
		return $this->db->insert_id();
	}
	
	function gallery_get($product_id)
	{
		//insty - add thumbnail to the gallery list.
		
		$this->db->where('product_id', $product_id);
		$query = $this->db->get('cms_product_gallery');
		$gallery =  $query->result();
		
		$product = $this->db->get_where('cms_product' , array('product_id'=> $product_id))->row_array();
		if($product) {
		
			$thumb = array();
			$thumb['id'] = "";
			$thumb['product_id'] = "";
			$thumb['upload_id'] = $product['thumbnail'];
			$thumb['entered']  = "";
			
			$temp = (array)$gallery;
			array_unshift( $temp, (object)$thumb );
			
			
		}


		return $temp;
	}
	
	function get_related($product_id, $category_id)
	{
		$this->db->select('*');
		$this->db->from('cms_product');
		$this->db->where('1');
		$this->db->where('category_id', $category_id);
		$this->db->where('product_id !=', $product_id);
		$this->db->order_by('product_id', 'DESC');
		$this->db->limit(4 , 0 );
		
		$query = $this->db->get();

		return $query->result();
	}
	
	
	function get_product($product_id, $lang, $property){
	
		$lang = $this->db->escape($lang);
		$product_id = $this->db->escape($product_id);
		
		if($lang == $property[0]->lang){
			
			$this->db->select('*');
			$this->db->from('cms_product');
			$this->db->where('1');
			$this->db->where('product_id', $product_id);
		
		}else{
			
			$this->db->select('cms_product.product_name,cms_product.product_id AS product_id, cms_product.category_id, product_minorder, product_price, product_price_cross, product_currency, product_availability');
			$this->db->select('thumbnail,description AS product_description,overview AS product_overview,specifications AS product_specifications');
			$this->db->from('cms_product');
			$this->db->join('cms_product_lang_'.$lang, 'cms_product.product_id = cms_product_lang_'.$lang.'.product_id');
			$this->db->where('1');
			$this->db->where('cms_product.product_id', $product_id);
	
		}
		
		$query = $this->db->get();
		return $query->result();
		
	}
	
	function insert_featured($arr)
	{
		$this->db->insert('cms_product_featured',$arr);
		return $this->db->insert_id();
	}
	
	function update_featured($id, $arr)
	{
		$this->db->where('id', $id);
		$this->db->update('cms_product_featured', $arr);
	}
	
	function delete_featured($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('cms_product_featured');
	}
	
	function get_featured_id($id)
	{
		$this->db->where('id',$id);
		$query = $this->db->get('cms_product_featured');
		return $query->result();
	}
	
	function featured($type, $limit){

		$this->db->select('*');
		$this->db->from('cms_product_featured');
		$this->db->join('cms_product', 'cms_product_featured.product_id = cms_product.product_id');
		$this->db->where('cms_product_featured.type', $type);
		$this->db->order_by('cms_product_featured.id', 'DESC');
		$this->db->limit($limit, 0 );
		$query = $this->db->get();
			
		return $query->result();
	}
	
	function get_featured($type)
	{
		$q = $this->input->get('q');
		$page = $this->input->get('page');
		if($page == false){ $page = 1;} 
		
		$limit = 100;
		$start = $page * $limit - $limit;
		
		switch($this->input->get('field'))
		{
			case'id';
				$field = $this->input->get('field');
			break;
			case'type';
				$field = $this->input->get('field');
			break;
			case'meta';
				$field = $this->input->get('field');
			break;
			case'product_id';
				$field = $this->input->get('field');
			break;
			case'entered';
				$field = $this->input->get('field');
			break;
			default:
				$field = 'id';			
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_product_featured');
		$this->db->join('cms_product', 'cms_product_featured.product_id = cms_product.product_id ');
		$this->db->where('cms_product_featured.type', $type);
		
		if($q){
			$this->db->like('cms_product.product_name', $q);
			$this->db->or_like('cms_product.product_code', $q);
			$this->db->or_like('cms_product.product_description', $q);
			$this->db->or_like('cms_product.product_overview', $q);
			$this->db->or_like('cms_product.product_specifications', $q);
		}
		
		$this->db->order_by("cms_product_featured.$field", $sort);
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		
	}
	
	function get_active_list()
	{
		$sql = 'SELECT product_id, product_name ';
		$sql .= 'FROM cms_product ';
		$sql .= 'WHERE product_status = 1 ';
		$sql .= 'ORDER BY product_id DESC ';
		$query = $this->db->query($sql);
		return $query->result();
	}
	
	function insert_lang($lang, $arr)
	{
		
		$table = 'cms_product_lang_'.strtolower($lang);
		$this->db->insert($table, $arr);	
	}
	
	function update_lang($lang, $id, $arr){

		$table = 'cms_product_lang_'.strtolower($lang);
		$this->db->where('id', $id);
		$this->db->update($table, $arr);	
	}

	function delete_lang($lang, $id)
	{

		$table = 'cms_product_lang_'.strtolower($lang);
		$this->db->where('id', $id);
		$this->db->delete($table);
	}
	
	function get_lang($lang, $product_id)
	{

		$table = 'cms_product_lang_'.strtolower($lang);
		$this->db->where('product_id', $product_id);
		$query = $this->db->get($table);
		return $query->result();
	}
	
	function get_category($lang, $property, $category_id)
	{
		$limit = 10;
		$page = $this->input->get('page');
		if($page == false){ $page = 1;}
		$q = $this->input->get('q');
		$start = $page * $limit - $limit;
		
		switch($this->input->get('field')){
			case'product_name';
				$field = $this->input->get('field');
			break;
			case'product_price';
				$field = $this->input->get('field');
			break;
			case'product_id';
				$field = $this->input->get('field');
			break;
			case'product_rating';
				$field = $this->input->get('field');
			break;
			default:
				$field = 'product_id';
		}
		
		if($this->input->get('sort') == 'asc'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$min_price = $this->input->get('min_price');
		$max_price = $this->input->get('max_price');
		
		$this->db->select('product_id, product_name, product_price, product_price_cross, product_rating, product_currency,thumbnail, product_description, product_payment_type');
		$this->db->from('cms_product');
		$this->db->where('product_status', '1');
		
		if($q){
			$this->db->like('product_name', $q);
			$this->db->or_like('product_description', $q);
		}
		if($category_id){
			$this->db->where('category_id', $category_id);
		}
		if($min_price && $max_price){
			$this->db->where('product_price >=', $min_price, false);
			$this->db->where('product_price <=', $max_price, false);
		}
		
		if($field){
			$this->db->order_by($field, $sort);
		}else{
			$this->db->order_by('product_id', "CASE WHEN instr(product_name, '$q') = 0 then 1 else 0 end, instr(product_name, '$q') desc;");
		}
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
		
		$this->insert_subscription_price($data['rows']);
			
		return $data;
		
		
		
	}
	
	function insert_subscription_price(&$rows) {
	
		foreach($rows as $index=>$value) {
		
			if($rows[$index]->product_payment_type == 'subscription') {
						
				//get the plans for the product
				$plan = $this->db->get_where('cms_product_plan', array('id_product' => $rows[$index]->product_id))->row_array();
		
				if($plan) {
					$plan_details = $this->db->get_where('cms_plan', array('id' => $plan['id_plan']))->row_array();
					if($plan_details) {
						$rows[$index]->product_price = $plan_details['price'] . "/" . $plan_details['interval'];
						$rows[$index]->interval = $plan_details['interval'];
					}
				}
			}
			
		}
	
	}
	
	function get_count_product()
	{
		$sql = "SELECT COUNT(*) AS num ";
		$sql .= "FROM cms_product ";
		$query = $this->db->query($sql);
		$rs = $query->result();		
		return $rs[0]->num;
	}
	
	function get_pricerange($category_id)
	{
	
		$q = $this->input->get('q');
		
		$this->db->select('MIN(product_price) AS min_price, MAX(product_price) AS max_price ');
		$this->db->from('cms_product');
		$this->db->where('product_status', '1');

		
		if($q){
			$this->db->like('cms_product.product_name', $q);
			$this->db->or_like('cms_product.product_code', $q);
			$this->db->or_like('cms_product.product_description', $q);
			$this->db->or_like('cms_product.product_overview', $q);
			$this->db->or_like('cms_product.product_specifications', $q);
		}
		if($category_id){
			$this->db->where('category_id', $category_id);
		}
		if($article_status == '0'){
			$this->db->where('article_status', $article_status);
		}else if($article_status == '1'){
			$this->db->where('article_status', $article_status);	
		}
		
		if($field){
			$this->db->order_by($field, $sort);
		}else{
			$this->db->order_by('product_id', 'DESC');
		}
		

		$query = $this->db->get();
		return $query->result();
	}
	
	function count_active_product()
	{
		$sql = "SELECT COUNT(*) AS num FROM cms_product WHERE product_status = 1 ";
		$query = $this->db->query($sql);
		return $query->result();
	}
	
	function count_active_product_category($category_id)
	{
		$this->db->select('COUNT(*) AS num');
		$this->db->from('cms_product');
		$this->db->where('product_status', '1');
		$this->db->where('category_id', $category_id);
		$query = $this->db->get();

		return $query->result();
		
	}

}