<?php

class Product_plan extends CI_Model
{
	function insert($arr)
	{
		$this->db->insert('cms_product_plan', $arr);
		return $this->db->insert_id();
	}

	function update($id, $arr)
	{
		$this->db->where('id', $id);
		$this->db->update('cms_product_plan', $arr);
	}

	function update_by_id_product($id_product, $arr)
	{
		$result = $this->get_result_array_by_id_product($id_product);
		if($result)
		{
			$no_arr = array();
			foreach ($result as $row){
				if(in_array($row['id_plan'], $arr)){
					unset($arr[array_search($row['id_plan'], $arr)]);
				}else{
					$no_arr[] = $row;
				}
			}

			if(count($no_arr)>0){
				foreach ($no_arr as $del){
					$this->delete($del['id']);
				}
			}

			if(count($arr)>0){
				foreach ($arr as $element){
					$this->insert(array('id_product'=>$id_product, 'id_plan'=>$element));
				}
			}
		}
		else
		{
			foreach ($arr as $element){
				$this->insert(array('id_product'=>$id_product, 'id_plan'=>$element));
			}
		}
	}

	function delete($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('cms_product_plan');
	}

	function delete_by_id_product($id_product)
	{
		$this->db->where('id_product', $id_product);
		$this->db->delete('cms_product_plan');
	}

	function get_id($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('cms_product_plan');
		return $query->result();
	}

	function get_by_id_product($id_product)
	{
		$this->db->where('id_product', $id_product);
		$query = $this->db->get('cms_product_plan');
		return $query->result();
	}

	function get_result_array_by_id_product($id_product)
	{
		$this->db->where('id_product', $id_product);
		$query = $this->db->get('cms_product_plan');
		return $query->result_array();
	}

	function get_array_ids_plan_by_id_product($id_product)
	{
		$this->db->where('id_product', $id_product);
		$query = $this->db->get('cms_product_plan');
		$res = $query->result();
		$arr = array();
		if($res){			
			foreach ($res as $row){
				$arr[] = $row->id_plan;
			}
		}
		return $arr;
	}

	function get()
	{
		$sql = "SELECT * ";
		$sql .= "FROM cms_product_plan ";
		$sql .= "WHERE 1 ";
		$query = $this->db->query($sql);
		return $query->result();
	}
}