<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Recurring_payment extends CI_Model
{
	function get()
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		$limit = 20;
		$start = $page * $limit - $limit;

		switch($this->input->get('field')){
			case'id':
				$field = $this->input->get('field');
				break;
			case'id_transaction':
				$field = $this->input->get('field');
				break;
			case'id_subscription':
				$field = $this->input->get('field');
				break;
			case'payment_status':
				$field = $this->input->get('field');
				break;
			case'payment_updated':
				$field = $this->input->get('field');
				break;
			case'payment_entered':
				$field = $this->input->get('field');
				break;
			default:
				$field = 'id';
		}

		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}

		
		$this->db->select('*');
		$this->db->from('cms_recurring_payment');
		$this->db->where('1');
		$this->db->order_by($field, $sort);
		$this->db->limit($limit, $start );
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		
	}

	function get_id($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('cms_recurring_payment');
		return $query->result();
	}

	function get_by_id_subscr($id_subscr)
	{
		$this->db->where('id_subscription', $id_subscr);
		$query = $this->db->get('cms_recurring_payment');
		return $query->result();
	}

	//for Admin Panel
	function get_with_subscr_info()
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		$limit = 20;
		$offset = $page * $limit - $limit;

		switch($this->input->get('field')){
			case'id':
				$field = $this->input->get('field');
				break;
			case'id_transaction':
				$field = $this->input->get('field');
				break;
			case'id_subscription':
				$field = $this->input->get('field');
				break;
			case'payment_status':
				$field = $this->input->get('field');
				break;
			case'payment_updated':
				$field = $this->input->get('field');
				break;
			case'payment_entered':
				$field = $this->input->get('field');
				break;
			//----------------
			case'name':
				$field = $this->input->get('field');
				break;
			case'customer_email':
				$field = $this->input->get('field');
				break;
			case'type':
				$field = $this->input->get('field');
				break;
			default:
				$field = 'id';
		}

		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}

		$this->db->select('cms_recurring_payment.*, cms_subscription.name, cms_subscription.customer_email, cms_subscription.type');
		$this->db->from('cms_recurring_payment');
		$this->db->join('cms_subscription', "cms_recurring_payment.id_subscription = cms_subscription.id", 'left');
		$this->db->where('cms_recurring_payment.id_subscription = cms_subscription.id');
		$this->db->limit($limit, $offset);

		$this->db->order_by($field, $sort);		

		$data['rows'] = $this->db->get()->result();
		//$str = $this->db->last_query();

		$num = $this->db->count_all('cms_recurring_payment');
		$data['pages'] = ceil($num / $limit);

		return $data;
	}
			
	function get_by_id_and_id_subscr($id, $id_subscr)
	{
		$this->db->where('id', $id);
		$this->db->where('id_subscription', $id_subscr);
		$query = $this->db->get('cms_recurring_payment');
		return $query->result();
	}

	function get_transaction($id_transaction)
	{
		$this->db->where("BINARY `id_transaction` = '".$id_transaction."'", '', false);
		$query = $this->db->get('cms_recurring_payment');
		return $query->result();
	}

	function get_transaction_with_subscr_info($id_transaction)
	{
		$this->db->select('cms_subscription.*, cms_recurring_payment.*');
		$this->db->from('cms_recurring_payment');
		$this->db->where('cms_recurring_payment.id', $id_transaction);
		$this->db->join('cms_subscription', "cms_recurring_payment.id_subscription = cms_subscription.id", 'left');
		$query = $this->db->get();
		$res = $query->result();
		//$str = $this->db->last_query();
		return $res;
	}

	function get_transaction_with_subscr_info_by_member($customer_email, $id_transaction)
	{
		$this->db->select('cms_subscription.*, cms_recurring_payment.*');
		$this->db->from('cms_recurring_payment');
		$this->db->where('cms_recurring_payment.id', $id_transaction);
		$this->db->where('cms_subscription.customer_email', $customer_email);
		$this->db->join('cms_subscription', "cms_recurring_payment.id_subscription = cms_subscription.id", 'left');
		$query = $this->db->get();
		$res = $query->result();
		//$str = $this->db->last_query();
		return $res;
	}

	function get_transaction_with_subscr_info_by_id_subscr($id_subscr)
	{
		$this->db->select('cms_recurring_payment.*, cms_subscription.name, cms_subscription.customer_email, cms_subscription.type');
		$this->db->from('cms_recurring_payment');
		$this->db->join('cms_subscription', "cms_recurring_payment.id_subscription = cms_subscription.id", 'left');
		$this->db->where('cms_recurring_payment.id_subscription = cms_subscription.id');
		$this->db->where('cms_subscription.id', $id_subscr);
		$query = $this->db->get();
		$res = $query->result();
		//$str = $this->db->last_query();
		return $res;
	}

	function get_transaction_count_by_id_subscr($id_subscr)
	{
		$this->db->from('cms_recurring_payment');
		$this->db->where('cms_recurring_payment.id_subscription', $id_subscr);
		$num = $this->db->count_all_results();
		//$str = $this->db->last_query();
		return $num;
	}
	
	function insert($arr)
	{
		$this->db->insert('cms_recurring_payment', $arr);
		return $this->db->insert_id();
	}
	
	function update($id, $arr)
	{
		$this->db->where('id', $id);
		$this->db->update('cms_recurring_payment', $arr);
	}

	//---------- for Admin Panel ----------------
	
	function get_with_subscr_info_by_id_subscr($id_subscr)
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		$limit = 20;
		$offset = $page * $limit - $limit;

		switch($this->input->get('field')){
			case'id':
				$field = $this->input->get('field');
				break;
			case'id_transaction':
				$field = $this->input->get('field');
				break;
			case'id_subscription':
				$field = $this->input->get('field');
				break;
			case'payment_status':
				$field = $this->input->get('field');
				break;
			case'payment_updated':
				$field = $this->input->get('field');
				break;
			case'payment_entered':
				$field = $this->input->get('field');
				break;
			//----------------
			case'name':
				$field = $this->input->get('field');
				break;
			case'customer_email':
				$field = $this->input->get('field');
				break;
			case'type':
				$field = $this->input->get('field');
				break;
			default:
				$field = 'id';
		}

		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}

		$this->db->select('cms_recurring_payment.*, cms_subscription.name, cms_subscription.customer_email, cms_subscription.type');
		$this->db->from('cms_recurring_payment');
		$this->db->join('cms_subscription', "cms_recurring_payment.id_subscription = cms_subscription.id", 'left');
		$this->db->where('cms_recurring_payment.id_subscription = cms_subscription.id');
		$this->db->where('cms_subscription.id', $id_subscr);
		$this->db->limit($limit, $offset);

		$this->db->order_by($field, $sort);

		$data['rows'] = $this->db->get()->result();
		//$str = $this->db->last_query();

		$this->db->from('cms_recurring_payment');
		$this->db->join('cms_subscription', "cms_recurring_payment.id_subscription = cms_subscription.id", 'left');
		$this->db->where('cms_recurring_payment.id_subscription = cms_subscription.id');
		$this->db->where('cms_subscription.id', $id_subscr);
		$num =  $this->db->count_all_results();

		$data['pages'] = ceil($num / $limit);

		return $data;
	}

	//---------------------for Client Panel---------------------

	function get_with_subscr_info_by_email_and_id_subscr($customer_email, $id_subscr)
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		$limit = 10;
		$offset = $page * $limit - $limit;

		switch($this->input->get('field')){
			case'id':
				$field = $this->input->get('field');
				break;
			case'id_transaction':
				$field = $this->input->get('field');
				break;
			case'id_subscription':
				$field = $this->input->get('field');
				break;
			case'payment_status':
				$field = $this->input->get('field');
				break;
			case'payment_updated':
				$field = $this->input->get('field');
				break;
			case'payment_entered':
				$field = $this->input->get('field');
				break;
			//----------------
			case'name':
				$field = $this->input->get('field');
				break;
			case'customer_email':
				$field = $this->input->get('field');
				break;
			case'type':
				$field = $this->input->get('field');
				break;
			default:
				$field = 'id';
		}

		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}

		$this->db->select('cms_recurring_payment.*, cms_subscription.name, cms_subscription.customer_email, cms_subscription.type');
		$this->db->from('cms_recurring_payment');
		$this->db->join('cms_subscription', "cms_recurring_payment.id_subscription = cms_subscription.id", 'left');
		$this->db->where('cms_recurring_payment.id_subscription = cms_subscription.id');
		$this->db->where('cms_subscription.id', $id_subscr);
		$this->db->where('cms_subscription.customer_email', $customer_email);
		$this->db->limit($limit, $offset);

		$this->db->order_by($field, $sort);

		$data['rows'] = $this->db->get()->result();
		//$str = $this->db->last_query();

		$this->db->from('cms_recurring_payment');
		$this->db->join('cms_subscription', "cms_recurring_payment.id_subscription = cms_subscription.id", 'left');
		$this->db->where('cms_recurring_payment.id_subscription = cms_subscription.id');
		$this->db->where('cms_subscription.id', $id_subscr);
		$this->db->where('cms_subscription.customer_email', $customer_email);
		$num =  $this->db->count_all_results();

		$data['pages'] = ceil($num / $limit);

		return $data;
	}

	function get_with_subscr_info_by_email($customer_email)
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		$limit = 10;
		$offset = $page * $limit - $limit;

		switch($this->input->get('field')){
			case'id':
				$field = $this->input->get('field');
				break;
			case'id_transaction':
				$field = $this->input->get('field');
				break;
			case'id_subscription':
				$field = $this->input->get('field');
				break;
			case'payment_status':
				$field = $this->input->get('field');
				break;
			case'payment_updated':
				$field = $this->input->get('field');
				break;
			case'payment_entered':
				$field = $this->input->get('field');
				break;
			//----------------
			case'name':
				$field = $this->input->get('field');
				break;
			case'customer_email':
				$field = $this->input->get('field');
				break;
			case'type':
				$field = $this->input->get('field');
				break;
			default:
				$field = 'id';
		}

		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}

		$this->db->select('cms_recurring_payment.*, cms_subscription.name, cms_subscription.customer_email, cms_subscription.type');
		$this->db->from('cms_subscription');
		$this->db->join('cms_recurring_payment', "cms_subscription.id = cms_recurring_payment.id_subscription", 'left');
		$this->db->where('cms_subscription.customer_email', $customer_email);
		$this->db->where('cms_recurring_payment.id_subscription = cms_subscription.id');
		$this->db->limit($limit, $offset);

		$this->db->order_by($field, $sort);

		$data['rows'] = $this->db->get()->result();
		//$str = $this->db->last_query();

		$this->db->from('cms_subscription');
		$this->db->join('cms_recurring_payment', "cms_subscription.id = cms_recurring_payment.id_subscription", 'left');
		$this->db->where('cms_subscription.customer_email', $customer_email);
		$this->db->where('cms_recurring_payment.id_subscription = cms_subscription.id');
		$num =  $this->db->count_all_results();

		$data['pages'] = ceil($num / $limit);

		return $data;
	}
}