<?php

class Sendmail extends CI_Model{

	public function active_member_template()
	{
		return file_get_contents('assets/email/active-member-template.html');
	}

	public function action_template()
	{
		return file_get_contents('assets/email/action-template.html');
	}
	
	public function alert_template(){
		return file_get_contents('assets/email/alert-template.html');
	
	}
	
	public function send_old($to, $from, $subject, $message)
	{
	
		$headers  = 'MIME-Version: 1.0' . "\r\n";
		$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";	
		$headers .= 'From: '.$from."\r\n";
		$headers .= 'To: '.$to."\r\n";
		
		$email_message = $this->action_template();
		$email_message = str_replace(':base_url:', base_url(), $email_message);
		$email_message = str_replace(':subject:', $subject, $email_message);
		$email_message = str_replace(':message:', $message, $email_message);
				
		//@mail('', $subject, $email_message, $headers);
	
	}
	
	public function send($to, $from, $subject, $message)
	{
	
		$property = $this->Property->get();
		
		$to = '"'.$to.'" <'.$to.'>';
		$from = '"'.$property[0]->property_name.'" <'.$property[0]->property_email.'>';
		
		$headers  = 'MIME-Version: 1.0' . "\r\n";
		$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";	
		$headers .= 'Subject: '. $subject . "\r\n";
		$headers .= 'From: '.$from."\r\n";
		$headers .= 'To: '.$to."\r\n";
		
		$email_message = $this->action_template();
		$email_message = str_replace(':base_url:', base_url(), $email_message);
		$email_message = str_replace(':subject:', $subject, $email_message);
		$email_message = str_replace(':message:', $message, $email_message);
		
		$host = $property[0]->property_email_host;
		
		if($property[0]->property_mailer_url == 'engage'){
		    $this->send_engage($to, $subject, $email_message);
		}elseif(strpos($host, 'smtp://') !== false) {
			$this->send_smtp($to, $subject, $email_message);
		} elseif ($host) {
			$this->mail_post($to, $from, $subject, $headers, $email_message);
			exit;
		} else {
			@mail('', $subject, $email_message, $headers);
			exit;
		}
		
	
	}
	
	public function send_email($to, $from, $subject, $email_message)
	{
	
		$property = $this->Property->get();
		
		$to = '"'.$to.'" <'.$to.'>';
		$from = '"'.$property[0]->property_name.'" <'.$property[0]->property_email.'>';
		
		$headers  = 'MIME-Version: 1.0' . "\r\n";
		$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";	
		$headers .= 'Subject: '. $subject . "\r\n";
		$headers .= 'From: '.$from."\r\n";
		$headers .= 'To: '.$to."\r\n";
		
		$host = $property[0]->property_email_host;
		
		if($property[0]->property_mailer_url == 'engage'){
		    $this->send_engage($to, $subject, $email_message);
		}elseif(strpos($host, 'smtp://') !== false) {
			$this->send_smtp($to, $subject, $email_message);
		} elseif ($host) {
			$this->mail_post($to, $from, $subject, $headers, $email_message);
			exit;
		} else {
			@mail('', $subject, $email_message, $headers);
			exit;
		}
		
		
	}
	function send_engage($to, $subject, $email_message) {
	
		$property = $this->Property->get();
		
		$url = 'https://api.elasticemail.com/v2/email/send';
		
		$post = array('from' => $property[0]->property_email,
					  'fromName' => $property[0]->property_name,
					  'apikey' => $property[0]->property_email_key,
					  'subject' => $subject,
					  'bodyHtml' => $email_message,
					  'to' =>  $to,
					  'isTransactional' => false);
     
		
 		$ch = curl_init();
            
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER => false,
            CURLOPT_SSL_VERIFYPEER => false
        ));
        
        $result=curl_exec ($ch);
        curl_close ($ch);
		
		print_r($result);
		die();
				
		//check result and redirect
		if($result) {
			return true;
		} else {
			return false;
		}
		
	
	}
	function send_smtp($to, $subject, $email_message) {
	
		$property = $this->Property->get();
		
		$host = $property[0]->property_email_host;
		$host = str_replace("smtp://","",$host);
		
		$config = array();
		
		$config['protocol'] = 'smtp';
		$config['smtp_host'] = $host; 
		$config['smtp_port'] = '2525';
		$config['smtp_user'] = $property[0]->property_email_key; 
		$config['smtp_pass'] = $property[0]->property_email_secret; 
		$config['smtp_crypto'] = 'tls'; 
		$config['mailtype'] = 'html';
		$config['charset'] = 'iso-8859-1';
		$config['wordwrap'] = TRUE;
		$config['newline'] = "\r\n";

		$this->email->initialize($config);

        $this->email->from($property[0]->property_email, $property[0]->property_name );
        $this->email->to($to); 

        $this->email->subject($subject);
        $this->email->message($email_message);  

        $this->email->send();

        //echo $this->email->print_debugger();
        
		
	}
	function password($to, $from, $subject, $message)
	{
	
		$to = '"'.$to.'" <'.$to.'>';
		$from = '"'.$property[0]->property_name.'" <'.$property[0]->property_email.'>';
		
		$headers  = 'MIME-Version: 1.0' . "\r\n";
		$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";	
		$headers .= 'From: '.$from."\r\n";
		$headers .= 'To: '.$to."\r\n";
		
		$email_message = $this->alert_template();
		$email_message = str_replace(':base_url:', base_url(), $email_message);
		$email_message = str_replace(':subject:', $subject, $email_message);
		$email_message = str_replace(':message:', $message, $email_message);
				
		$host = $property[0]->property_email_host;
		
		if($property[0]->property_mailer_url == 'engage'){
		    $this->send_engage($to, $subject, $email_message);
		}elseif(strpos($host, 'smtp://') !== false) {
			$this->send_smtp($to, $subject, $email_message);
		} elseif ($host) {
			$this->mail_post($to, $from, $subject, $headers, $email_message);
			exit;
		} else {
			@mail('', $subject, $email_message, $headers);
			exit;
		}
	}
	
	
	function activate_member($property, $member)
	{
	
		$to = '"'.$to.'" <'.$to.'>';
		$from = '"'.$property[0]->property_name.'" <'.$property[0]->property_email.'>';
		
		$headers  = 'MIME-Version: 1.0' . "\r\n";
		$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";	
		$headers .= 'From: no-replay@easybranches.com'."\r\n";
		$headers .= 'To: '.$member[0]->email."\r\n";
		
		$email_message = $this->active_member_template();
		$email_message = str_replace(':base_url:', base_url(), $email_message);
		$email_message = str_replace(':firstname:', $member[0]->firstname, $email_message);
		$email_message = str_replace(':lastname:', $member[0]->lastname, $email_message);
		$email_message = str_replace(':code:', md5($member[0]->email), $email_message);
		$email_message = str_replace(':id:', md5($member[0]->member_id), $email_message);

		$subject = $member[0]->firstname.' Please verify your email';
		$host = $property[0]->property_email_host;
		
		if($property[0]->property_mailer_url == 'engage'){
		    $this->send_engage($to, $subject, $email_message);
		}elseif(strpos($host, 'smtp://') !== false) {
			$this->send_smtp($to, $subject, $email_message);
		} elseif ($host) {
			$this->mail_post($to, $from, $subject, $headers, $email_message);
			exit;
		} else {
			@mail('', $subject, $email_message, $headers);
			exit;
		}
	
	}
	
	function mail_post($to, $from, $subject, $headers, $email_message) {
	
		$property = $this->Property->get();
		
		$mime = $headers . "\r\n" . "\r\n" . $email_message;
		
		$mime = base64_encode($mime);
 		$message_data = urlencode($mime);

		date_default_timezone_set('America/Chicago');
		$date = new DateTime();
		$date = $date->format('D, d M Y H:i:s');
		
		$action = urlencode("SendHtmlEmail");
		$member = urlencode( $to );
		$source = urlencode( $from );
		
		$vars = "Action=$action&Destinations.member.1=$member&Source=$source&RawMessage.Data=$message_data";
		
		$algorythm="sha1";

		//create signature
		$ourSig = base64_encode(hash_hmac($algorythm, $date, $property[0]->property_email_secret, true )); 

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL,"https://".$property[0]->property_email_host);

		curl_setopt($ch, CURLOPT_POST, $vars);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $vars);
		curl_setopt($ch, CURLOPT_HEADER, TRUE);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);

		$headers = array();
		$headers[] = 'Date: '.$date;
		$headers[] = 'X-Amzn-Authorization: AWS3-HTTPS AWSAccessKeyId='.$property[0]->property_email_key.',Algorithm=Hmac'.strtoupper($algorythm).',Signature='.$ourSig;
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';

		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$server_output = curl_exec ($ch);
		curl_close ($ch);

		//echo $server_output;
	
	
	}
	
}