<?php

class Shipping extends CI_Model
{
	function get()
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1;}
		$limit = 50;
		$start = $page * $limit - $limit; 
		$country = $this->input->get('country');
		
		switch($this->input->get('field')){
			case'shipping_id';
				$field = $this->input->get('field');
			break;			
			case'country';
				$field = $this->input->get('field');
			break;
			case'weight1';
				$field = $this->input->get('field');
			break;
			case'weight2';
				$field = $this->input->get('field');
			break;
			case'rate';
				$field = $this->input->get('field');
			break;
			case'entered';
				$field = $this->input->get('field');
			break;
			default:
				$field = 'shipping_id';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$start = $page * $limit - $limit;
		
		$this->db->select('*');
		$this->db->from('cms_shipping');
		$this->db->join('cms_country', 'cms_shipping.country = cms_country.code');
		$this->db->where('1');
		$this->db->where('article_status', $article_status);
		
		if($country){
			$this->db->where('country', $country);
		}
		
		if($field){
			$this->db->order_by($field, $sort);
		}else{
			$this->db->order_by('article_id', 'DESC');
		}
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		
	}
	
	function get_id($shipping_id)
	{
		$this->db->where('shipping_id', $shipping_id);
		$query = $this->db->get('cms_shipping');
		return $query->result();
	}
	
	function insert($arr)
	{
		$this->db->query('cms_shipping', $arr);
		return $this->db->insert_id();
	}
	
	function update($shipping_id, $arr)
	{
		$this->db->where('shipping_id', $shipping_id);
		$this->db->update('cms_shipping', $arr);
	}
	
	function delete($shipping_id)
	{
		$this->db->where('shipping_id', $shipping_id);
		$this->db->delete('cms_shipping');
	}
	
	function get_available_country()
	{
		$sql = "SELECT * ";
		$sql .= "FROM cms_shipping, cms_country ";
		$sql .= "WHERE cms_shipping.country = cms_country.code ";
		$sql .= "GROUP BY cms_shipping.country ";
		$query = $this->db->query($sql);
		return $query->result();
	}
		
	function get_cost($country, $weight)
	{
	
		if($weight == 0) {
			return 0;
		}
		
		$this->db->select('*');
		$this->db->from('cms_shipping');
		$this->db->where('country', $country);
		$this->db->where("'$weight' BETWEEN weight1 AND weight2");
		$query = $this->db->get();
		
		$rs = $query->result();
		
		if(isset($rs[0]->rate)){
			return $rs;
		}else{
			
			$this->db->select('*');
			$this->db->from('cms_shipping');
			$this->db->where('country', $country);
			$this->db->where("'$weight' BETWEEN weight1 AND weight2");
			$this->db->order_by('rate', 'DESC');
			$this->db->limit(1, 0 );
			$query = $this->db->get();
			$rs = $query->result();
			return $rs;				
		}
	}
	
	function get_cart_shipping($session_id)
	{
		$this->db->where('session_id', $session_id);
		$query = $this->db->get('cms_cart_shipping');
		return $query->result();
	}
}