<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Subscription extends CI_Model
{
	function get()
	{
		$q = $this->input->get('q');
		
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		$limit = 20;
		$start = $page * $limit - $limit;
		
		switch($this->input->get('field')){
			case'id':
				$field = $this->input->get('field');
				break;
			case'code':
				$field = $this->input->get('field');
				break;
			case'customer':
				$field = $this->input->get('field');
				break;
			case'customer_email':
				$field = $this->input->get('field');
				break;
			case'cost':
				$field = $this->input->get('field');
				break;
			case'tax':
				$field = $this->input->get('field');
				break;
			case'delivery':
				$field = $this->input->get('field');
				break;
			case'total':
				$field = $this->input->get('field');
				break;
			case'type':
				$field = $this->input->get('field');
				break;
			case'name':
				$field = $this->input->get('field');
				break;
			case'price':
				$field = $this->input->get('field');
				break;
			case'currency_subscr':
				$field = $this->input->get('field');
				break;
			case'interval':
				$field = $this->input->get('field');
				break;
			case'interval_count':
				$field = $this->input->get('field');
				break;
			case'trial_period':
				$field = $this->input->get('field');
				break;
			case'status':
				$field = $this->input->get('field');
				break;
			case'entered':
				$field = $this->input->get('field');
				break;
			default:
				$field = 'id';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_subscription');
		$this->db->where('1');
		
		if($q){
			$this->db->like('customer', $q);
			$this->db->or_like('id', $q);
			$this->db->or_like('customer_email', $q);
		}
		
		$this->db->order_by($field, $sort);

		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		

	}
	
	function get_id($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('cms_subscription');
		return $query->result();
	}

	function get_by_id_and_id_subscr($id, $id_subscr)
	{
		$this->db->where('id', $id);
		$this->db->where("BINARY `id_subscription` = '".$id_subscr."'", '', false);
		$query = $this->db->get('cms_subscription');
		return $query->result();
	}

	function get_by_id_subscr($id_subscr)
	{
		$this->db->where("BINARY `id_subscription` = '".$id_subscr."'", '', false);
		$query = $this->db->get('cms_subscription');
		//$str = $this->db->last_query();
		return $query->result();
	}
	
	function insert($arr)
	{
		$this->db->insert('cms_subscription', $arr);
		return $this->db->insert_id();
	}
	
	function update($id, $arr)
	{
		$this->db->where('id', $id);
		$this->db->update('cms_subscription', $arr);
	}

	function update_by_id_subscr($id_subscription, $arr)
	{
		$this->db->where("BINARY `id_subscription` = '".$id_subscription."'", '', false);
		$this->db->update('cms_subscription', $arr);
	}

	function delete($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('cms_subscription');
	}

	function get_sum_payment()
	{
		$sql = "SELECT ";
		$sql .= "SUM(total) AS sum_total ";
		$sql .= "FROM cms_subscription ";
		$query = $this->db->query($sql);
		$rs = $query->result();
		
		return $rs[0]->sum_total;
	}

	function get_by_id_and_member_id($id, $member_id)
	{
		$this->db->select('*');
		$this->db->from('cms_subscription');
		$this->db->where('id', $id);
		$this->db->where('member_id', $member_id);
		$query = $this->db->get();
		return $query->result();
	}

	//-------------------for Client Panel-------------------------------
	
	function get_subscription_by_member($customer_email, $id)
	{
		$this->db->select('*');
		$this->db->from('cms_subscription');
		$this->db->where('id', $id);
		$this->db->where('customer_email', $customer_email);
		$query = $this->db->get();
		return $query->result(); 
	}

	function get_subscription_by_email($customer_email)
	{
		$page = $this->input->get('page');
		if($page == false){ $page = 1; }
		
		$limit = 10;
		$start = $page * $limit - $limit;
		
		switch($this->input->get('field')){
			case'id':
				$field = $this->input->get('field');
				break;
			case'code':
				$field = $this->input->get('field');
				break;
			case'customer':
				$field = $this->input->get('field');
				break;
			case'customer_delivery':
				$field = $this->input->get('field');
				break;
			case'customer_email':
				$field = $this->input->get('field');
				break;
			case'item':
				$field = $this->input->get('field');
				break;
			case'cost':
				$field = $this->input->get('field');
				break;
			case'tax':
				$field = $this->input->get('field');
				break;
			case'delivery':
				$field = $this->input->get('field');
				break;
			case'total':
				$field = $this->input->get('field');
				break;
			case'type':
				$field = $this->input->get('field');
				break;
			case'name':
				$field = $this->input->get('field');
				break;
			case'price':
				$field = $this->input->get('field');
				break;
			case'currency_subscr':
				$field = $this->input->get('field');
				break;
			case'interval':
				$field = $this->input->get('field');
				break;
			case'interval_count':
				$field = $this->input->get('field');
				break;
			case'trial_period':
				$field = $this->input->get('field');
				break;
			case'status':
				$field = $this->input->get('field');
				break;
			case'entered':
				$field = $this->input->get('field');
				break;
			default:
				$field = 'id';
		}
		
		if($this->input->get('sort') == 'ASC'){
			$sort = 'ASC';
		}else{
			$sort = 'DESC';
		}
		
		$this->db->select('*');
		$this->db->from('cms_subscription');
		$this->db->where('customer_email', $customer_email);
		$this->db->order_by($field, $sort);
		
		
		//count results
		$tempdb = clone $this->db;
		$results = $tempdb->count_all_results();
		$data['pages'] = ceil($results/$limit);
		
		$this->db->limit($limit, $start );
		$query = $this->db->get();
		$data['rows'] = $query->result();
			
		return $data;
		

	}
}