<?php include('tpl.meta.php'); ?>
<?php include('tpl.header.php');?>
  <section class="container padding-top-3x padding-bottom-3x">
      <div class="row">
          <div class="col-md-8">
              <h1>Subscription #<?php echo $subscription[0]->id_subscription; ?></h1>
          </div>
          <div class="col-md-4 unsubscribe">
              <?php
              $two_days = 60*60*24*2;
              $time_expired = (strtotime($subscription[0]->entered)+$two_days) <= time();

              if($subscription[0]->canceled == DATE_TIME_EMPTY
                  && ucfirst($subscription[0]->status) == STATUS_ACTIVE && $subscription[0]->type == PAYMENT_TYPE_STRIPE)
              {
                  echo '<a class="unsubscribe" href="'.base_url().$sess[0]->lang.'/account/subscription/unsubscribe?id='.$subscription[0]->id.'"><img src="https://www.paypalobjects.com/webstatic/en_US/i/btn/png/btn_unsubscribe_113x26.png" alt="Unsubscribe"></a>';
              } elseif($subscription[0]->canceled == DATE_TIME_EMPTY
                  && ucfirst($subscription[0]->status) == STATUS_ACTIVE && $subscription[0]->type == PAYMENT_TYPE_PAYPAL)
            	{
            		$paypal_url = PAYPAL_URL_WEBSCR;
            		echo '<a class="btn btn-info" href="'.$paypal_url.'/cgi-bin/webscr?cmd=_profile-recurring-payments&encrypted_profile_id='.$subscription[0]->id_subscription.'" target="_blank">Manage this subscription in PayPal</a>';
            	}
              ?>
          </div>
      </div>
      <?php if(!empty($unsubscribe)){?>
          <div class="row" id="unsubscribe-alert">
              <div class="alert alert-success alert-dismissible" role="alert">
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close" onClick="$('#unsubscribe-alert').hide();"><span aria-hidden="true">&times;</span></button>
                  Your cancellation request is being processed.  You will receive an email with a cancellation confirmation.</div>
          </div>
      <?php }?>
    <div class="row padding-top">
      <div class="col-md-12">
        <p><strong><?php echo $this->lang->line('Customer information');?></strong></p>
        <?php 
            $customer = json_decode($subscription[0]->customer, true);
            $country = $this->Country->get_code($customer['country']);
            $items = json_decode($subscription[0]->item,true);

            echo '<p>';
            echo $customer['firstname'] . ' '.$customer['lastname'].'<br>';
            echo '<strong>'.$this->lang->line('Address').'</strong>: ' . $customer['address'] . ' '.$customer['city'] . ' ';
            echo $customer['state'] . ' '. $customer['zipcode']. ' '.$country[0]->name. '<br>';
            echo '<strong>'.$this->lang->line('Phone').'</strong>: '.$customer['phone']. ' ';
            echo '<strong>'.$this->lang->line('Fax').'</strong>: '.$customer['fax'] . ' ';
            echo '<strong>'.$this->lang->line('Email').'</strong>: <a href="mailto:'.$subscription[0]->customer_email.'">'.$subscription[0]->customer_email.'</a>';
            echo '</p>';
            echo '<br>';
        ?>
        <p><strong><?php echo $this->lang->line('Subscription Information');?></strong></p>
        	<?php echo $this->Email->subscription_info_summary($subscription ); ?>
      </div>
	<div class="col-md-12">
		<h3>Subscription Transaction Log:</h3>
	</div>
      <div class="col-md-12">
          <br>
          <div class="row">
              <div class="col-md-6">
                  <p><strong>Created Info</strong>:</p>
                  <?php
                  $subscription_detail = json_decode($subscription[0]->signup_detail,true);
                  if(is_array($subscription_detail)){
                      echo '<table class="table table-striped">';
                      foreach($subscription_detail as $index=>$value){
                          echo '<tr>';
                          echo '<td>'.$index.'</td>';
                          echo '<td class="word-break-all">'.$value.'</td>';
                          echo '</tr>';
                      }
                      echo '</table>';
                  }else{
                      echo '<table class="table">';
                      echo '<tr><td> --- </td></tr>';
                      echo '</table>';
                  }
                  ?>
              </div>
              <div class="col-md-6">
                  <p><strong>Canceled Info</strong>:</p>
                  <?php
                  $subscription_detail = json_decode($subscription[0]->cancel_detail,true);
                  if(is_array($subscription_detail)){
                      echo '<table class="table table-striped">';
                      foreach($subscription_detail as $index=>$value){
                          echo '<tr>';
                          echo '<td>'.$index.'</td>';
                          echo '<td class="word-break-all">'.$value.'</td>';
                          echo '</tr>';
                      }
                      echo '</table>';
                  }else{
                      echo '<table class="table">';
                      echo '<tr><td> --- </td></tr>';
                      echo '</table>';
                  }
                  ?>
              </div>
          </div>
      </div>
    </div>
  </section>
<?php include('tpl.video.php');?>
<?php include('tpl.footer.php'); ?>