<?php include('tpl.meta.php');?>
<?php include('tpl.header.php');?>

	<link href="<?php echo base_url();?>assets/frontend/css/stripe.css" rel="stylesheet" media="screen">
    <script type="text/javascript" src="https://js.stripe.com/v2/"></script>
    <script type="text/javascript" src="<?php echo base_url();?>assets/frontend/js/jquery.validate.min.js"></script>
    <script src="<?php echo base_url();?>assets/frontend/js/stripe.js"></script>
    <script type="text/javascript">
        // this identifies your website in the createToken call below
        Stripe.setPublishableKey('<?php echo $stripe_public_key; ?>');

        function stripeResponseHandler(status, response) {
            if (response.error) {
                // re-enable the submit button
                //$('.submit-button').removeAttr("disabled");
                // show hidden div
                document.getElementById('a_x200').style.display = 'block';
                // show the errors on the form
                $(".payment-errors").html('<div class="alert alert-danger">'+response.error.message+'</div>');
                $('input.process-checkout').prop('disabled', false);
                $('.page-preloading.loading-done .page-preloader').css({'visibility':'hidden', 'opacity':0});
            } else {
                var form$ = $("#payment-form");
                // token contains id, last4, and card type
                var token = response['id'];
                // insert the token into the form so it gets submitted to the server
                form$.append("<input type='hidden' name='stripeToken' value='" + token + "' />");
                form$.append("<input type='hidden' name='save' value='<?php echo $this->lang->line('Process Checkout');?>' />");
                // and submit
                //form$.get(0).submit();

                $.ajax({
                    type: "POST",
                    url: $("#payment-form").attr('action'),
                    dataType: 'json',
                    data: form$.serialize(),
                    success: function (res) {
                        if(res.status == 'succeeded' || res.status == 'pending'){
                            $('<form action="'+res.url+'" id="tmp-form" method="post"></form>').appendTo('body');
                            $('#tmp-form').append("<input type='hidden' name='invoice_id' value='" + res.id + "' />").submit();
                        }
                        else if(res.error)
                        {
                            document.getElementById('a_x200').style.display = 'block';
                            $(".payment-errors").html(res.error);
                        }
                        else
                        {
                            document.getElementById('a_x200').style.display = 'block';
                            $(".payment-errors").html('<div class="alert alert-danger"><strong>Invoice: </strong>'+res.id+'<br/>'
                                +'<strong>Status: </strong>'+res.status+'<br/>'+res.code+'<br/>'+res.msg+'</div>');
                        }
                        $('.page-preloading.loading-done .page-preloader').css({'visibility':'hidden', 'opacity':0});
                        $('input.process-checkout').prop('disabled', false);
                    },
                    error: function (res) {
                        document.getElementById('a_x200').style.display = 'block';
                        $(".payment-errors").html(res.responseText);
                        $('input.process-checkout').prop('disabled', false);
                        $('.page-preloading.loading-done .page-preloader').css({'visibility':'hidden', 'opacity':0});
                    }
                });
            }
        }
    </script>

<style>
.m-b{
	margin-bottom: 10px;
}
</style>

</head>

<!-- Body -->
<body class="">

<!-- Page Wrapper -->
<div class="page-wrapper">

<!-- Content -->
<section class="container padding-top-3x padding-bottom-3x">
  <h1><?php echo $this->lang->line('Check Out');?></h1>
  <p><?php echo $this->lang->line('Please fill in the form below to complete checkout process');?></p>
  
  <div class="row ">
    <div class="col-md-3">
      <p><strong><?php echo $this->lang->line('Cart summary');?></strong></p>
      <hr>
      <?php
          foreach($cart as $index=>$value){
						
						$url = base_url().$sess[0]->lang."/products/".sprintf('%05d', $cart[$index]->product_id);
						$options = json_decode($value->options, true);
						
						echo '<div class="row m-b">';
						echo '<div class="col-xs-4 text-center">';
						echo '<a href="'. $url.'"> ';
						echo '<img src="'.base_url().'slide/'.$value->thumbnail.'/450x450" class="img-responsive">';
						echo '</a>';
						echo '<a href="javascript:void()" class="checkout-item-remove" style="font-size: 11px;" data-cart-id="'.$value->cart_id.'">remove</a>';
						echo '</div>';
						echo '<div class="col-xs-8">';
						echo '<a href="'.$url.'">'.$value->product_name.'</a><br>';
						if(count($options)){ 
							echo '<small>';
							if(isset($options['Size'])){ echo $this->lang->line('Size').' : '.$options['Size']; }
							echo ' ';
							if(isset($options['Color'])){ echo $this->lang->line('Color').' : '.$options['Color']; }
							echo '</small>'; 
							echo '<br>';
						}						
						echo $this->lang->line('Quantity').': <span>'.$value->unit .'</span> <br>';
						echo $this->lang->line('Unit Price').': <span class="'.$value->currency.'">'.number_format($value->price,'2','.',','). '</span><br> ';
						echo '<strong>'.$this->lang->line('Total').': <span class="'.$value->currency.'">'.number_format($value->total,'2','.',','). '</span></strong><br> ';
						echo '</div>';
						echo '</div>';
      		}
					
					
					$cart_cost = $sumcart[0]->cart_cost;
					$cart_tax = $sumcart[0]->cart_tax;		
					$cart_total = $sumcart[0]->grand_total;
					$shipping_cost = $shipping[0]->cost;
					$grand = $cart_total + $shipping_cost;
					
					echo '<hr>';				
					echo '<div class="row">';
					echo '<div class="col-xs-12">';
					echo '<ul class="list-unstyled">';
					echo '<li>'.$this->lang->line('Cost').' : <strong><span class="'.$sumcart[0]->currency.'">'.number_format($cart_cost,'2','.',',').'</span></strong></li>';
					if($cart_tax > 0){
						echo '<li>'.$this->lang->line('Tax').' : <strong><span class="'.$sumcart[0]->currency.'">'.number_format($cart_tax,'2','.',',').'</span></strong></li>';
					}
					echo '<li>'.$this->lang->line('Total').' : <strong><span class="'.$sumcart[0]->currency.'">'.number_format($cart_total,'2','.',',').'</span></strong></li>';
					echo '<li>'.$this->lang->line('Shipping Cost').' : <strong><span class="'.$sumcart[0]->currency.'">'.number_format($shipping_cost,'2','.',',').'</span></strong></li>';
					echo '</ul>';
					echo '</div>';
					echo '</div>';
					echo '<hr>';

					echo '<div class="row">';
					echo '<div class="col-xs-12">';
					echo '<ul class="list-unstyled">';
					echo '<li>'.$this->lang->line('Grand Total').' : <strong><span class="'.$sumcart[0]->currency.'">'.number_format($grand,'2','.',',').'</span></strong></li>';
					echo '</ul>';
					echo '</div>';
					echo '</div>';
					
          ?>
    </div>
    <div class="col-md-9">
      <div class="card">
        <?php if($property[0]->purchase_login_required == 1 && $sess[0]->member_id == 0){?>
        <p><strong><?php echo $this->lang->line('Registered Member');?></strong></p>
        <hr>
            <div id="submit-error" class="alert alert-danger alert-dismissible" role="alert" style="display:none">
                <button type="button" class="close" onClick="$('#submit-error').hide();"><span aria-hidden="true">&times;</span></button>
                This purchase requires an account be created. Please create an account below:
            </div>
        <form method="post" id="form-login-co" action="<?php echo base_url().$sess[0]->lang.'/login'; ?>" class="form-account">
            <div id="signin-error" class="alert alert-danger alert-dismissible" role="alert" style="display:none">
                <button type="button" class="close" onClick="$('#signin-error').hide();"><span aria-hidden="true">&times;</span></button>
                Invalid Email/Password
            </div>
          <div class="form-group">
            <div class="row">
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('Email address');?></label>
                <input type="email" name="email" class="form-control" required>
              </div>
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('Password');?></label>
                <input type="password" name="password" class="form-control" required>
              </div>
              <div class="col-sm-4">
                <label>&nbsp;</label>
                <input name="login" type="submit" class="btn btn-primary btn-block" value="<?php echo $this->lang->line('Login');?>">
              </div>
            </div>
          </div>
                <input type="hidden" name="login" value="1">
            <!-- .login-form -->
            <p class="text-sm space-top"><a href="#forgotpassword" id="forgotpassword-toggle-co"><?php echo $this->lang->line('Forgot your Password');?></a></p>
            <p class="text-sm space-top"><?php echo $this->lang->line('Don’t have an account?');?> <a href="#signup" id="signup-again-co" class="toggle-section"><?php echo $this->lang->line('Sign up here');?></a></p>
        </form>

            <form id="form-register-co" method="post" action="<?php echo base_url().$sess[0]->lang.'/register'?>" class="login-form" style="display: none;">

                <div id="signup-complete-co" class="alert alert-success alert-dismissible" role="alert" style="display:none">
                    <button type="button" class="close" onClick="$('#signup-complete').hide();"><span aria-hidden="true">&times;</span></button>
                    <?php echo $this->lang->line('Thank you for registering with us.');?>
                </div>
                <div id="signup-error-co" class="alert alert-danger alert-dismissible" role="alert" style="display:none">
                    <button type="button" class="close" onClick="$('#signup-error').hide();"><span aria-hidden="true">&times;</span></button>
                    <?php echo $this->lang->line('Email already existing');?>
                </div>
                
                <div class="form-group">
                    <div class="row">
                        <div class="col-sm-3">
                            <label><?php echo $this->lang->line('Email address');?></label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="col-sm-3">
                            <label><?php echo $this->lang->line('Password');?></label>
                            <input type="password" name="password" class="register-password form-control" required>
                        </div>
                        <div class="col-sm-3">
                            <label><?php echo $this->lang->line('Confirm Password');?></label>
                            <input type="password" name="password2" class="form-control" required>
                        </div>
                        <div class="col-sm-3">
                            <label>&nbsp;</label>
                            <input name="login" type="submit" class="btn btn-primary btn-block" value="<?php echo $this->lang->line('Sign up');?>">
                        </div>
                    </div>
                </div>
                <input type="hidden" name="checkout" value="1">
                <input type="hidden" name="save" value="1">
                <p class="text-sm space-top"><?php echo $this->lang->line('Already have an account?');?> <a href="#signin" class="signin-again-co"><?php echo $this->lang->line('Sign in here');?></a></p>
            </form>

            <form method="post" id="form-forgot-co" class="forgot-form" action="<?php echo base_url().$sess[0]->lang?>/forgot" style="display: none;">
                <div id="forgot-complete-co" class="alert alert-success" style="display:none">
                    <button type="button" class="close" onClick="$('#forgot-complete').hide();"><span aria-hidden="true">&times;</span></button>
                    <?php echo $this->lang->line('Your password already send to your email address');?>
                </div>
                <div id="forgot-error-co" class="alert alert-danger" style="display:none">
                    <button type="button" class="close" onClick="$('#forgot-error').hide();"><span aria-hidden="true">&times;</span></button>
                    <?php echo $this->lang->line('Could not find your email address');?>
                </div>
                <div class="form-group">
                    <div class="row">
                        <div class="col-sm-4">
                            <label><?php echo $this->lang->line('Email address');?></label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="col-sm-4">
                            <label>&nbsp;</label>
                            <input name="login" type="submit" class="btn btn-primary btn-block" value="<?php echo $this->lang->line('Send');?>">
                        </div>
                    </div>
                </div>
                <input type="hidden" name="forgot" value="1">
                <input type="hidden" name="save" value="1">
                <p class="text-sm space-top"><?php echo $this->lang->line('Already have an account?');?> <a href="#signin" class="signin-again-co"><?php echo $this->lang->line('Sign in here');?></a></p>
            </form>
            
        <br>
        <?php }?>
        <form method="post" id="payment-form">
          <p><strong><?php echo $this->lang->line('Personal Information');?></strong></p>
          <hr>
          <div class="form-group">
            <div class="row">
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('First Name');?></label>
                <input type="text" name="firstname" class="card-holder-name form-control" value="<?php if(isset($member[0]->firstname)){ echo $member[0]->firstname; }?>" required>
              </div>
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('Last Name');?></label>
                <input type="text" name="lastname" class="form-control" value="<?php if(isset($member[0]->lastname)){ echo $member[0]->lastname; }?>" required>
              </div>
              <?php if($property[0]->purchase_login_required == 0 ) { ?>
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('Email');?></label>
                <input type="text" name="email" class="form-control" value="<?php if(isset($member[0]->email)){ echo $member[0]->email; }?>" required>
              </div>
              <?php } ?>
            </div>
          </div>
          <div class="form-group">
            <div class="row">
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('Address');?></label>
                <input type="text" class="address form-control" name="address" value="<?php if(isset($member[0]->address)){ echo $member[0]->address; }?>" required>
              </div>
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('City');?></label>
                <input type="text" class="city form-control" name="city" value="<?php if(isset($member[0]->city)){ echo $member[0]->city; }?>" required>
              </div>
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('State/Province');?></label>
                <input type="text" class="state form-control" name="state" value="<?php if(isset($member[0]->state)){ echo $member[0]->state;} ?>" required>
              </div>
            </div>
          </div>
          <div class="form-group">
            <div class="row">
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('Zipcode');?></label>
                <input type="text" class="zip form-control" name="zipcode" value="<?php if(isset($member[0]->zipcode)){ echo $member[0]->zipcode;} ?>" required>
              </div>
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('Country');?></label>
                <select class="country form-control" name="country" required>
                  <option value=""> - <?php echo $this->lang->line('Country');?> - </option>
                  <?php 
										foreach($country as $index=>$value){
											if(isset($member[0]->country)){
												if($member[0]->country == $value->code){
													$select = ' selected';
												}else{
													$select = '';
												}
											}
											echo '<option value="'.$value->code.'" '.$select.'>'.$value->name.'</option>';
										}
										?>
                </select>
                
              </div>
            </div>
          </div>
          <div class="form-group">
            <div class="row">
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('Phone');?></label>
                <input type="text" name="phone" class="form-control" value="<?php if(isset($member[0]->phone)){ echo $member[0]->phone;}?>">
              </div>
              <div class="col-sm-4">
                <label><?php echo $this->lang->line('Fax');?></label>
                <input type="text" name="fax" class="form-control" value="<?php if(isset($member[0]->fax)){ echo $member[0]->fax;}?>">
              </div>
            </div>
          </div>
          <br>
          <?php if($has_physical) { ?>
          <p><strong><?php echo $this->lang->line('Delivery Information');?></strong></p>
          <hr>
          <div class="form-group">
            <div class="row">
              <div class="col-sm-12">
                <label class="checkbox">
                  <input type="checkbox" id="delivery-checkbox" value="1">
                  <?php echo $this->lang->line('Delivery to personal information address');?></label>
              </div>
            </div>
          </div>
          <?php
						if(isset($member[0]->delivery)){
							$delivery = json_decode($member[0]->delivery,true);
						}
            ?>
          <div id="delivery-info">
            <div class="form-group">
              <div class="row">
                <div class="col-sm-4">
                  <label><?php echo $this->lang->line('Address');?></label>
                  <input type="text" name="delivery[address]" id="delivery_address" class="form-control" required value="<?php if(isset($delivery['address'])){ echo $delivery['address']; }?>">
                </div>
                <div class="col-sm-4">
                  <label><?php echo $this->lang->line('City');?></label>
                  <input type="text" name="delivery[city]" id="delivery_city" class="form-control" required value="<?php if(isset($delivery['city'])){ echo $delivery['city']; }?>">
                </div>
                <div class="col-sm-4">
                  <label><?php echo $this->lang->line('State/Province');?></label>
                  <input type="text" name="delivery[state]" id="delivery_state" class="form-control" required value="<?php if(isset($delivery['state'])){ echo $delivery['state']; }?>">
                </div>
              </div>
            </div>
            <div class="form-group">
              <div class="row">
                <div class="col-sm-4">
                  <label><?php echo $this->lang->line('Zipcode');?></label>
                  <input type="text" name="delivery[zipcode]" id="delivery_zipcode" class="form-control" value="<?php if(isset($delivery['zipcode'])){ echo $delivery['zipcode']; }?>">
                </div>
                <div class="col-sm-4">
                  <label><?php echo $this->lang->line('Country'); ?></label>
                  <select class="form-control" name="delivery[country]" id="delivery_country_form" required>
                    <option value=""> - <?php echo $this->lang->line('Country');?> -</option>
                    <?php 
										foreach($country as $index=>$value){
											if($value->code == $delivery['country']){
												$select = ' selected';
											}else{
												$select = '';
											}
											echo '<option value="'.$value->code.'" '.$select.' >'.$value->name.'</option>';
										}
										?>
                  </select>
                </div>
              </div>
            </div>
            <br>
            <? } ?>
            <br>
            <div class="form-group">
              <div class="row">
                <div class="col-sm-12"> <strong><?php echo $this->lang->line('Select Payment Method');?></strong>
                  <hr>
                    <br>
                  <div class="row">
                    <div class="col-md-2">
                      <?php 
																		
									foreach($payment as $index=>$value){
										
										if($value->default_payment == 1){
											$check = ' checked';	
										}else{
											$check = '';
										}
										
										echo '<div class="radio">';
										echo '<label>';
										echo '<input type="radio" id="'.str_replace(' ','_',strtolower($value->type)).'" name="payment_type" '.$check.' value="'.$value->type.'" required>' . $value->type;
										echo '</label>';
										echo '</div>';
									}
									?>
                    </div>
                    <div class="col-md-10">
                      <div id="stripe-card" style="margin-top:15px;<?php echo 'display:none'; ?> ">
                      	<div class="row">
                      		<div class="col-md-4">
                      			<img src="/assets/frontend/images/stripe.png" style="width:220px; padding-right: 10px; padding-bottom: 20px;"/>
                      		</div>
                      		<div class="col-md-8">
							  <div class="row m-b" id="a_x200" style="display: none;"> <strong>Error!</strong> <span class="payment-errors"></span> </div>
							  <?php
							  echo '<div class="row m-b">';
							  echo '<div class="col-md-4"><strong>'.$this->lang->line('Card Number').':</strong></div>';
							  echo '<div class="col-md-8"><input type="text" name="stripe_card_number" id="cardnumber" maxlength="19" placeholder="Card Number" class="card-number form-control"></div>';
							  echo '</div>';
							  echo '<div class="row m-b">';
							  echo '<div class="col-md-4"><strong>Card Expiry Date:</strong></div>';
							  echo '<div class="col-md-8 form-inline">';
							  ?>
							  <select name="stripe_select1" data-stripe="exp-month" class="card-expiry-month stripe-sensitive required form-control">
								  <option value="01" selected="selected">01</option>
								  <option value="02">02</option>
								  <option value="03">03</option>
								  <option value="04">04</option>
								  <option value="05">05</option>
								  <option value="06">06</option>
								  <option value="07">07</option>
								  <option value="08">08</option>
								  <option value="09">09</option>
								  <option value="10">10</option>
								  <option value="11">11</option>
								  <option value="12">12</option>
							  </select>
							  <span> / </span>
							  <select name="stripe_select2" data-stripe="exp-year" class="card-expiry-year stripe-sensitive required form-control">
							  </select>
							  <script type="text/javascript">
								  var select = $(".card-expiry-year"),
									  year = new Date().getFullYear();

								  for (var i = 0; i < 12; i++) {
									  select.append($("<option value='"+(i + year)+"' "+(i === 0 ? "selected" : "")+">"+(i + year)+"</option>"))
								  }
							  </script>
							  <div id="stripe-expiry-error" style="display:none;"></div>
							  <?php
							  echo '</div>';
							  echo '</div>';
							  echo '<div class="row m-b">';
							  echo '<div class="col-md-4"><strong>'.$this->lang->line('Security Code (CVC)').':</strong></div>';
							  echo '<div class="col-md-8"><input type="text" name="stripe_card_cvc" id="cvv" placeholder="CVV" maxlength="4" class="card-cvc form-control"></div>';
							  echo '</div>';
							  ?>
						  </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="form-group">
              <div class="row">
                <div class="col-sm-4">
                  <input name="save" type="submit" class="process-checkout btn btn-block btn-primary" value="<?php echo $this->lang->line('Process Checkout');?>">
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</section>
<footer class="footer">
  <div class="container">
    <div class="col-sm-12 text-center">
      <p class="text-sm"><?php echo $this->lang->line('Need support?');?> <a href="mailto:<?php echo $property[0]->property_email;?>"><span class="text-primary"><?php echo $property[0]->property_email;?></span></a></p>
      <div class="social-bar text-center space-bottom">
        <p class="copyright">&copy; <?php echo date("Y"); ?>. Powered by <a href="https://insty.me" target="_blank">Insty!</a></p>
      </div>
    </div>
  </div>
</footer>
<br>
<script>
    jQuery(document).ready(function($) 
    {
        var n = 0;
        $('.checkbox, .iCheck-helper').on('click', function(){
            n++;

            if(n == 1){

                var address = $('input[name=address]').val();
                var city = $('input[name=city]').val();
                var state = $('input[name=state]').val();
                var zipcode = $('input[name=zipcode]').val();
                var country = $('select[name=country]').val();
                $('#delivery_address').val(address);
                $('#delivery_city').val(city);
                $('#delivery_state').val(state);
                $('#delivery_zipcode').val(zipcode);
                $('#delivery_country_form').val(country);
                n = -1;
            }
        });

        function payment_method(val)
        {
            switch(val){
                case 'Bank Transfer':
                    $('#credit-card').hide();
                    $('#stripe-card').hide();
                    $('#bank-transfer').show();
                    $('#payment-form').removeClass('stripe-form');
                    break;
                case'PayPal':
                    $('#credit-card').hide();
                    $('#stripe-card').hide();
                    $('#bank-transfer').hide();
                    $('#payment-form').removeClass('stripe-form');
                    break;
                case'Credit Card':
                {
                    $('#credit-card').show();
                    $('#stripe-card').hide();
                    $('#bank-transfer').hide();

                    $('#payment-form').removeClass('stripe-form');

                    $('#credit-card input, #credit-card select').prop('disabled', false);
                    $('#stripe-card input, #stripe-card select').prop('disabled', true);
                }
                    break;
                case'Stripe':
                {
                    $('#credit-card').hide();
                    $('#bank-transfer').hide();
                    $('#stripe-card').show();

                    $('#payment-form').addClass('stripe-form');

                    $('#credit-card input, #credit-card select').prop('disabled', true);
                    $('#stripe-card input, #stripe-card select').prop('disabled', false);
                }
                    break;
            }

        }


		$('.checkout-item-remove').click(function(){
			cart_id = $(this).attr('data-cart-id');
			url = '<?php echo base_url(),$sess[0]->lang.'/cart/delete?cart_id=';?>'+  cart_id; 		
			$.ajax({
				url: url,
				type: "get"
			}).done(function(msg){
				var refresh = '<?php echo base_url().$sess[0]->lang;?>/checkout';
				window.location.replace( refresh );		
			});
			return false;
		});
	
        $('#paypal').on('change', function(event){
            payment_method('PayPal');
        });
        $('#stripe').on('change', function(event){
            payment_method('Stripe');
        });


        var val = $('input[name=payment_type]:checked').val();
        payment_method(val);
    });
</script>
</body>
</html>