<?php include('tpl.meta.php');?>
<?php include('tpl.header.php');?>
  
  <!-- Google Map --> 
  <!-- Data API:
         data-height="500" height of the map in pixels
         data-address="Your address" string
         data-zoom="number" to control map zoom when loaded
         data-disable-controls="false/true" enable/disable map controls like pan, zoom, etc.
         data-scrollwheel="true/false" enable/disable mouse scroll wheel zoom
         data-marker="path_to_your_image" path to custom marker image
         data-marker-title=" Your title" appears on marker hover
         data-styles="[array]" you can adjust the look and feel of your map. Recommend to use https://snazzymaps.com
     -->
  <div id="map_canvas" style="height:350px;"></div>
  <!-- .google-map --> 
  
  <!-- Container -->
  <section class="container space-top-3x">
    <h1>
      <?php if(isset($content[0]->page_title)){ echo $content[0]->page_title; }?>
    </h1>
    <div class="row padding-top">
      <div class="col-sm-5 padding-bottom-2x">
        <ul class="list-icon">
          <li> <i class="material-icons location_on"></i>
            <?php
									$country = $this->Country->get_code($property[0]->property_country);

									echo $property[0]->property_address; 
									echo ' ';
									echo $property[0]->property_city; 
									echo ' ';
									echo $property[0]->property_state; 
									echo ' ';
									echo $property[0]->property_zipcode; 
									echo ' ';
									echo $country[0]->name; 
?>
          </li>
          <?php if(isset($property[0]->property_phone)){?>
          <li> <i class="material-icons phone"></i>
            <?php  echo $this->lang->line('Phone').': '.$property[0]->property_phone; ?>
          </li>
          <?php }?>
          <?php if(isset($property[0]->property_fax)){ ?>
          <li> <i class="material-icons fax"></i> <?php echo $this->lang->line('Fax').': '.$property[0]->property_fax; ?> </li>
          <?php } ?>
          <?php if(isset($property[0]->property_email)){?>
          <li> <i class="material-icons email"></i> <a href="mailto:<?php echo $property[0]->property_email; ?>"><?php echo $property[0]->property_email; ?></a> </li>
          <?php }?>
        </ul>
        <!-- .list-icon --> 
        <span class="display-inline" style="margin-bottom: 6px;"><?php echo $this->lang->line('Social accounts');?>: &nbsp;&nbsp;</span>
        <div class="social-bar display-inline">
          <?php 
$socials = json_decode($property[0]->social,true);
foreach($socials as $index=>$value){
	if($value){?>
          <a href="<?php echo $value; ?>" class="sb-<?php echo $index; ?>" data-toggle="tooltip" data-placement="top" title="<?php echo ucfirst($index);?>"> <i class="socicon-<?php echo $index;?>"></i> </a>
          <?php
	}
}?>
        </div>
        <!-- .social-bar --> 
      </div>
      <!-- .col-sm-5 -->
      <div class="col-sm-7 padding-bottom-2x">
        <?php if(isset($content[0]->page_detail)){ echo $content[0]->page_detail;} ?>
        
        <?php if($save){?>
				<p style="color: red"><?php echo $this->lang->line('Your message has been send');?></p>
				<?php }?>
        
        <form method="post">
          <div class="contact-form container">
            <div class="row">
              <div class="col-sm-6">
                <div class="form-element">
                  <input type="text" class="form-control" name="contactname" placeholder="<?php echo $this->lang->line('Name');?>">
                </div>
              </div>
              <div class="col-sm-6">
                <div class="form-element">
                  <input type="email" class="form-control" name="email" placeholder="<?php echo $this->lang->line('Email');?>">
                </div>
              </div>
            </div>
            <!-- .row -->
            <div class="form-element">
              <input type="text" class="form-control" name="title" placeholder="<?php echo $this->lang->line('Title');?>">
            </div>
            <div class="form-element">
              <textarea rows="6" class="form-control" name="comments" placeholder="<?php echo $this->lang->line('Message');?>"></textarea>
            </div>
            <div class="row">
              <div class="col-sm-6">
                <div class="g-recaptcha" data-sitekey="<?php echo $recaptcha[0]->apikey; ?>"></div>
              </div>
            </div>
            <br>
            <button type="submit" class="btn btn-primary btn-block waves-effect waves-light space-top-none"><?php echo $this->lang->line('Send Message');?></button>
            <input type="hidden" name="save" value="1">
          </div>
          <div class="status-message"></div>
        </form>
      </div>
      <!-- .col-sm-7 --> 
    </div>
    <!-- .row --> 
  </section>
  <!-- .container -->
  <?php
list($lat, $lng) = explode(',', $property[0]->property_location);
?>
  <script>
var marker;
function initMap() {
	var map = new google.maps.Map(document.getElementById('map_canvas'), {
		zoom: 15,
		center: {lat: <?php echo $lat; ?>, lng: <?php echo $lng; ?>}
	});
	
	marker = new google.maps.Marker({
		map: map,
		animation: google.maps.Animation.DROP,
		position: {lat: <?php echo $lat; ?>, lng: <?php echo $lng; ?>}
	});
	marker.addListener('click', toggleBounce);								
}
function toggleBounce() {
	if (marker.getAnimation() !== null) {
		marker.setAnimation(null);
	} else {
		marker.setAnimation(google.maps.Animation.BOUNCE);
	}
}

</script> 
  <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo $googlemap[0]->apikey; ?>&callback=initMap"> </script> 
  <script src='https://www.google.com/recaptcha/api.js'></script>
  <?php
include('tpl.footer.php');
?>
