<?php include('tpl.meta.php');?>
<?php include('tpl.header.php');?>
  <!-- Content -->
  <section class="container padding-top-3x padding-bottom">
    <div class="row space-top space-bottom-2x">
      <h1><?php echo $this->lang->line('Thank you for your order')?> #invoice <?php echo $invoice[0]->id; ?></h1>
      <p><?php echo $this->lang->line('Thank you for shopping with us. We have received your order and it is currently being processed');?></p>
      <p><strong><?php echo $this->lang->line('Customer information');?></strong></p>
      <?php 
					$customer = json_decode($invoice[0]->customer, true);
					$country = $this->Country->get_code($customer['country']);
					$items = json_decode($invoice[0]->item,true);

					echo '<p>';
					echo $customer['firstname'] . ' '.$customer['lastname'].'<br>';
					echo '<strong>'.$this->lang->line('Address').'</strong>: ' . $customer['address'] . ' '.$customer['city'] . ' ';
					echo $customer['state'] . ' '. $customer['zipcode']. ' '.$country[0]->name. '<br>';
					echo '<strong>'.$this->lang->line('Phone').'</strong>: '.$customer['phone']. ' ';
					echo '<strong>'.$this->lang->line('Fax').'</strong>: '.$customer['fax'] . ' ';
					echo '<strong>'.$this->lang->line('Email').'</strong>: <a href="mailto:'.$invoice[0]->customer_email.'">'.$invoice[0]->customer_email.'</a>';
					echo '</p>';
					echo '<br>';
					?>
      <p><strong><?php echo $this->lang->line('Order Information');?></strong></p>
      <table class="table" style="border: solid 1px #EEE;">
        <thead>
          <tr>
            <th nowrap="nowrap"><?php echo $this->lang->line('Product Name');?></th>
            <th width="68" nowrap="nowrap"><?php echo $this->lang->line('Qty');?></th>
            <th width="66" nowrap="nowrap"><?php echo $this->lang->line('Unit Price');?></th>
            <th width="31" nowrap="nowrap"><?php echo $this->lang->line('Cost');?></th>
            <th width="26" nowrap="nowrap"><?php echo $this->lang->line('Tax');?></th>
            <th nowrap="nowrap" class="text-right"><?php echo $this->lang->line('Total');?></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($items as $index=>$value){?>
          <tr>
            <td nowrap="nowrap"><?php 
						echo $value['code']. ' - '.$value['name']; 
												
						$options = json_decode($value['options'],true);
						
						if(isset($options['Size'])){ echo ' Size : '. $options['Size']. ' ';}
						if(isset($options['Color'])){ echo ' Color : '.$options['Color']; }
						?></td>
            <td nowrap="nowrap"><?php echo $value['unit']; ?></td>
            <td nowrap="nowrap"><?php echo $value['unit_price']; ?></td>
            <td nowrap="nowrap"><?php echo $value['total_cost'];?></td>
            <td nowrap="nowrap"><?php echo $value['total_tax'];?></td>
            <td align="right" nowrap="nowrap"><?php echo $value['total']; ?></td>
          </tr>
          <?php }?>
        </tbody>
        <?php $currency = $this->Currency->get_code($invoice[0]->currency); ?>
        <tr>
          <td colspan="5" align="right" nowrap="nowrap"><strong><?php echo $this->lang->line('Total Cost');?>:</strong></td>
          <td width="80" align="right" nowrap="nowrap"><strong><?php echo $invoice[0]->cost?></strong></td>
        </tr>
        <tr>
          <td colspan="5" align="right" nowrap="nowrap"><strong><?php echo $this->lang->line('Total Tax');?>:</strong></td>
          <td align="right" nowrap="nowrap"><strong><?php echo $invoice[0]->tax; ?></strong></td>
        </tr>
        <tr>
          <td colspan="5" align="right" nowrap="nowrap"><strong><?php echo $this->lang->line('Shipping');?>:</strong></td>
          <td align="right" nowrap="nowrap"><strong><?php echo $invoice[0]->delivery; ?> </strong></td>
        </tr>
        <tr>
          <td colspan="4" nowrap="nowrap" >* <?php echo $this->lang->line('Currencies are in');?> <?php echo $currency[0]->name; ?></td>
          <td align="right" nowrap="nowrap"><strong><?php echo $this->lang->line('Grand Total');?>:</strong></td>
          <td align="right" nowrap="nowrap"><strong><?php echo $invoice[0]->total; ?></strong></td>
        </tr>
        <?php
					$delivery = json_decode($invoice[0]->customer_delivery,true);
          $rs = $this->Country->get_code($delivery['country']);
          ?>
        <tr>
          <td colspan="6" valign="top" nowrap><strong><?php echo $this->lang->line('Delivery to address');?></strong>: 
          <strong><?php 
								echo $delivery['address']. ' ';
                echo $delivery['city'].' ';
                echo $delivery['state'].' ';
                echo $delivery['zipcode'].' ';
                echo $rs[0]->name.' ';
                ?></strong></td>
        </tr>
      </table>
      <?php 					
					if($invoice[0]->payment_type == 'Bank Transfer'){

						$banktransfer = $this->Payment->get_setting_type('Bank Transfer');
						?>
      <p><?php echo $this->lang->line('You can make payments by making transactions directly to seller\'s bank account. Details are as follow');?>:</p>
      <table class="table" style="border: solid 1px #EEE;">
        <tbody>
          <tr>
            <td><strong><?php echo $this->lang->line('Bank');?></strong></td>
            <td><strong><?php echo $this->lang->line('Branch');?></strong></td>
            <td><strong><?php echo $this->lang->line('Account number');?></strong></td>
            <td><strong><?php echo $this->lang->line('Account type');?></strong></td>
            <td><strong><?php echo $this->lang->line('Account name');?></strong></td>
          </tr>
          <?php 
							foreach($banktransfer as $index=>$value){ 
								$arr = json_decode($value->detail, true);
															?>
          <tr>
            <td><?php echo $arr['bankname']; ?></td>
            <td><?php echo $arr['branch']; ?></td>
            <td><?php echo $arr['accountnumber']?></td>
            <td><?php echo $arr['accounttype'];?></td>
            <td><?php echo $arr['accountname'];?></td>
          </tr>
          <?php }?>
        </tbody>
      </table>
      <?php
					}
					?>
    </div>
  </section>
  <?php include('tpl.footer.php');?>