<div class="shopping-cart">
  <?php 
	if(count($cart) == false){
	?>
  <h3 class="toolbar-title space-bottom text-center"> <?php echo $this->lang->line('Your shopping cart isn\'t create yet. Please add our product to your shopping cart');?> </h3>
  <?php
	}else{
		?>
  <form id="form-cart" method="post" action="<?php echo base_url().$sess[0]->lang;?>/cart/update">
    <?php
		foreach($cart as $index=>$value){
			$url = base_url().$sess[0]->lang.'/products/'.$value->product_id;	
			$options = json_decode($value->options, true);
			?>
    <div class="item"> <a href="<?php echo $url; ?>" class="item-thumb"> <img src="<?php echo base_url().'slide/'.$value->thumbnail.'/450x450';?>" alt="<?php echo $value->product_name; ?>"> </a>
      <div class="item-details">
        <h3 class="item-title"><a href="<?php echo $url; ?>"><?php echo $value->product_name; ?></a></h3>
        <h4 class="item-price"> <span class="<?php echo $sess[0]->currency;?>"> <?php echo $value->total;?></span> 
				<?php 
				if(count($options)){ 
					echo '<small class="pull-right">';
					if(isset($options['Size'])){ echo $this->lang->line('Size').' : '.$options['Size']; }
					echo ' ';
					if(isset($options['Color'])){ echo $this->lang->line('Color').' : '.$options['Color']; }
					echo '</small>'; 
				}
				?>
        </h4>
        <div class="count-input"> <a class="incr-btn" data-action="decrease" href="#">–</a>
          <input class="quantity" name="unit[]" type="text" value="<?php echo $value->unit; ?>">
          <a class="incr-btn" data-action="increase" href="#">+</a> </div>
      </div>
      <a href="#" data-cart-id="<?php echo $value->cart_id; ?>" class="cart-item-remove item-remove" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('Remove');?>"> <i class="material-icons remove_shopping_cart"></i> </a>
      <input type="hidden" name="price[]" value="<?php echo $value->price; ?>">
      <input type="hidden" name="cart_id[]" value="<?php echo $value->cart_id; ?>">
      <input type="hidden" name="tax[]" value="<?php echo $value->tax; ?>">
    </div>

    <?php 
		}
		?>
    <div class="cart-subtotal">
      <div class="column">
        <h3 class="toolbar-title"><?php echo $this->lang->line('Delivery');?>:</h3>
      </div>
      <div class="column">
        <div class="form-element form-select">
          <select id="delivery_country" name="country" class="form-control">
            <?php
					foreach($shipping_available as $index=>$value){
						echo '<option value="'.$value->code.'">'.$value->name.'</option>';
					}?>
          </select>
        </div>
      </div>
    </div>
    <div class="cart-subtotal">
      <div class="column">
        <h3 class="toolbar-title"><?php echo $this->lang->line('Sub Total');?>:</h3>
      </div>
      <div class="column">
        <h3 class="amount <?php echo $sess[0]->currency;?>"><?php echo money_format('%i', $sumcart[0]->cart_total);  ?></h3>
      </div>
    </div>
    <?php if($sumcart[0]->cart_tax > 0){?>
    <div class="cart-subtotal">
      <div class="column">
        <h3 class="toolbar-title"><?php echo $this->lang->line('Tax');?>:</h3>
      </div>
      <div class="column">
        <h3 class="amount <?php echo $sess[0]->currency;?>"><?php echo money_format('%i', $sumcart[0]->cart_tax); ?></h3>
      </div>
    </div>
    <?php }?>
    <div class="cart-subtotal">
      <div class="column">
        <h3 class="toolbar-title"><?php echo $this->lang->line('Delivery Cost');?>:</h3>
      </div>
      <div class="column">
        <h3 id="delivery-cost" class="amount <?php echo $sess[0]->currency;?>">&nbsp;   </h3>
      </div>
    </div>
    <div class="cart-subtotal space-bottom">
      <div class="column">
        <h3 class="toolbar-title"><?php echo $this->lang->line('Grand Total');?>:</h3>
      </div>
      <div class="column">
        <h3 class="amount <?php echo $sess[0]->currency;?>"> 
				<span id="grand-total"><?php echo money_format('%i', $sumcart[0]->grand_total);  ?></span></h3>
      </div>
    </div>
    <div class="text-right">
      <button id="close-cart" type="button" class="btn btn-default btn-ghost"><?php echo $this->lang->line('Continue Shopping');?></button>
      <button id="update-cart" type="submit" class="btn btn-warning btn-ghost"><?php echo $this->lang->line('Update Shopping Cart');?></button>
      <button type="submit" class="btn btn-primary waves-effect waves-light"><?php echo $this->lang->line('Proceed to Checkout');?></button>
      <input type="hidden" name="currency" value="<?php echo $sumcart[0]->currency;?>">
      <input type="hidden" id="delivery_weight" name="weight" value="<?php echo $sumcart[0]->cart_weight;?>">
      <input type="hidden" name="save" value="1">
      <input type="hidden" name="cost" value="">
    </div>
  </form>
<script>
	
	$('#close-cart').click(function(){
		$('.toolbar-toggle').each(function(){
			if($(this).hasClass('active')){
				$(this).removeClass('active');
			}
		});
		$('.toolbar-dropdown').removeClass('open');
	});
	
	// update cart
	$('#update-cart').click(function(){
		$.ajax({
			url: '<?php echo base_url(),$sess[0]->lang.'/cart/update';?>', 
			type: "POST",
			data: $('#form-cart').serialize()
		}).done(function(msg){
			$('#cart').load('<?php echo base_url().$sess[0]->lang;?>/cart/ajaxcart',function(){
			});
		});
		return false;
	});

	// caculated delivery cost
	function delivery_cost(country, weight)
	{
		$.ajax({
			url: '<?php echo base_url(),$sess[0]->lang.'/cart/shipping_cost?country=';?>'+ country + '&weight='+weight, 
			type: "GET"   
		}).done(function(msg){
			
			val = <?php if($sumcart[0]->grand_total > 0){ echo money_format('%i', $sumcart[0]->grand_total); }else{ echo '0';}?>;
			value = eval(msg) + eval(val); 
			
			$('#delivery-cost').html(msg);
			$('input[name=cost]').val(msg);
			$('#grand-total').html(value.toFixed(2));
		});
	}
	
	delivery_cost($('#delivery_country').val(), $('#delivery_weight').val());
	
	$('.cart-item-remove').click(function(){
		cart_id = $(this).attr('data-cart-id');
		url = '<?php echo base_url(),$sess[0]->lang.'/cart/delete?cart_id=';?>'+  cart_id; 		
		$.ajax({
			url: url,
			type: "get"
		}).done(function(msg){
			$('#cart').load('<?php echo base_url().$sess[0]->lang;?>/cart/ajaxcart',function(){
				val = eval($('#count-cart').html())-1;
				$('#count-cart').html(val);
				if(val == 0){
					$('#count-cart').fadeOut();
				}
			});			
		});
		return false;
	});
	
	// Count Input (Quantity)
	//------------------------------------------------------------------------------
	$("#cart .incr-btn").on("click", function(e) {
		var $button = $(this);
		var oldValue = $button.parent().find('.quantity').val();
		$button.parent().find('.incr-btn[data-action="decrease"]').removeClass('inactive');
		if ($button.data('action') == "increase") {
			var newVal = parseFloat(oldValue) + 1;
		} else {
		 // Don't allow decrementing below 1
			if (oldValue > 1) {
				var newVal = parseFloat(oldValue) - 1;
			} else {
				newVal = 1;
				$button.addClass('inactive');
			}
		}
		$button.parent().find('.quantity').val(newVal);
		e.preventDefault();
	});

	$tooltip = $('[data-toggle="tooltip"]');
	$tooltip.tooltip();
	
</script>
  <?php }?>
</div>
