jQuery(document).ready(function($) {

	$('#forgotpassword-toggle-co').click(function(){
		$('#form-login-co').removeClass('form-account').hide();
		$('#form-register-co').removeClass('form-account').hide();
		$('#form-forgot-co').addClass('form-account').fadeIn();
	});

	$('.signin-again-co').click(function(){
		$('#form-login-co').addClass('form-account').fadeIn();
		$('#form-register-co').removeClass('form-account').hide();
		$('#form-forgot-co').removeClass('form-account').hide();
	});

	$('#signup-again-co').click(function(){
		$('#form-login-co').removeClass('form-account').hide();
		$('#form-register-co').addClass('form-account').fadeIn();
		$('#form-forgot-co').removeClass('form-account').hide();
	});

	$('#form-login-co').validate({
		submitHandler: function() {
			$.ajax({
				url: $('#form-login-co').attr('action'),
				type: "post",
				data: $('#form-login-co').serialize(),
				success: function(msg){
					if(msg == 'save'){
						window.location.reload();
					}else{
						$('#signin-error-co').fadeIn();
					}
				}
			});
			return false;
		}
	});
	
	$('#form-forgot-co').validate({
		submitHandler: function() {
			$.ajax({
				url: $('#form-forgot-co').attr('action'),
				type: "post",
				data: $('#form-forgot-co').serialize(),
				success: function(msg){
					if(msg == 'save'){
						$('#forgot-complete-co').fadeIn();
						$('#forgot-error-co').hide();
					}else{
						$('#forgot-complete-co').hide();
						$('#forgot-error-co').fadeIn();
					}
				}
			});
			return false;
		}
	});

	$('#form-register-co').validate({
		rules : {
			password : {
				minlength : 5
			},
			password2 : {
				minlength : 5,
				equalTo : ".register-password"
			}
		},
		submitHandler: function() {
			$.ajax({
				url: $('#form-register-co').attr('action'),
				type: "post",
				data: $('#form-register-co').serialize(),
				success: function(msg){
					if(msg == 'save'){
						$('#signup-complete-co').fadeIn();
						$('#signup-error-co').hide();
					}else{
						$('#signup-error-co').fadeIn();
						$('#signup-complete-co').hide();
					}
				}
			});
			return false;
		}
	});

	$.validator.addMethod("checkMonth",
		function(value, element, params)
		{
			value = parseInt(value, 10);
			var year         = $(params).val(),
				currentMonth = new Date().getMonth() + 1,
				currentYear  = new Date().getFullYear();
			if (value < 0 || value > 12) {
				return false;
			}
			if (year == '') {
				return true;
			}
			year = parseInt(year, 10);
			if (year > currentYear || (year == currentYear && value > currentMonth)) {
				return true;
			} else {
				return false;
			}
		},
		'Expired'
	);

	$.validator.addMethod("checkYear",
		function(value, element, params)
		{
			value = parseInt(value, 10);
			var month        = $(params).val(),
				currentMonth = new Date().getMonth() + 1,
				currentYear  = new Date().getFullYear();
			if (value < currentYear || value > currentYear + 100) {
				return false;
			}
			if (month == '') {
				return false;
			}
			month = parseInt(month, 10);
			if (value > currentYear || (value == currentYear && month > currentMonth)) {
				return true;
			} else {
				return false;
			}
		},
		'Expired'
	);

	$('#payment-form').validate({
		rules: {
			stripe_card_number: {
				required: true,
				minlength: 16,
				maxlength: 16
			},
			stripe_card_cvc: {
				required: true,
				minlength: 3,
				maxlength: 4
			}
		},
		groups: {
			username: "stripe_select1 stripe_select2"
		},
		errorPlacement: function(error, element) {
			if (element.attr("name") == "stripe_select1")
			{
				error.appendTo('#stripe-expiry-error');
				$('#stripe-expiry-error').css('display', 'block');
			}
			else if (element.attr("name") == "stripe_select2")
			{
				error.appendTo('#stripe-expiry-error');
				$('#stripe-expiry-error').css('display', 'block');
			}
			else
			{
				error.insertAfter(element);
			}
		},
		submitHandler: function() {
			//if exist login or register or forgot form
			if($('form').is('.form-account')){
				var id = $('form.form-account').attr('id');
				$('#submit-error').fadeIn();
				$('#'+id+' input[name="email"]').focus();
				return false;
			}

			if($('#payment-form').hasClass('stripe-form'))
			{
				$('input.process-checkout').prop('disabled', true);
				$('.page-preloading.loading-done .page-preloader').css({'visibility':'visible', 'opacity':0.5});
				Stripe.card.createToken({
					number: $('.card-number').val(),
					cvc: $('.card-cvc').val(),
					exp_month: $('.card-expiry-month').val(),
					exp_year: $('.card-expiry-year').val(),
					name: $('.card-holder-name').val(),
					address_line1: $('.address').val(),
					address_city: $('.city').val(),
					address_zip: $('.zip').val(),
					address_state: $('.state').val(),
					address_country: $('.country').val()
				}, stripeResponseHandler);
				return false; // submit from callback
			}else{
				return true;
			}
		}
	});

	$('[data-stripe="exp-month"]').rules('add', { checkMonth: '[data-stripe="exp-year"]' });
	$('[data-stripe="exp-year"]').rules('add', { checkYear: '[data-stripe="exp-month"]' });

});/*Document Ready End*/
