jQuery(document).ready(function($) {
    /*--------------------------------------
        Header Color
    ---------------------------------------*/
    $('body').on('click', '.hc-trigger', function() {
        $(this).parent().toggleClass('toggled');
    });
    
    $('body').on('click', '.hc-item', function() {
        var v = $(this).data('ma-header-value');

        $('.hc-item').removeClass('selected');
        $(this).addClass('selected');


        $('body').attr('data-ma-header', v);
    });

    /*--------------------------------------
        Animation
     ---------------------------------------*/
    $('body').on('click', '.animation-demo .btn', function(){
        var animation = $(this).text();
        var cardImg = $(this).closest('.card').find('img');
        if (animation === "hinge") {
            animationDuration = 2100;
        }
        else {
            animationDuration = 1200;
        }

        cardImg.removeAttr('class');
        cardImg.addClass('animated '+animation);

        setTimeout(function(){
            cardImg.removeClass(animation);
        }, animationDuration);
    });


    /*--------------------------------------
         Notifications & Dialogs
     ---------------------------------------*/
    /*
     * Notifications
     */
    function notify(from, align, icon, type, animIn, animOut){
        $.growl({
            icon: icon,
            title: ' Bootstrap Growl ',
            message: 'Turning standard Bootstrap alerts into awesome notifications',
            url: ''
        },{
            element: 'body',
            type: type,
            allow_dismiss: true,
            placement: {
                from: from,
                align: align
            },
            offset: {
                x: 30,
                y: 30
            },
            spacing: 10,
            z_index: 1031,
            delay: 2500,
            timer: 1000,
            url_target: '_blank',
            mouse_over: false,
            animate: {
                enter: animIn,
                exit: animOut
            },
            icon_type: 'class',
            template: '<div data-growl="container" class="alert" role="alert">' +
            '<button type="button" class="close" data-growl="dismiss">' +
            '<span aria-hidden="true">&times;</span>' +
            '<span class="sr-only">Close</span>' +
            '</button>' +
            '<span data-growl="icon"></span>' +
            '<span data-growl="title"></span>' +
            '<span data-growl="message"></span>' +
            '<a href="#" data-growl="url"></a>' +
            '</div>'
        });
    };

    $('.notifications > div > .btn').click(function(e){
        e.preventDefault();
        var nFrom = $(this).attr('data-from');
        var nAlign = $(this).attr('data-align');
        var nIcons = $(this).attr('data-icon');
        var nType = $(this).attr('data-type');
        var nAnimIn = $(this).attr('data-animation-in');
        var nAnimOut = $(this).attr('data-animation-out');

        notify(nFrom, nAlign, nIcons, nType, nAnimIn, nAnimOut);
    });


    /*
     * Dialogs
     */

    //Basic
    $('#sa-basic').click(function(){
        swal("Here's a message!");
    });

    //A title with a text under
    $('#sa-title').click(function(){
        swal("Here's a message!", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed lorem erat, tincidunt vitae ipsum et, pellentesque maximus enim. Mauris eleifend ex semper, lobortis purus sed, pharetra felis")
    });

    //Success Message
    $('#sa-success').click(function(){
        swal("Good job!", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed lorem erat, tincidunt vitae ipsum et, pellentesque maximus enim. Mauris eleifend ex semper, lobortis purus sed, pharetra felis", "success")
    });

    //Warning Message
    $('#sa-warning').click(function(){
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this imaginary file!",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: false
        }, function(){
            swal("Deleted!", "Your imaginary file has been deleted.", "success");
        });
    });

    //Parameter
    $('#sa-params').click(function(){
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this imaginary file!",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, delete it!",
            cancelButtonText: "No, cancel plx!",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm){
            if (isConfirm) {
                swal("Deleted!", "Your imaginary file has been deleted.", "success");
            } else {
                swal("Cancelled", "Your imaginary file is safe :)", "error");
            }
        });
    });

    //Custom Image
    $('#sa-image').click(function(){
        swal({
            title: "Sweet!",
            text: "Here's a custom image.",
            imageUrl: "img/thumbs-up.png"
        });
    });

    //Auto Close Timer
    $('#sa-close').click(function(){
        swal({
            title: "Auto close alert!",
            text: "I will close in 2 seconds.",
            timer: 2000,
            showConfirmButton: false
        });
    });

    /*--------------------------------------
        Components
     ---------------------------------------*/
    $('body').on('click', '#btn-color-targets > .btn', function(){
        var color = $(this).data('target-color');
        $('#modalColor').attr('data-modal-color', color);
    });


    //admin Payment settings - checkbox checkbox-stripe-sandbox
    //for display required fields stripe_test_secret_key & stripe_test_public_key
    //----------------------------
    $('.checkbox-stripe-sandbox').change(function(e){
        if($(this).prop("checked")){
            $('.stripe-test-secret-key, .stripe-test-public-key').prop('required',true);
        }else{
            $('.stripe-test-secret-key, .stripe-test-public-key').prop('required',false);
        }
    });

    $('#interval').change(function(e){
        if($(this).val() == 'custom'){
            $('.interval-count').css('display', 'block');
            //$('#custom_interval_count, #custom_interval').prop('required',true).prop('disabled',false);
        }else{
            $('.interval-count').css('display', 'none');
            //$('#custom_interval_count, #custom_interval').prop('required',false).prop('disabled',true);
        }
    });

    $('#custom_interval').change(function(e){
        $('select[name="custom_interval_count"]').prop('required',false).prop('disabled',true).css('display', 'none');
        $('#custom_interval_count_'+$(this).val()).prop('required',true).prop('disabled',false).css('display', 'block');
    });

    $('#product_payment_type').change(function (e) {
        $('#product_payment_type option').each(function(){
            $('#product_payment_type_'+$(this).val()).css('display', 'none');

            $('#product_payment_type_'+$(this).val()+' select, #product_payment_type_'+$(this).val()+' input').each(function(){
                if($(this).prop('required')){
                    $(this).prop('required',false);//.prop('disabled',true)
                }
            });
        });

        $('#product_payment_type_'+$(this).val()).css('display', 'block');
        $('#product_payment_type_'+$(this).val()+' select, #product_payment_type_'+$(this).val()+' input').each(function(){
            if($(this).attr('data-required')){
                $(this).prop('required',true);//.prop('disabled',false)
            }
        });
    });

    $('#add_product_plan').click(function() {
        $('#product_subscription_default option:selected').each(function(el) {
            $(this).appendTo('#product_subscription');
        });
    });

    $('#remove_product_plan').click(function() {
        $('#product_subscription option:selected').each(function(el) {
            $(this).appendTo('#product_subscription_default');
        });
    });

    $('.selected_product_subscription').click(function (e) {
        $('#product_subscription option').each(function(el) {
            $(this).prop('selected', true);
        });
    })
});